/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.common.asset.GSAssetHandle;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSIAssetHistory;
import com.g4mesoft.captureplayback.common.asset.GSIAssetHistoryListener;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.SortedSet;
import java.util.TreeSet;
import java.util.UUID;

public class GSAssetHistory
implements GSIAssetHistory {
    private static final byte SUPPORTED_FILE_VERSION = 0;
    private final SortedSet<GSAssetInfo> infoSet = new TreeSet<GSAssetInfo>();
    private final Map<UUID, GSAssetInfo> uuidToInfo = new HashMap<UUID, GSAssetInfo>();
    private final Map<GSAssetHandle, GSAssetInfo> handleToInfo = new HashMap<GSAssetHandle, GSAssetInfo>();
    private final List<GSIAssetHistoryListener> listeners = new ArrayList<GSIAssetHistoryListener>();

    public GSAssetHistory() {
    }

    public GSAssetHistory(GSIAssetHistory history) {
        this();
        for (GSAssetInfo info : history) {
            this.addImpl(new GSAssetInfo(info));
        }
    }

    @Override
    public void addListener(GSIAssetHistoryListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null!");
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(GSIAssetHistoryListener listener) {
        this.listeners.remove(listener);
    }

    private void dispatchHistoryChanged(UUID assetUUID) {
        for (GSIAssetHistoryListener listener : this.listeners) {
            listener.onHistoryChanged(assetUUID);
        }
    }

    @Override
    public boolean contains(UUID assetUUID) {
        return this.uuidToInfo.containsKey(assetUUID);
    }

    @Override
    public boolean containsHandle(GSAssetHandle handle) {
        return this.handleToInfo.containsKey(handle);
    }

    @Override
    public GSAssetInfo get(UUID assetUUID) {
        return this.uuidToInfo.get(assetUUID);
    }

    @Override
    public GSAssetInfo getFromHandle(GSAssetHandle handle) {
        return this.handleToInfo.get(handle);
    }

    @Override
    public void add(GSAssetInfo info) {
        this.addImpl(info);
        this.dispatchHistoryChanged(info.getAssetUUID());
    }

    @Override
    public void addAll(Iterable<GSAssetInfo> iterable) {
        for (GSAssetInfo info : iterable) {
            this.addImpl(new GSAssetInfo(info));
        }
        this.dispatchHistoryChanged(null);
    }

    private void addImpl(GSAssetInfo info) {
        GSAssetInfo oldInfo = this.get(info.getAssetUUID());
        if (oldInfo != null) {
            this.infoSet.remove(oldInfo);
            if (oldInfo.getHandle() != null) {
                this.handleToInfo.remove(oldInfo.getHandle());
            }
        }
        this.infoSet.add(info);
        this.uuidToInfo.put(info.getAssetUUID(), info);
        if (info.getHandle() != null) {
            if (this.handleToInfo.containsKey(info.getHandle())) {
                throw new IllegalStateException("Duplicate asset handle");
            }
            this.handleToInfo.put(info.getHandle(), info);
        }
    }

    @Override
    public GSAssetInfo remove(UUID assetUUID) {
        GSAssetInfo info = this.uuidToInfo.remove(assetUUID);
        if (info != null) {
            this.infoSet.remove(info);
            this.handleToInfo.remove(info.getHandle());
            this.dispatchHistoryChanged(info.getAssetUUID());
        }
        return info;
    }

    @Override
    public void set(GSIAssetHistory other) {
        this.clearImpl();
        this.addAll(other);
    }

    @Override
    public void clear() {
        this.clearImpl();
        this.dispatchHistoryChanged(null);
    }

    private void clearImpl() {
        this.infoSet.clear();
        this.uuidToInfo.clear();
        this.handleToInfo.clear();
    }

    public void setAssetName(UUID assetUUID, String name) {
        GSAssetInfo info = this.get(assetUUID);
        if (info != null && !name.equals(info.getAssetName())) {
            info.setAssetName(name);
            this.dispatchHistoryChanged(assetUUID);
        }
    }

    public void setLastModifiedTimestamp(UUID assetUUID, long timestamp) {
        GSAssetInfo info = this.get(assetUUID);
        if (info != null && timestamp != info.getLastModifiedTimestamp()) {
            this.infoSet.remove(info);
            info.setLastModifiedTimestamp(timestamp);
            this.infoSet.add(info);
            this.dispatchHistoryChanged(assetUUID);
        }
    }

    public void setOwnerUUID(UUID assetUUID, UUID ownerUUID) {
        GSAssetInfo info = this.get(assetUUID);
        if (info != null && !ownerUUID.equals(info.getOwnerUUID())) {
            info.setOwnerUUID(ownerUUID);
            this.dispatchHistoryChanged(assetUUID);
        }
    }

    public boolean addCollaborator(UUID assetUUID, UUID collabUUID) {
        GSAssetInfo info = this.get(assetUUID);
        if (info != null && !info.isCollaborator(collabUUID)) {
            info.addCollaborator(collabUUID);
            this.dispatchHistoryChanged(assetUUID);
            return true;
        }
        return false;
    }

    public boolean removeCollaborator(UUID assetUUID, UUID collabUUID) {
        GSAssetInfo info = this.get(assetUUID);
        if (info != null && info.isCollaborator(collabUUID)) {
            info.removeCollaborator(collabUUID);
            this.dispatchHistoryChanged(assetUUID);
            return true;
        }
        return false;
    }

    @Override
    public int size() {
        return this.infoSet.size();
    }

    @Override
    public boolean isEmpty() {
        return this.infoSet.isEmpty();
    }

    public SortedSet<GSAssetInfo> asCollection() {
        return Collections.unmodifiableSortedSet(this.infoSet);
    }

    @Override
    public Iterator<GSAssetInfo> iterator() {
        return this.asCollection().iterator();
    }

    public static GSAssetHistory read(GSDecodeBuffer buf) throws IOException {
        byte fileVersion = buf.readByte();
        if (fileVersion != 0) {
            throw new IOException("Unexpected file version " + Integer.toHexString(fileVersion));
        }
        int infoCount = buf.readInt();
        if (infoCount < 0) {
            throw new IOException("Corrupted history file");
        }
        GSAssetHistory history = new GSAssetHistory();
        for (int i = 0; i < infoCount; ++i) {
            history.add(GSAssetInfo.read(buf));
        }
        return history;
    }

    public static void write(GSEncodeBuffer buf, GSIAssetHistory history) throws IOException {
        buf.writeByte((byte)0);
        buf.writeInt(history.size());
        for (GSAssetInfo info : history) {
            GSAssetInfo.write(buf, info);
        }
    }
}

