/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.common.asset.GSDecodedAssetFile;
import com.g4mesoft.captureplayback.module.client.GSCapturePlaybackClientModule;
import com.g4mesoft.captureplayback.module.client.GSClientAssetManager;
import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.core.server.GSServerController;
import com.g4mesoft.packet.GSIPacket;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3222;

public class GSAssetRequestResponsePacket
implements GSIPacket {
    private GSEAssetRequestResponse response;
    private UUID assetUUID;
    private GSDecodedAssetFile assetFile;

    public GSAssetRequestResponsePacket() {
    }

    public GSAssetRequestResponsePacket(UUID assetUUID) {
        if (assetUUID == null) {
            throw new IllegalArgumentException("assetUUID is null");
        }
        this.response = GSEAssetRequestResponse.DENIED;
        this.assetUUID = assetUUID;
        this.assetFile = null;
    }

    public GSAssetRequestResponsePacket(GSDecodedAssetFile assetFile) {
        if (assetFile == null) {
            throw new IllegalArgumentException("assetFile is null");
        }
        this.assetUUID = assetFile.getAsset().getUUID();
        this.response = GSEAssetRequestResponse.SUCCESS;
        this.assetFile = assetFile.copy();
    }

    public void read(GSDecodeBuffer buf) throws IOException {
        this.response = GSEAssetRequestResponse.fromIndex(buf.readUnsignedByte());
        if (this.response == null) {
            throw new IOException("Unknown response");
        }
        switch (this.response.ordinal()) {
            case 0: {
                this.assetUUID = buf.readUUID();
                break;
            }
            case 1: {
                this.assetFile = GSDecodedAssetFile.read(buf);
            }
        }
    }

    public void write(GSEncodeBuffer buf) throws IOException {
        buf.writeUnsignedByte((short)this.response.getIndex());
        switch (this.response.ordinal()) {
            case 0: {
                buf.writeUUID(this.assetUUID);
                break;
            }
            case 1: {
                GSDecodedAssetFile.write(buf, this.assetFile);
            }
        }
    }

    public void handleOnServer(GSServerController controller, class_3222 player) {
    }

    @Environment(value=EnvType.CLIENT)
    public void handleOnClient(GSClientController controller) {
        GSCapturePlaybackClientModule module = (GSCapturePlaybackClientModule)controller.getModule(GSCapturePlaybackClientModule.class);
        if (module != null) {
            GSClientAssetManager assetManager = module.getAssetManager();
            switch (this.response.ordinal()) {
                case 0: {
                    assetManager.onAssetRequestDenied(this.assetUUID);
                    break;
                }
                case 1: {
                    assetManager.onAssetRequestSuccess(this.assetFile);
                }
            }
        }
    }

    private static enum GSEAssetRequestResponse {
        DENIED(0),
        SUCCESS(1);

        private final int index;

        private GSEAssetRequestResponse(int index) {
            this.index = index;
        }

        public int getIndex() {
            return this.index;
        }

        private static GSEAssetRequestResponse fromIndex(int index) {
            switch (index) {
                case 0: {
                    return DENIED;
                }
                case 1: {
                    return SUCCESS;
                }
            }
            return null;
        }
    }
}

