/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.CapturePlaybackMod;
import com.g4mesoft.captureplayback.common.asset.GSAbstractAsset;
import com.g4mesoft.captureplayback.common.asset.GSAbstractPlayerCache;
import com.g4mesoft.captureplayback.common.asset.GSAssetFileHeader;
import com.g4mesoft.captureplayback.common.asset.GSAssetHandle;
import com.g4mesoft.captureplayback.common.asset.GSAssetHistory;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSAssetRef;
import com.g4mesoft.captureplayback.common.asset.GSAssetRegistry;
import com.g4mesoft.captureplayback.common.asset.GSDecodedAssetFile;
import com.g4mesoft.captureplayback.common.asset.GSEAssetNamespace;
import com.g4mesoft.captureplayback.common.asset.GSEAssetType;
import com.g4mesoft.captureplayback.common.asset.GSIAssetHistory;
import com.g4mesoft.captureplayback.common.asset.GSIAssetListener;
import com.g4mesoft.captureplayback.common.asset.GSIAssetStorageListener;
import com.g4mesoft.captureplayback.common.asset.GSIPlayerCache;
import com.g4mesoft.captureplayback.common.asset.GSPlayerCacheEntry;
import com.g4mesoft.captureplayback.common.asset.GSUnmodifiableAssetHistory;
import com.g4mesoft.core.server.GSIServerModuleManager;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import com.g4mesoft.util.GSFileUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_3222;

public class GSAssetStorage {
    private static final String ASSET_FILE_NAME_TEMPLATE = "%s.gsa";
    private static final String HISTORY_FILE_NAME = "history.bin";
    private static final String PLAYER_CACHE_FILE_NAME = "players.bin";
    private final GSIServerModuleManager manager;
    private final GSEAssetNamespace namespace;
    private final File assetDir;
    private final GSAssetHistory storedHistory;
    private final GSAssetHistory derivedHistory;
    private final GSPersistentPlayerCache playerCache;
    private final Map<UUID, GSAbstractAsset> loadedAssets;
    private final Map<UUID, GSAssetRef> activeRefs;
    private final Map<UUID, GSAssetListener> assetListeners;
    private final List<GSIAssetStorageListener> listeners;

    public GSAssetStorage(GSIServerModuleManager manager, GSEAssetNamespace namespace, File assetDir) {
        this.manager = manager;
        this.namespace = namespace;
        this.assetDir = assetDir;
        this.storedHistory = new GSAssetHistory();
        this.derivedHistory = new GSAssetHistory();
        this.playerCache = new GSPersistentPlayerCache();
        this.loadedAssets = new HashMap<UUID, GSAbstractAsset>();
        this.activeRefs = new HashMap<UUID, GSAssetRef>();
        this.assetListeners = new HashMap<UUID, GSAssetListener>();
        this.listeners = new ArrayList<GSIAssetStorageListener>();
    }

    public boolean init() {
        if (this.loadStoredHistory()) {
            this.loadPlayerCache();
            return true;
        }
        return false;
    }

    public void addListener(GSIAssetStorageListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null!");
        }
        this.listeners.add(listener);
    }

    public void removeListener(GSIAssetStorageListener listener) {
        this.listeners.remove(listener);
    }

    private void dispatchAssetAdded(UUID assetUUID) {
        for (GSIAssetStorageListener listener : this.listeners) {
            listener.onAssetAdded(assetUUID);
        }
    }

    private void dispatchAssetRemoved(UUID assetUUID) {
        for (GSIAssetStorageListener listener : this.listeners) {
            listener.onAssetRemoved(assetUUID);
        }
    }

    public boolean hasStoredAsset(UUID assetUUID) {
        return this.storedHistory.contains(assetUUID);
    }

    public boolean hasAssetHandle(GSAssetHandle handle) {
        return this.storedHistory.containsHandle(handle);
    }

    public boolean hasAsset(UUID assetUUID) {
        return this.hasStoredAsset(assetUUID) || this.derivedHistory.contains(assetUUID);
    }

    public GSAssetInfo getInfo(UUID assetUUID) {
        GSAssetInfo storedInfo = this.storedHistory.get(assetUUID);
        return storedInfo != null ? storedInfo : this.derivedHistory.get(assetUUID);
    }

    public GSAssetInfo getInfoFromHandle(GSAssetHandle handle) {
        return this.storedHistory.getFromHandle(handle);
    }

    public GSAssetRef requestAsset(UUID assetUUID) {
        GSAssetRef ref = this.activeRefs.get(assetUUID);
        if (ref != null) {
            return ref.retain();
        }
        if (this.ensureLoaded(assetUUID)) {
            GSAbstractAsset asset = this.loadedAssets.get(assetUUID);
            ref = new GSAssetRef(this, asset);
            this.activeRefs.put(assetUUID, ref);
            return ref;
        }
        return null;
    }

    private boolean ensureLoaded(UUID assetUUID) {
        if (this.isLoaded(assetUUID)) {
            return true;
        }
        GSAssetInfo info = this.storedHistory.get(assetUUID);
        if (info != null && info.getType() != null) {
            try {
                GSDecodedAssetFile assetFile = (GSDecodedAssetFile)GSFileUtil.readFile((File)this.getAssetFile(info), GSDecodedAssetFile::read);
                this.addAsset(info, assetFile.getAsset());
                return true;
            }
            catch (Throwable t) {
                CapturePlaybackMod.GSCP_LOGGER.warn("Unable to load asset ({})", (Object)info.getAssetUUID(), (Object)t);
                return false;
            }
        }
        return false;
    }

    public boolean isLoaded(UUID assetUUID) {
        return this.loadedAssets.containsKey(assetUUID);
    }

    private void checkDistinctAssetUUID(UUID assetUUID) {
        if (this.hasAsset(assetUUID)) {
            throw new IllegalArgumentException("Asset with UUID: " + String.valueOf(assetUUID) + " already exists");
        }
    }

    private void checkCorrespondingInfo(GSAssetInfo info, GSAbstractAsset asset) {
        if (info.getTypeIndex() != asset.getType().getIndex()) {
            throw new IllegalArgumentException("Asset type does not match asset info");
        }
        if (!info.getAssetUUID().equals(asset.getUUID())) {
            throw new IllegalArgumentException("Asset UUID does not match asset info");
        }
    }

    private void checkDistinctHandle(GSAssetHandle handle) {
        if (handle == null || this.hasAssetHandle(handle)) {
            throw new IllegalArgumentException("Stored assets must specify a unique handle!");
        }
    }

    private void checkHandleNamespace(GSAssetHandle handle) {
        if (handle.getNamespace() != this.namespace) {
            throw new IllegalArgumentException("Asset namespace does not match");
        }
    }

    public void createAsset(GSAssetInfo info) {
        GSEAssetType type = info.getType();
        if (type == null) {
            throw new IllegalArgumentException("Unknown asset type!");
        }
        this.createAsset(info, null, GSAssetRegistry.getConstr(type).apply(info));
    }

    public void createDuplicateAsset(GSAssetInfo info, GSAbstractAsset originalAsset) {
        GSAbstractAsset asset = GSAssetRegistry.getConstr(originalAsset.getType()).apply(info);
        asset.duplicateFrom(originalAsset);
        this.createAsset(info, null, asset);
    }

    public void importAsset(GSAssetInfo info, GSDecodedAssetFile assetFile) {
        GSAssetFileHeader header = assetFile.getHeader();
        GSAbstractAsset asset = GSAssetRegistry.getConstr(header.getType()).apply(info);
        asset.duplicateFrom(assetFile.getAsset());
        this.createAsset(info, header, asset);
    }

    private void createAsset(GSAssetInfo info, GSAssetFileHeader header, GSAbstractAsset asset) {
        this.checkDistinctAssetUUID(info.getAssetUUID());
        this.checkCorrespondingInfo(info, asset);
        this.checkDistinctHandle(info.getHandle());
        this.checkHandleNamespace(info.getHandle());
        this.playerCache.onAssetAdded(this, info, header);
        this.storedHistory.add(info);
        this.addAsset(info, asset);
        this.unloadAsset(info.getAssetUUID());
    }

    private void addAsset(GSAssetInfo info, GSAbstractAsset asset) {
        UUID assetUUID = info.getAssetUUID();
        this.loadedAssets.put(assetUUID, asset);
        Iterator<UUID> itr = asset.getDerivedIterator();
        while (itr.hasNext()) {
            this.addDerivedAsset(assetUUID, itr.next());
        }
        GSAssetListener listener = new GSAssetListener(assetUUID);
        asset.addListener(listener);
        this.assetListeners.put(assetUUID, listener);
        asset.onAdded();
        this.dispatchAssetAdded(assetUUID);
    }

    private void addDerivedAsset(UUID parentUUID, UUID derivedUUID) {
        this.checkDistinctAssetUUID(derivedUUID);
        GSAssetInfo info = this.getInfo(parentUUID);
        GSAbstractAsset asset = this.loadedAssets.get(parentUUID);
        if (info != null && asset != null) {
            GSAbstractAsset derivedAsset = asset.getDerivedAsset(derivedUUID);
            GSAssetInfo derivedInfo = new GSAssetInfo(derivedAsset.getType(), derivedUUID, info);
            if (derivedInfo.getHandle() != null) {
                throw new IllegalStateException("Derived assets are not allowed to have a handle!");
            }
            this.checkCorrespondingInfo(derivedInfo, derivedAsset);
            this.derivedHistory.add(derivedInfo);
            this.addAsset(derivedInfo, derivedAsset);
        }
    }

    public void addCollaborator(UUID assetUUID, UUID collabUUID) {
        GSAssetInfo info = this.storedHistory.get(assetUUID);
        if (info != null && !info.isCollaborator(collabUUID)) {
            this.playerCache.onCollabAdded(this, assetUUID, collabUUID);
            if (this.storedHistory.addCollaborator(assetUUID, collabUUID)) {
                this.saveHistory(assetUUID);
            } else {
                this.playerCache.onCollabRemoved(this, assetUUID, collabUUID);
            }
        }
    }

    public void removeCollaborator(UUID assetUUID, UUID collabUUID) {
        if (this.storedHistory.removeCollaborator(assetUUID, collabUUID)) {
            this.playerCache.onCollabRemoved(this, assetUUID, collabUUID);
            this.saveHistory(assetUUID);
        }
    }

    private boolean loadStoredHistory() {
        GSAssetHistory history = null;
        try {
            history = (GSAssetHistory)GSFileUtil.readFile((File)this.getHistoryFile(), GSAssetHistory::read);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (history == null || !this.isValidHistory(history)) {
            CapturePlaybackMod.GSCP_LOGGER.warn("Unable to load history ({})", (Object)this.namespace.getName());
            return false;
        }
        for (GSAssetInfo info : this.storedHistory) {
            if (history.contains(info.getAssetUUID())) continue;
            this.saveAsset(info.getAssetUUID());
            this.removeAsset(info.getAssetUUID());
            this.playerCache.onAssetRemoved(this, info);
        }
        this.storedHistory.set(history);
        return true;
    }

    private boolean isValidHistory(GSAssetHistory history) {
        for (GSAssetInfo info : history) {
            GSAssetHandle handle = info.getHandle();
            if (handle != null && handle.getNamespace() == this.namespace) continue;
            return false;
        }
        return true;
    }

    private boolean loadPlayerCache() {
        GSPersistentPlayerCache cache = null;
        try {
            cache = (GSPersistentPlayerCache)GSFileUtil.readFile((File)this.getPlayerCacheFile(), GSPersistentPlayerCache::read);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (cache == null) {
            CapturePlaybackMod.GSCP_LOGGER.warn("Unable to load player cache ({})", (Object)this.namespace.getName());
            return false;
        }
        this.playerCache.set(cache);
        return true;
    }

    public void deleteAsset(UUID assetUUID) {
        GSAssetInfo info = this.storedHistory.get(assetUUID);
        if (info != null) {
            this.unloadAsset(assetUUID);
            this.playerCache.onAssetRemoved(this, info);
            this.storedHistory.remove(assetUUID);
            this.saveHistory(assetUUID);
        }
    }

    void onRefInvalidated(UUID assetUUID) {
        if (this.hasStoredAsset(assetUUID)) {
            this.save(assetUUID);
            this.removeAsset(assetUUID);
        } else {
            this.activeRefs.remove(assetUUID);
        }
    }

    public void unloadAsset(UUID assetUUID) {
        if (this.hasStoredAsset(assetUUID) && this.loadedAssets.containsKey(assetUUID)) {
            this.save(assetUUID);
            this.removeAsset(assetUUID);
        }
    }

    public void unloadAll() {
        if (!this.loadedAssets.isEmpty()) {
            UUID[] assetUUIDs;
            for (UUID assetUUID : assetUUIDs = this.loadedAssets.keySet().toArray(new UUID[0])) {
                this.saveAsset(assetUUID);
                this.removeAsset(assetUUID);
            }
            this.saveHistory(null);
        }
    }

    private void removeAsset(UUID assetUUID) {
        GSAssetInfo info = this.getInfo(assetUUID);
        GSAbstractAsset asset = this.loadedAssets.get(assetUUID);
        if (asset != null && info != null) {
            GSAssetListener listener = this.assetListeners.remove(assetUUID);
            if (listener != null) {
                listener.setRemoved(true);
            }
            Iterator<UUID> itr = asset.getDerivedIterator();
            while (itr.hasNext()) {
                this.removeAsset(itr.next());
            }
            asset.removeListener(listener);
            this.loadedAssets.remove(assetUUID);
            GSAssetRef ref = this.activeRefs.remove(assetUUID);
            if (ref != null) {
                ref.invalidate();
            }
            if (info.isDerived()) {
                this.derivedHistory.remove(assetUUID);
            }
            asset.onRemoved();
            this.dispatchAssetRemoved(assetUUID);
        }
    }

    public boolean save(UUID assetUUID) {
        if (this.saveAsset(assetUUID)) {
            return this.saveHistory(assetUUID);
        }
        return false;
    }

    public boolean saveAll() {
        boolean success = true;
        for (UUID assetUUID : this.loadedAssets.keySet()) {
            if (this.saveAsset(assetUUID)) continue;
            success = false;
        }
        if (!this.saveHistory(null)) {
            success = false;
        }
        return success;
    }

    public boolean saveAsset(UUID assetUUID) {
        GSAbstractAsset asset;
        GSAssetInfo info = this.storedHistory.get(assetUUID);
        if (info != null && !info.isDerived() && (asset = this.loadedAssets.get(assetUUID)) != null) {
            long saveTimeMs = System.currentTimeMillis();
            GSAssetFileHeader header = new GSAssetFileHeader(info, this.playerCache);
            GSDecodedAssetFile assetFile = new GSDecodedAssetFile(header, asset);
            try {
                GSFileUtil.writeFile((File)this.getAssetFile(info), (Object)assetFile, GSDecodedAssetFile::write);
            }
            catch (IOException ignore) {
                return false;
            }
            this.storedHistory.setLastModifiedTimestamp(assetUUID, saveTimeMs);
            return true;
        }
        return false;
    }

    public boolean saveHistory(UUID assetUUID) {
        try {
            GSFileUtil.writeFile((File)this.getHistoryFile(), (Object)this.storedHistory, GSAssetHistory::write);
        }
        catch (IOException e) {
            CapturePlaybackMod.GSCP_LOGGER.warn("Unable to save history ({})", (Object)this.namespace.getName());
            return false;
        }
        return this.savePlayerCache();
    }

    private boolean savePlayerCache() {
        try {
            GSFileUtil.writeFile((File)this.getPlayerCacheFile(), (Object)this.playerCache, GSPersistentPlayerCache::write);
        }
        catch (IOException e) {
            CapturePlaybackMod.GSCP_LOGGER.warn("Unable to save player cache ({})", (Object)this.namespace.getName());
            return false;
        }
        return true;
    }

    public GSEAssetNamespace getNamespace() {
        return this.namespace;
    }

    public File getAssetDir() {
        return this.assetDir;
    }

    private File getHistoryFile() {
        return new File(this.assetDir, HISTORY_FILE_NAME);
    }

    private File getAssetFile(GSAssetInfo info) {
        return new File(this.assetDir, String.format(ASSET_FILE_NAME_TEMPLATE, info.getAssetUUID()));
    }

    private File getPlayerCacheFile() {
        return new File(this.assetDir, PLAYER_CACHE_FILE_NAME);
    }

    public GSIAssetHistory getStoredHistory() {
        return new GSUnmodifiableAssetHistory(this.storedHistory);
    }

    public GSIPlayerCache getPlayerCache() {
        return this.playerCache;
    }

    private static class GSPersistentPlayerCache
    extends GSAbstractPlayerCache {
        private final Map<UUID, GSPlayerCacheEntryRef> entries = new HashMap<UUID, GSPlayerCacheEntryRef>();

        @Override
        public GSPlayerCacheEntry get(UUID playerUUID) {
            GSPlayerCacheEntryRef ref = this.entries.get(playerUUID);
            return ref != null ? ref.entry : null;
        }

        @Override
        public Iterable<UUID> getPlayers() {
            return Collections.unmodifiableSet(this.entries.keySet());
        }

        void onAssetAdded(GSAssetStorage storage, GSAssetInfo info, GSAssetFileHeader header) {
            this.incRef(storage, info, header, 1);
        }

        void onAssetRemoved(GSAssetStorage storage, GSAssetInfo info) {
            this.incRef(storage, info, null, -1);
        }

        void onCollabAdded(GSAssetStorage storage, UUID assetUUID, UUID collabUUID) {
            this.incRef(storage, collabUUID, null, 1);
        }

        void onCollabRemoved(GSAssetStorage storage, UUID assetUUID, UUID collabUUID) {
            this.incRef(storage, collabUUID, null, -1);
        }

        private void incRef(GSAssetStorage storage, GSAssetInfo info, GSAssetFileHeader header, int sign) {
            this.incRef(storage, info.getOwnerUUID(), header, sign);
            this.incRef(storage, info.getCreatedByUUID(), header, sign);
            for (UUID playerUUID : info.getCollaboratorUUIDs()) {
                this.incRef(storage, playerUUID, header, sign);
            }
        }

        private void incRef(GSAssetStorage storage, UUID playerUUID, GSAssetFileHeader header, int sign) {
            GSPlayerCacheEntryRef ref = this.entries.get(playerUUID);
            if (ref == null) {
                if (sign > 0) {
                    ref = this.createEntry(storage, playerUUID, header);
                }
                if (ref == null) {
                    return;
                }
                this.entries.put(playerUUID, ref);
                this.dispatchEntryAdded(playerUUID);
            }
            ref.refCount += sign;
            if (ref.refCount <= 0) {
                this.entries.remove(playerUUID);
                this.dispatchEntryRemoved(playerUUID);
            }
        }

        private GSPlayerCacheEntryRef createEntry(GSAssetStorage storage, UUID playerUUID, GSAssetFileHeader header) {
            GSPlayerCacheEntry entry;
            class_3222 player = storage.manager.getPlayer(playerUUID);
            if (player != null) {
                String name = player.method_5820();
                GSPlayerCacheEntry entry2 = new GSPlayerCacheEntry(name);
                return new GSPlayerCacheEntryRef(0, entry2);
            }
            if (header != null && header.getCreatedByUUID().equals(playerUUID) && (entry = header.getCreatedByCacheEntry()) != null) {
                return new GSPlayerCacheEntryRef(0, entry);
            }
            return null;
        }

        private void set(GSPersistentPlayerCache other) {
            this.entries.clear();
            this.entries.putAll(other.entries);
            this.dispatchEntryAdded(null);
        }

        public static GSPersistentPlayerCache read(GSDecodeBuffer buf) throws IOException {
            int count = buf.readInt();
            if (count < 0) {
                throw new IOException("Player cache corrupted");
            }
            GSPersistentPlayerCache cache = new GSPersistentPlayerCache();
            while (count-- != 0) {
                UUID playerUUID = buf.readUUID();
                GSPlayerCacheEntryRef ref = GSPlayerCacheEntryRef.read(buf);
                cache.entries.put(playerUUID, ref);
            }
            return cache;
        }

        public static void write(GSEncodeBuffer buf, GSPersistentPlayerCache cache) throws IOException {
            buf.writeInt(cache.entries.size());
            for (Map.Entry<UUID, GSPlayerCacheEntryRef> entryKV : cache.entries.entrySet()) {
                buf.writeUUID(entryKV.getKey());
                GSPlayerCacheEntryRef.write(buf, entryKV.getValue());
            }
        }
    }

    private class GSAssetListener
    implements GSIAssetListener {
        private final UUID assetUUID;
        private boolean removed;

        public GSAssetListener(UUID assetUUID) {
            this.assetUUID = assetUUID;
            this.removed = false;
        }

        public void setRemoved(boolean removed) {
            this.removed = removed;
        }

        @Override
        public void onNameChanged(String name) {
            GSAssetStorage.this.storedHistory.setAssetName(this.assetUUID, name);
        }

        @Override
        public void onDerivedAssetRemoved(UUID derivedUUID) {
            GSAssetStorage.this.removeAsset(derivedUUID);
        }

        @Override
        public void onDerivedAssetAdded(UUID derivedUUID) {
            if (!this.removed) {
                GSAssetStorage.this.addDerivedAsset(this.assetUUID, derivedUUID);
            }
        }
    }

    private static class GSPlayerCacheEntryRef {
        private int refCount;
        private final GSPlayerCacheEntry entry;

        public GSPlayerCacheEntryRef(int refCount, GSPlayerCacheEntry entry) {
            if (entry == null) {
                throw new IllegalArgumentException("entry is null");
            }
            if (refCount < 0) {
                throw new IllegalArgumentException("refCount must be non-negative");
            }
            this.entry = entry;
            this.refCount = refCount;
        }

        public static GSPlayerCacheEntryRef read(GSDecodeBuffer buf) throws IOException {
            int refCount = buf.readInt();
            if (refCount <= 0) {
                throw new IOException("Player entry corrupted");
            }
            GSPlayerCacheEntry entry = GSPlayerCacheEntry.read(buf);
            return new GSPlayerCacheEntryRef(refCount, entry);
        }

        public static void write(GSEncodeBuffer buf, GSPlayerCacheEntryRef ref) throws IOException {
            buf.writeInt(ref.refCount);
            GSPlayerCacheEntry.write(buf, ref.entry);
        }
    }
}

