/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.common.asset.GSAbstractAsset;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSEAssetType;
import com.g4mesoft.captureplayback.common.asset.GSSequenceAsset;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSICompositionListener;
import com.g4mesoft.captureplayback.composition.GSTrack;
import com.g4mesoft.captureplayback.stream.GSICaptureStream;
import com.g4mesoft.captureplayback.stream.GSIPlaybackStream;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.Iterator;
import java.util.UUID;
import net.minecraft.class_2338;

public class GSCompositionAsset
extends GSAbstractAsset
implements GSICompositionListener {
    private final GSComposition composition;

    public GSCompositionAsset(GSAssetInfo info) {
        this(new GSComposition(info.getAssetUUID(), info.getAssetName()));
    }

    public GSCompositionAsset(GSComposition composition) {
        super(GSEAssetType.COMPOSITION);
        this.composition = composition;
    }

    @Override
    protected GSCompositionAsset copy() {
        GSComposition composition = new GSComposition(this.getUUID(), this.getName());
        GSCompositionAsset asset = new GSCompositionAsset(composition);
        asset.duplicateFrom(this);
        return asset;
    }

    @Override
    protected void duplicateFrom(GSAbstractAsset other) {
        if (!(other instanceof GSCompositionAsset)) {
            throw new IllegalArgumentException("Expected composition asset");
        }
        this.composition.duplicateFrom(((GSCompositionAsset)other).getComposition());
    }

    @Override
    protected void onAdded() {
        super.onAdded();
        this.composition.addCompositionListener(this);
    }

    @Override
    protected void onRemoved() {
        super.onRemoved();
        this.composition.removeCompositionListener(this);
    }

    public GSComposition getComposition() {
        return this.composition;
    }

    @Override
    public UUID getUUID() {
        return this.composition.getCompositionUUID();
    }

    @Override
    public String getName() {
        return this.composition.getName();
    }

    @Override
    public GSIPlaybackStream getPlaybackStream() {
        return this.composition.getPlaybackStream();
    }

    @Override
    public GSICaptureStream getCaptureStream() {
        return this.composition.getCaptureStream();
    }

    @Override
    public Iterator<UUID> getDerivedIterator() {
        return this.composition.getTrackUUIDs().iterator();
    }

    @Override
    public GSAbstractAsset getDerivedAsset(UUID assetUUID) {
        GSTrack track = this.composition.getTrack(assetUUID);
        if (track != null) {
            return new GSSequenceAsset(track.getSequence());
        }
        return null;
    }

    @Override
    public class_2338 getOrigin() {
        return this.composition.getOrigin();
    }

    @Override
    public void offsetOrigin(int dx, int dy, int dz) {
        this.composition.offsetOrigin(dx, dy, dz);
    }

    @Override
    public void compositionNameChanged(String oldName) {
        this.dispatchNameChanged(this.composition.getName());
    }

    @Override
    public void trackAdded(GSTrack track) {
        this.dispatchDerivedAssetAdded(track.getTrackUUID());
    }

    @Override
    public void trackRemoved(GSTrack track) {
        this.dispatchDerivedAssetRemoved(track.getTrackUUID());
    }

    public static GSCompositionAsset read(GSDecodeBuffer buf) throws IOException {
        return new GSCompositionAsset(GSComposition.read(buf));
    }

    public static void write(GSEncodeBuffer buf, GSCompositionAsset asset) throws IOException {
        GSComposition.write(buf, asset.getComposition());
    }
}

