/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.common.asset.GSAssetHandle;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSAssetManager;
import com.g4mesoft.captureplayback.common.asset.GSEAssetType;
import com.g4mesoft.captureplayback.module.server.GSCapturePlaybackServerModule;
import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.core.server.GSServerController;
import com.g4mesoft.packet.GSIPacket;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class GSCreateAssetPacket
implements GSIPacket {
    private String name;
    private GSEAssetType type;
    private GSAssetHandle handle;
    private UUID originalAssetUUID;

    public GSCreateAssetPacket() {
    }

    public GSCreateAssetPacket(String name, GSEAssetType type, GSAssetHandle handle, UUID originalAssetUUID) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (handle == null) {
            throw new IllegalArgumentException("handle is null");
        }
        this.name = name;
        this.type = type;
        this.handle = handle;
        this.originalAssetUUID = originalAssetUUID;
    }

    public void read(GSDecodeBuffer buf) throws IOException {
        this.name = buf.readString();
        this.type = GSEAssetType.fromIndex(buf.readUnsignedByte());
        if (this.type == null) {
            throw new IOException("Unknown asset type");
        }
        this.handle = GSAssetHandle.read(buf);
        this.originalAssetUUID = buf.readBoolean() ? buf.readUUID() : null;
    }

    public void write(GSEncodeBuffer buf) throws IOException {
        buf.writeString(this.name);
        buf.writeUnsignedByte((short)this.type.getIndex());
        GSAssetHandle.write(buf, this.handle);
        buf.writeBoolean(this.originalAssetUUID != null);
        if (this.originalAssetUUID != null) {
            buf.writeUUID(this.originalAssetUUID);
        }
    }

    public void handleOnServer(GSServerController controller, class_3222 player) {
        GSCapturePlaybackServerModule module = (GSCapturePlaybackServerModule)controller.getModule(GSCapturePlaybackServerModule.class);
        if (module != null) {
            GSAssetManager assetManager = module.getAssetManager();
            if (this.originalAssetUUID != null) {
                GSAssetInfo originalInfo = assetManager.getInfo(this.originalAssetUUID);
                if (originalInfo != null && this.type == originalInfo.getType() && originalInfo.hasPermission((class_1657)player)) {
                    assetManager.createDuplicateAsset(this.handle, this.name, player.method_5667(), this.originalAssetUUID);
                }
            } else {
                assetManager.createAsset(this.type, this.handle, this.name, player.method_5667());
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void handleOnClient(GSClientController controller) {
    }
}

