/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.common.asset.GSAbstractAsset;
import com.g4mesoft.captureplayback.common.asset.GSAssetFileHeader;
import com.g4mesoft.captureplayback.common.asset.GSAssetRegistry;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import com.g4mesoft.util.GSFileUtil;
import java.io.IOException;

public class GSDecodedAssetFile {
    private final GSAssetFileHeader header;
    private final GSAbstractAsset asset;

    public GSDecodedAssetFile(GSAssetFileHeader header, GSAbstractAsset asset) {
        if (header.getType() != asset.getType()) {
            throw new IllegalArgumentException("Header type does not match asset");
        }
        this.header = header;
        this.asset = asset;
    }

    public GSDecodedAssetFile copy() {
        return new GSDecodedAssetFile(this.header, this.asset.copy());
    }

    public GSAssetFileHeader getHeader() {
        return this.header;
    }

    public GSAbstractAsset getAsset() {
        return this.asset;
    }

    public static GSDecodedAssetFile read(GSDecodeBuffer buf) throws IOException {
        GSAbstractAsset asset;
        GSAssetFileHeader header = GSAssetFileHeader.read(buf);
        try {
            asset = (GSAbstractAsset)GSAssetRegistry.getDecoder(header.getType()).decode(buf);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
        return new GSDecodedAssetFile(header, asset);
    }

    public static void write(GSEncodeBuffer buf, GSDecodedAssetFile assetFile) throws IOException {
        GSAssetFileHeader.write(buf, assetFile.getHeader());
        GSDecodedAssetFile.writeAsset(buf, assetFile.getAsset());
    }

    private static <T extends GSAbstractAsset> void writeAsset(GSEncodeBuffer buf, T asset) throws IOException {
        GSFileUtil.GSFileEncoder<? extends GSAbstractAsset> encoder = GSAssetRegistry.getEncoder(asset.getType());
        try {
            encoder.encode(buf, asset);
        }
        catch (IOException ioe) {
            throw ioe;
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

