/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition;

import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSICompositionListener;
import com.g4mesoft.captureplayback.util.GSMutableLinkedHashSet;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;

public class GSTrackGroup {
    private final UUID groupUUID;
    private String name;
    private final GSMutableLinkedHashSet<UUID> trackUUIDs;
    private GSComposition parent;

    public GSTrackGroup(GSTrackGroup other) {
        this(other.getGroupUUID(), other.getName());
        for (UUID trackUUID : other.getTrackUUIDs()) {
            this.trackUUIDs.add(trackUUID);
        }
    }

    public GSTrackGroup(UUID groupUUID, String name) {
        this.groupUUID = groupUUID;
        this.name = name;
        this.trackUUIDs = new GSMutableLinkedHashSet();
        this.parent = null;
    }

    public GSComposition getParent() {
        return this.parent;
    }

    void onAdded(GSComposition parent) {
        if (this.parent != null) {
            throw new IllegalStateException("Group already has a parent");
        }
        this.parent = parent;
    }

    void onRemoved(GSComposition parent) {
        if (this.parent != parent) {
            throw new IllegalStateException("Group does not have the specified parent");
        }
        this.parent = null;
    }

    void duplicateFrom(GSTrackGroup other) {
        this.setName(other.getName());
        this.trackUUIDs.clear();
    }

    void set(GSTrackGroup other) {
        this.setName(other.getName());
        this.trackUUIDs.clear();
        this.trackUUIDs.addAll(other.getTrackUUIDs());
    }

    void addTrack(UUID trackUUID) {
        this.trackUUIDs.add(trackUUID);
    }

    void removeTrack(UUID trackUUID) {
        this.trackUUIDs.remove(trackUUID);
    }

    public boolean hasTrackUUID(UUID trackUUID) {
        return this.trackUUIDs.contains(trackUUID);
    }

    public UUID getGroupUUID() {
        return this.groupUUID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (!name.equals(this.name)) {
            String oldName = this.name;
            this.name = name;
            this.dispatchNameChanged(oldName);
        }
    }

    private void dispatchNameChanged(String oldName) {
        if (this.parent != null) {
            for (GSICompositionListener listener : this.parent.getListeners()) {
                listener.groupNameChanged(this, oldName);
            }
        }
    }

    public Set<UUID> getTrackUUIDs() {
        return Collections.unmodifiableSet(this.trackUUIDs);
    }

    public static GSTrackGroup read(GSDecodeBuffer buf) {
        UUID groupUUID = buf.readUUID();
        String name = buf.readString();
        GSTrackGroup group = new GSTrackGroup(groupUUID, name);
        int trackCount = buf.readInt();
        while (trackCount-- != 0) {
            group.addTrack(buf.readUUID());
        }
        return group;
    }

    public static void write(GSEncodeBuffer buf, GSTrackGroup group) {
        buf.writeUUID(group.getGroupUUID());
        buf.writeString(group.getName());
        Set<UUID> trackUUIDs = group.getTrackUUIDs();
        buf.writeInt(trackUUIDs.size());
        for (UUID trackUUID : trackUUIDs) {
            buf.writeUUID(trackUUID);
        }
    }
}

