/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition.delta;

import com.g4mesoft.captureplayback.common.GSDeltaTransformer;
import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.captureplayback.common.GSIDeltaListener;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSICompositionListener;
import com.g4mesoft.captureplayback.composition.GSTrack;
import com.g4mesoft.captureplayback.composition.GSTrackEntry;
import com.g4mesoft.captureplayback.composition.GSTrackGroup;
import com.g4mesoft.captureplayback.composition.delta.GSCompositionNameDelta;
import com.g4mesoft.captureplayback.composition.delta.GSGroupAddedDelta;
import com.g4mesoft.captureplayback.composition.delta.GSGroupNameDelta;
import com.g4mesoft.captureplayback.composition.delta.GSGroupRemovedDelta;
import com.g4mesoft.captureplayback.composition.delta.GSTrackAddedDelta;
import com.g4mesoft.captureplayback.composition.delta.GSTrackColorDelta;
import com.g4mesoft.captureplayback.composition.delta.GSTrackEntryAddedDelta;
import com.g4mesoft.captureplayback.composition.delta.GSTrackEntryOffsetDelta;
import com.g4mesoft.captureplayback.composition.delta.GSTrackEntryRemovedDelta;
import com.g4mesoft.captureplayback.composition.delta.GSTrackGroupDelta;
import com.g4mesoft.captureplayback.composition.delta.GSTrackNameDelta;
import com.g4mesoft.captureplayback.composition.delta.GSTrackRemovedDelta;
import com.g4mesoft.captureplayback.composition.delta.GSTrackSequenceDelta;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.sequence.delta.GSSequenceDeltaTransformer;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;

public class GSCompositionDeltaTransformer
extends GSDeltaTransformer<GSComposition>
implements GSICompositionListener {
    private final Map<UUID, GSTrackSequenceDeltaListener> sequenceDeltaListeners = new HashMap<UUID, GSTrackSequenceDeltaListener>();

    @Override
    public void install(GSComposition model) {
        super.install(model);
        for (GSTrack track : model.getTracks()) {
            this.installSequenceListener(track);
        }
        model.addCompositionListener(this);
    }

    @Override
    public void uninstall(GSComposition model) {
        super.uninstall(model);
        model.removeCompositionListener(this);
        for (GSTrack track : model.getTracks()) {
            this.uninstallSequenceListener(track);
        }
    }

    private void installSequenceListener(GSTrack track) {
        if (!this.sequenceDeltaListeners.containsKey(track.getTrackUUID())) {
            GSTrackSequenceDeltaListener listener = new GSTrackSequenceDeltaListener(track);
            listener.install();
            this.sequenceDeltaListeners.put(track.getTrackUUID(), listener);
        }
    }

    private void uninstallSequenceListener(GSTrack track) {
        GSTrackSequenceDeltaListener listener = this.sequenceDeltaListeners.remove(track.getTrackUUID());
        if (listener != null) {
            listener.uninstall();
        }
    }

    @Override
    public void setEnabled(boolean enabled) {
        if (enabled != this.isEnabled()) {
            super.setEnabled(enabled);
            for (GSTrackSequenceDeltaListener listener : this.sequenceDeltaListeners.values()) {
                listener.setEnabled(enabled);
            }
        }
    }

    @Override
    public void compositionNameChanged(String oldName) {
        this.dispatchDeltaEvent(new GSCompositionNameDelta(((GSComposition)this.model).getName(), oldName));
    }

    @Override
    public void groupAdded(GSTrackGroup group) {
        this.dispatchDeltaEvent(new GSGroupAddedDelta(group));
    }

    @Override
    public void groupRemoved(GSTrackGroup group) {
        this.dispatchDeltaEvent(new GSGroupRemovedDelta(group));
    }

    @Override
    public void groupNameChanged(GSTrackGroup group, String oldName) {
        this.dispatchDeltaEvent(new GSGroupNameDelta(group.getGroupUUID(), group.getName(), oldName));
    }

    @Override
    public void trackAdded(GSTrack track) {
        this.dispatchDeltaEvent(new GSTrackAddedDelta(track));
        this.installSequenceListener(track);
    }

    @Override
    public void trackRemoved(GSTrack track) {
        this.dispatchDeltaEvent(new GSTrackRemovedDelta(track));
        this.uninstallSequenceListener(track);
    }

    @Override
    public void trackNameChanged(GSTrack track, String oldName) {
        this.dispatchDeltaEvent(new GSTrackNameDelta(track.getTrackUUID(), track.getName(), oldName));
    }

    @Override
    public void trackColorChanged(GSTrack track, int oldColor) {
        this.dispatchDeltaEvent(new GSTrackColorDelta(track.getTrackUUID(), track.getColor(), oldColor));
    }

    @Override
    public void trackGroupChanged(GSTrack track, UUID oldGroupUUID) {
        this.dispatchDeltaEvent(new GSTrackGroupDelta(track.getTrackUUID(), track.getGroupUUID(), oldGroupUUID));
    }

    @Override
    public void entryAdded(GSTrackEntry entry) {
        this.dispatchDeltaEvent(new GSTrackEntryAddedDelta(entry));
    }

    @Override
    public void entryRemoved(GSTrackEntry entry) {
        this.dispatchDeltaEvent(new GSTrackEntryRemovedDelta(entry));
    }

    @Override
    public void entryOffsetChanged(GSTrackEntry entry, long oldOffset) {
        this.dispatchDeltaEvent(new GSTrackEntryOffsetDelta(entry.getParent().getTrackUUID(), entry.getEntryUUID(), entry.getOffset(), oldOffset));
    }

    private class GSTrackSequenceDeltaListener
    implements GSIDeltaListener<GSSequence> {
        private final UUID trackUUID;
        private final GSSequence sequence;
        private final GSSequenceDeltaTransformer transformer;

        public GSTrackSequenceDeltaListener(GSTrack track) {
            this.trackUUID = track.getTrackUUID();
            this.sequence = track.getSequence();
            this.transformer = new GSSequenceDeltaTransformer();
            this.transformer.addDeltaListener(this);
        }

        public void install() {
            this.transformer.install(this.sequence);
        }

        public void uninstall() {
            this.transformer.uninstall(this.sequence);
        }

        public void setEnabled(boolean enabled) {
            this.transformer.setEnabled(enabled);
        }

        @Override
        public void onDelta(GSIDelta<GSSequence> delta) {
            GSCompositionDeltaTransformer.this.dispatchDeltaEvent(new GSTrackSequenceDelta(this.trackUUID, delta));
        }
    }
}

