/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSTrackGroup;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.Objects;
import java.util.UUID;

public abstract class GSGroupDelta
implements GSIDelta<GSComposition> {
    private UUID groupUUID;

    public GSGroupDelta() {
    }

    public GSGroupDelta(UUID groupUUID) {
        this.groupUUID = groupUUID;
    }

    protected GSTrackGroup getGroup(GSComposition composition) throws GSDeltaException {
        GSTrackGroup group = composition.getGroup(this.groupUUID);
        if (group == null) {
            throw new GSDeltaException("Expected group does not exist");
        }
        return group;
    }

    protected void checkGroupName(GSTrackGroup group, String expectedName) throws GSDeltaException {
        if (!Objects.equals(expectedName, group.getName())) {
            throw new GSDeltaException("Group does not have the expected name");
        }
    }

    protected void removeGroup(GSComposition composition, String groupName) throws GSDeltaException {
        GSTrackGroup group = this.getGroup(composition);
        this.checkGroupName(group, groupName);
        composition.removeGroup(this.groupUUID);
    }

    protected void addGroup(GSComposition composition, String groupName) throws GSDeltaException {
        if (composition.hasGroupUUID(this.groupUUID)) {
            throw new GSDeltaException("Group already exists");
        }
        try {
            composition.addGroup(this.groupUUID, groupName);
        }
        catch (Throwable t) {
            composition.removeGroup(this.groupUUID);
            throw new GSDeltaException("Failed to add group", t);
        }
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        this.groupUUID = buf.readUUID();
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        buf.writeUUID(this.groupUUID);
    }
}

