/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSTrackGroup;
import com.g4mesoft.captureplayback.composition.delta.GSGroupDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public class GSGroupNameDelta
extends GSGroupDelta {
    private String newName;
    private String oldName;

    public GSGroupNameDelta() {
    }

    public GSGroupNameDelta(UUID groupUUID, String newName, String oldName) {
        super(groupUUID);
        this.newName = newName;
        this.oldName = oldName;
    }

    private void setGroupName(GSComposition composition, String newName, String oldName) throws GSDeltaException {
        GSTrackGroup group = this.getGroup(composition);
        this.checkGroupName(group, oldName);
        group.setName(newName);
    }

    @Override
    public void unapply(GSComposition composition) throws GSDeltaException {
        this.setGroupName(composition, this.oldName, this.newName);
    }

    @Override
    public void apply(GSComposition composition) throws GSDeltaException {
        this.setGroupName(composition, this.newName, this.oldName);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.newName = buf.readString();
        this.oldName = buf.readString();
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        buf.writeString(this.newName);
        buf.writeString(this.oldName);
    }
}

