/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSTrackGroup;
import com.g4mesoft.captureplayback.composition.delta.GSGroupDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public class GSGroupRemovedDelta
extends GSGroupDelta {
    private String groupName;

    public GSGroupRemovedDelta() {
    }

    public GSGroupRemovedDelta(GSTrackGroup group) {
        this(group.getGroupUUID(), group.getName());
    }

    public GSGroupRemovedDelta(UUID groupUUID, String groupName) {
        super(groupUUID);
        this.groupName = groupName;
    }

    @Override
    public void unapply(GSComposition composition) throws GSDeltaException {
        this.addGroup(composition, this.groupName);
    }

    @Override
    public void apply(GSComposition composition) throws GSDeltaException {
        this.removeGroup(composition, this.groupName);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.groupName = buf.readString();
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        buf.writeString(this.groupName);
    }
}

