/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSTrackEntry;
import com.g4mesoft.captureplayback.composition.delta.GSTrackEntryDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public class GSTrackEntryOffsetDelta
extends GSTrackEntryDelta {
    private long newOffset;
    private long oldOffset;

    public GSTrackEntryOffsetDelta() {
    }

    public GSTrackEntryOffsetDelta(UUID trackUUID, UUID entryUUID, long newOffset, long oldOffset) {
        super(trackUUID, entryUUID);
        this.newOffset = newOffset;
        this.oldOffset = oldOffset;
    }

    private void setEntryOffset(GSComposition composition, long newOffset, long oldOffset) throws GSDeltaException {
        GSTrackEntry entry = this.getEntry(composition);
        this.checkEntryOffset(entry, oldOffset);
        entry.setOffset(newOffset);
    }

    @Override
    public void unapply(GSComposition composition) throws GSDeltaException {
        this.setEntryOffset(composition, this.oldOffset, this.newOffset);
    }

    @Override
    public void apply(GSComposition composition) throws GSDeltaException {
        this.setEntryOffset(composition, this.newOffset, this.oldOffset);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.newOffset = buf.readLong();
        this.oldOffset = buf.readLong();
        if (this.newOffset < 0L || this.oldOffset < 0L) {
            throw new IOException("Invalid offsets");
        }
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        buf.writeLong(this.newOffset);
        buf.writeLong(this.oldOffset);
    }
}

