/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.gui;

import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSPlayerCache;
import com.g4mesoft.captureplayback.gui.GSCapturePlaybackPanel;
import com.g4mesoft.captureplayback.gui.GSPlayerPickerPanel;
import com.g4mesoft.captureplayback.module.client.GSClientAssetManager;
import com.g4mesoft.ui.panel.GSDimension;
import com.g4mesoft.ui.panel.GSEAnchor;
import com.g4mesoft.ui.panel.GSEFill;
import com.g4mesoft.ui.panel.GSETextAlignment;
import com.g4mesoft.ui.panel.GSGridLayoutManager;
import com.g4mesoft.ui.panel.GSILayoutManager;
import com.g4mesoft.ui.panel.GSIcon;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSParentPanel;
import com.g4mesoft.ui.panel.GSTexturedIcon;
import com.g4mesoft.ui.panel.button.GSButton;
import com.g4mesoft.ui.panel.cell.GSCellContext;
import com.g4mesoft.ui.panel.cell.GSICellRenderer;
import com.g4mesoft.ui.panel.cell.GSTextCellRenderer;
import com.g4mesoft.ui.panel.field.GSTextLabel;
import com.g4mesoft.ui.panel.scroll.GSScrollPanel;
import com.g4mesoft.ui.panel.table.GSBasicTableModel;
import com.g4mesoft.ui.panel.table.GSEHeaderResizePolicy;
import com.g4mesoft.ui.panel.table.GSEHeaderSelectionPolicy;
import com.g4mesoft.ui.panel.table.GSITableColumn;
import com.g4mesoft.ui.panel.table.GSITableModel;
import com.g4mesoft.ui.panel.table.GSTablePanel;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import com.g4mesoft.ui.util.GSTextUtil;
import java.util.Collections;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2561;

public class GSAssetPermissionPanel
extends GSParentPanel {
    private static final class_2561 TITLE_TEXT = GSCapturePlaybackPanel.translatable("permissionTitle");
    private static final class_2561 OWNER_TEXT = GSCapturePlaybackPanel.translatable("owner");
    private static final class_2561 CREATED_BY_TEXT = GSCapturePlaybackPanel.translatable("createdBy");
    private static final class_2561 COLLABORATORS_TEXT = GSCapturePlaybackPanel.translatable("collaborators");
    private static final class_2561 NAME_TEXT = GSCapturePlaybackPanel.translatable("name");
    private static final GSIcon ADD_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(38, 0, 10, 10));
    private static final GSIcon HOVERED_ADD_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(38, 10, 10, 10));
    private static final GSIcon DISABLED_ADD_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(38, 20, 10, 10));
    private static final GSIcon REMOVE_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(48, 0, 10, 10));
    private static final GSIcon HOVERED_REMOVE_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(48, 10, 10, 10));
    private static final GSIcon DISABLED_REMOVE_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(48, 20, 10, 10));
    private static final int FIELD_MARGIN = 10;
    private static final int FIELD_WIDTH = 150;
    private final GSClientAssetManager assetManager;
    private final GSPlayerCache playerCache;
    private final GSTextLabel ownerField;
    private final GSTextLabel createdByField;
    private final GSTablePanel collabTable;
    private final GSButton addCollabButton;
    private final GSButton removeCollabButton;
    private GSAssetInfo info;
    private UUID selectedCollab;

    public GSAssetPermissionPanel(GSClientAssetManager assetManager) {
        this.assetManager = assetManager;
        this.playerCache = assetManager.getPlayerCache();
        this.ownerField = new GSTextLabel(GSTextUtil.EMPTY);
        this.ownerField.setTextAlignment(GSETextAlignment.LEFT);
        this.createdByField = new GSTextLabel(GSTextUtil.EMPTY);
        this.createdByField.setTextAlignment(GSETextAlignment.LEFT);
        this.collabTable = new GSTablePanel();
        this.collabTable.setColumnHeaderResizePolicy(GSEHeaderResizePolicy.RESIZE_ALL);
        this.collabTable.setRowHeaderResizePolicy(GSEHeaderResizePolicy.RESIZE_OFF);
        this.collabTable.setColumnSelectionPolicy(GSEHeaderSelectionPolicy.DISABLED);
        this.collabTable.setRowSelectionPolicy(GSEHeaderSelectionPolicy.SINGLE_SELECTION);
        this.collabTable.setCellRenderer(GSCollabEntry.class, (GSICellRenderer)GSCollabEntryCellRenderer.INSTANCE);
        this.collabTable.setBorderWidth(0, 1);
        this.collabTable.setPreferredRowCount(10);
        this.collabTable.setMinimumRowHeight(16);
        this.addCollabButton = new GSButton(ADD_ICON);
        this.addCollabButton.setHoveredIcon(HOVERED_ADD_ICON);
        this.addCollabButton.setDisabledIcon(DISABLED_ADD_ICON);
        this.removeCollabButton = new GSButton(REMOVE_ICON);
        this.removeCollabButton.setHoveredIcon(HOVERED_REMOVE_ICON);
        this.removeCollabButton.setDisabledIcon(DISABLED_REMOVE_ICON);
        this.onCollabSelectionChanged(null);
        this.onInfoChanged();
        this.initLayout();
        this.initEventListeners();
    }

    private void initLayout() {
        this.setLayoutManager((GSILayoutManager)new GSGridLayoutManager());
        int gridY = 0;
        GSTextLabel title = new GSTextLabel(TITLE_TEXT);
        title.getLayout().set(GSGridLayoutManager.GRID_Y, (Object)gridY++).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)10).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.WEST);
        this.add((GSPanel)title);
        GSTextLabel ownerLabel = new GSTextLabel(OWNER_TEXT);
        ownerLabel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)gridY).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.WEST).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)10).set(GSGridLayoutManager.RIGHT_MARGIN, (Object)10);
        this.add((GSPanel)ownerLabel);
        this.ownerField.getLayout().set(GSGridLayoutManager.GRID_X, (Object)1).set(GSGridLayoutManager.GRID_Y, (Object)gridY++).set(GSGridLayoutManager.FILL, (Object)GSEFill.HORIZONTAL).set(GSGridLayoutManager.LEFT_MARGIN, (Object)10).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)10).set(GSGridLayoutManager.PREFERRED_WIDTH, (Object)150);
        this.add((GSPanel)this.ownerField);
        GSTextLabel createdByLabel = new GSTextLabel(CREATED_BY_TEXT);
        createdByLabel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)gridY).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.WEST).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)10).set(GSGridLayoutManager.RIGHT_MARGIN, (Object)10);
        this.add((GSPanel)createdByLabel);
        this.createdByField.getLayout().set(GSGridLayoutManager.GRID_X, (Object)1).set(GSGridLayoutManager.GRID_Y, (Object)gridY++).set(GSGridLayoutManager.FILL, (Object)GSEFill.HORIZONTAL).set(GSGridLayoutManager.LEFT_MARGIN, (Object)10).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)10).set(GSGridLayoutManager.PREFERRED_WIDTH, (Object)150);
        this.add((GSPanel)this.createdByField);
        GSTextLabel collaboratorsLabel = new GSTextLabel(COLLABORATORS_TEXT);
        collaboratorsLabel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)gridY++).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.WEST).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)10);
        this.add((GSPanel)collaboratorsLabel);
        GSScrollPanel scrollPanel = new GSScrollPanel((GSPanel)this.collabTable);
        scrollPanel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)gridY++).set(GSGridLayoutManager.GRID_WIDTH, (Object)2).set(GSGridLayoutManager.WEIGHT_Y, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.FILL, (Object)GSEFill.BOTH).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)11).set(GSGridLayoutManager.PREFERRED_WIDTH, (Object)150);
        this.add((GSPanel)scrollPanel);
        GSParentPanel buttonPanel = new GSParentPanel((GSILayoutManager)new GSGridLayoutManager());
        buttonPanel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)gridY++).set(GSGridLayoutManager.GRID_WIDTH, (Object)2).set(GSGridLayoutManager.FILL, (Object)GSEFill.HORIZONTAL);
        this.add((GSPanel)buttonPanel);
        this.addCollabButton.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.WEIGHT_X, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.EAST).set(GSGridLayoutManager.RIGHT_MARGIN, (Object)10).set(PREFERRED_WIDTH, (Object)((Integer)this.addCollabButton.getProperty(PREFERRED_HEIGHT)));
        buttonPanel.add((GSPanel)this.addCollabButton);
        this.removeCollabButton.getLayout().set(GSGridLayoutManager.GRID_X, (Object)1).set(PREFERRED_WIDTH, (Object)((Integer)this.removeCollabButton.getProperty(PREFERRED_HEIGHT)));
        buttonPanel.add((GSPanel)this.removeCollabButton);
    }

    private void initEventListeners() {
        this.collabTable.getRowSelectionModel().addListener(() -> {
            int selectedRow = this.collabTable.getRowSelectionModel().getIntervalMin();
            GSCollabEntry selectedCollab = null;
            if (selectedRow != -1) {
                selectedCollab = (GSCollabEntry)this.collabTable.getModel().getCellValue(0, selectedRow);
            }
            this.onCollabSelectionChanged(selectedCollab != null ? selectedCollab.getPlayerUUID() : null);
        });
        this.addCollabButton.addActionListener(() -> {
            if (this.info != null) {
                GSPlayerPickerPanel playerPicker = GSPlayerPickerPanel.show(null);
                playerPicker.addActionListener(() -> {
                    if (!playerPicker.isCanceled()) {
                        this.assetManager.addCollaborator(this.info.getAssetUUID(), playerPicker.getSelectedPlayerUUID());
                    }
                });
            }
        });
        this.removeCollabButton.addActionListener(() -> {
            if (this.info != null && this.selectedCollab != null) {
                this.assetManager.removeCollaborator(this.info.getAssetUUID(), this.selectedCollab);
            }
        });
    }

    private void onCollabSelectionChanged(UUID selectedCollab) {
        this.selectedCollab = selectedCollab;
        this.updateButtonEnabled();
    }

    private void updateButtonEnabled() {
        boolean enableButtons = this.info != null && this.assetManager.hasExtendedPermission(this.info.getAssetUUID());
        this.addCollabButton.setEnabled(enableButtons);
        this.removeCollabButton.setEnabled(enableButtons && this.selectedCollab != null);
    }

    public void setInfo(GSAssetInfo info) {
        this.info = info;
        this.onInfoChanged();
    }

    private void onInfoChanged() {
        class_2561 ownerText;
        class_2561 createdByText;
        if (this.info == null) {
            ownerText = createdByText = GSTextUtil.EMPTY;
        } else {
            ownerText = this.playerCache.getNameText(this.info.getOwnerUUID());
            createdByText = this.playerCache.getNameText(this.info.getCreatedByUUID());
        }
        this.ownerField.setText(ownerText);
        this.createdByField.setText(createdByText);
        this.collabTable.setModel(this.createCollabTableModel());
        this.updateButtonEnabled();
    }

    private GSITableModel createCollabTableModel() {
        Set<UUID> collabUUIDs = this.info != null ? this.info.getCollaboratorUUIDs() : Collections.emptySet();
        GSBasicTableModel model = new GSBasicTableModel(1, collabUUIDs.size());
        GSITableColumn nameColumn = model.getColumn(0);
        nameColumn.setHeaderValue((Object)NAME_TEXT);
        nameColumn.setTextAlignment(GSETextAlignment.LEFT);
        int r = 0;
        for (UUID collabUUID : collabUUIDs) {
            GSCollabEntry entry = new GSCollabEntry(collabUUID, this.playerCache.getNameText(collabUUID));
            model.setCellValue(0, r++, (Object)entry);
        }
        return model;
    }

    private static class GSCollabEntry {
        private final UUID playerUUID;
        private final class_2561 name;

        public GSCollabEntry(UUID playerUUID, class_2561 name) {
            this.playerUUID = playerUUID;
            this.name = name;
        }

        public UUID getPlayerUUID() {
            return this.playerUUID;
        }

        public class_2561 getName() {
            return this.name;
        }
    }

    private static class GSCollabEntryCellRenderer
    implements GSICellRenderer<GSCollabEntry> {
        public static final GSCollabEntryCellRenderer INSTANCE = new GSCollabEntryCellRenderer();

        private GSCollabEntryCellRenderer() {
        }

        public void render(GSIRenderer2D renderer, GSCollabEntry value, GSCellContext context) {
            GSTextCellRenderer.INSTANCE.render(renderer, value.getName(), context);
        }

        public GSDimension getMinimumSize(GSCollabEntry value) {
            return GSTextCellRenderer.INSTANCE.getMinimumSize(value.getName());
        }
    }
}

