/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.gui;

import com.g4mesoft.captureplayback.gui.GSCapturePlaybackPanel;
import com.g4mesoft.ui.panel.GSDimension;
import com.g4mesoft.ui.panel.GSEAnchor;
import com.g4mesoft.ui.panel.GSEFill;
import com.g4mesoft.ui.panel.GSEIconAlignment;
import com.g4mesoft.ui.panel.GSEPopupPlacement;
import com.g4mesoft.ui.panel.GSETextAlignment;
import com.g4mesoft.ui.panel.GSGridLayoutManager;
import com.g4mesoft.ui.panel.GSIActionListener;
import com.g4mesoft.ui.panel.GSILayoutManager;
import com.g4mesoft.ui.panel.GSIcon;
import com.g4mesoft.ui.panel.GSMargin;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSPanelUtil;
import com.g4mesoft.ui.panel.GSParentPanel;
import com.g4mesoft.ui.panel.GSPopup;
import com.g4mesoft.ui.panel.GSRectangle;
import com.g4mesoft.ui.panel.GSTexturedIcon;
import com.g4mesoft.ui.panel.button.GSButton;
import com.g4mesoft.ui.panel.cell.GSCellContext;
import com.g4mesoft.ui.panel.cell.GSICellRenderer;
import com.g4mesoft.ui.panel.event.GSIButtonStroke;
import com.g4mesoft.ui.panel.event.GSKeyButtonStroke;
import com.g4mesoft.ui.panel.field.GSTextLabel;
import com.g4mesoft.ui.panel.scroll.GSScrollPanel;
import com.g4mesoft.ui.panel.table.GSBasicTableModel;
import com.g4mesoft.ui.panel.table.GSEHeaderResizePolicy;
import com.g4mesoft.ui.panel.table.GSEHeaderSelectionPolicy;
import com.g4mesoft.ui.panel.table.GSITableModel;
import com.g4mesoft.ui.panel.table.GSTablePanel;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import com.g4mesoft.ui.renderer.GSTexture;
import com.g4mesoft.ui.util.GSTextUtil;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2561;
import net.minecraft.class_310;
import net.minecraft.class_634;
import net.minecraft.class_640;

public class GSPlayerPickerPanel
extends GSParentPanel {
    private static final class_2561 TITLE_TEXT = GSCapturePlaybackPanel.translatable("playerPickerTitle");
    private static final class_2561 CHOOSE_TEXT = GSCapturePlaybackPanel.translatable("choose");
    private static final class_2561 CANCEL_TEXT = GSCapturePlaybackPanel.translatable("cancel");
    private static final GSMargin OUTER_MARGIN = new GSMargin(10);
    private static final int TITLE_MARGIN = 10;
    private static final int BUTTON_MARGIN = 5;
    private final GSTablePanel playerTable = new GSTablePanel(this.createTableModel());
    private final GSButton chooseButton;
    private final GSButton cancelButton;
    private UUID selectedPlayerUUID;
    private boolean canceled;
    private List<GSIActionListener> listeners;

    public GSPlayerPickerPanel() {
        this.playerTable.setColumnHeaderResizePolicy(GSEHeaderResizePolicy.RESIZE_SUBSEQUENT);
        this.playerTable.setRowHeaderResizePolicy(GSEHeaderResizePolicy.RESIZE_OFF);
        this.playerTable.setColumnSelectionPolicy(GSEHeaderSelectionPolicy.DISABLED);
        this.playerTable.setRowSelectionPolicy(GSEHeaderSelectionPolicy.SINGLE_SELECTION);
        this.playerTable.setCellRenderer(class_640.class, (GSICellRenderer)GSPlayerListEntryCellRenderer.INSTANCE);
        this.playerTable.setPreferredRowCount(6);
        this.playerTable.setMinimumRowHeight(16);
        this.chooseButton = new GSButton(CHOOSE_TEXT);
        this.chooseButton.setEnabled(false);
        this.cancelButton = new GSButton(CANCEL_TEXT);
        this.canceled = false;
        this.listeners = new ArrayList<GSIActionListener>();
        this.initLayout();
        this.initEventListeners();
    }

    private void initLayout() {
        this.getLayout().set(GSGridLayoutManager.MARGIN, (Object)OUTER_MARGIN);
        this.setLayoutManager((GSILayoutManager)new GSGridLayoutManager());
        GSTextLabel titleLabel = new GSTextLabel(TITLE_TEXT);
        titleLabel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)0).set(GSGridLayoutManager.GRID_WIDTH, (Object)2).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)10);
        this.add((GSPanel)titleLabel);
        GSScrollPanel scrollPanel = new GSScrollPanel((GSPanel)this.playerTable);
        scrollPanel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)1).set(GSGridLayoutManager.GRID_WIDTH, (Object)2).set(GSGridLayoutManager.WEIGHT_X, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.WEIGHT_Y, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.FILL, (Object)GSEFill.BOTH);
        this.add((GSPanel)scrollPanel);
        this.chooseButton.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)2).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.WEST).set(GSGridLayoutManager.TOP_MARGIN, (Object)5);
        this.add((GSPanel)this.chooseButton);
        this.cancelButton.getLayout().set(GSGridLayoutManager.GRID_X, (Object)1).set(GSGridLayoutManager.GRID_Y, (Object)2).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.EAST).set(GSGridLayoutManager.LEFT_MARGIN, (Object)5).set(GSGridLayoutManager.TOP_MARGIN, (Object)5);
        this.add((GSPanel)this.cancelButton);
        this.setProperty(PREFERRED_WIDTH, 150);
    }

    private void initEventListeners() {
        this.playerTable.getRowSelectionModel().addListener(() -> this.chooseButton.setEnabled(this.playerTable.hasSelection()));
        this.chooseButton.addActionListener(this::chooseAndHide);
        this.cancelButton.addActionListener(this::cancelAndHide);
        this.playerTable.addActionListener(this::chooseAndHide);
        this.putButtonStroke((GSIButtonStroke)new GSKeyButtonStroke(257), this::chooseAndHide);
        this.putButtonStroke((GSIButtonStroke)new GSKeyButtonStroke(256), this::hide);
    }

    private void chooseAndHide() {
        int sr = this.playerTable.getRowSelectionModel().getIntervalMin();
        if (sr != -1) {
            GSITableModel model = this.playerTable.getModel();
            class_640 entry = (class_640)model.getCellValue(0, sr);
            this.selectedPlayerUUID = entry.method_2966().getId();
            this.canceled = false;
            this.hide();
            this.dispatchActionPerformed();
        }
    }

    private void cancelAndHide() {
        this.selectedPlayerUUID = null;
        this.canceled = true;
        this.hide();
        this.dispatchActionPerformed();
    }

    private GSITableModel createTableModel() {
        class_634 networkHandler = class_310.method_1551().method_1562();
        if (networkHandler == null) {
            return new GSBasicTableModel(0, 0);
        }
        ArrayList entries = new ArrayList(networkHandler.method_2880());
        Collections.sort(entries, (lhs, rhs) -> {
            String n0 = lhs.method_2966().getName();
            String n1 = rhs.method_2966().getName();
            return n0.compareToIgnoreCase(n1);
        });
        GSBasicTableModel model = new GSBasicTableModel(1, entries.size());
        model.getColumn(0).setTextAlignment(GSETextAlignment.LEFT);
        model.setColumnHeaderHidden(true);
        model.setRowHeaderHidden(true);
        int r = 0;
        for (class_640 entry : entries) {
            model.setCellValue(0, r++, (Object)entry);
        }
        return model;
    }

    public void addActionListener(GSIActionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.listeners.add(listener);
    }

    public void removeActionListener(GSIActionListener listener) {
        this.listeners.remove(listener);
    }

    private void dispatchActionPerformed() {
        this.listeners.forEach(GSIActionListener::actionPerformed);
    }

    public UUID getSelectedPlayerUUID() {
        return this.selectedPlayerUUID;
    }

    public boolean isCanceled() {
        return this.canceled;
    }

    public static GSPlayerPickerPanel show(GSPanel source) {
        GSPlayerPickerPanel panel = new GSPlayerPickerPanel();
        GSPopup popup = new GSPopup((GSPanel)panel, true);
        popup.setHiddenOnFocusLost(false);
        popup.setSourceFocusedOnHide(source != null);
        popup.show(source, 0, 0, GSEPopupPlacement.CENTER);
        return panel;
    }

    public void hide() {
        GSPanel parent = this.getParent();
        if (parent instanceof GSPopup) {
            ((GSPopup)parent).hide();
        }
    }

    private static class GSPlayerListEntryCellRenderer
    implements GSICellRenderer<class_640> {
        private static final int ICON_SPACING = 5;
        private static final int OUTER_MARGIN = 2;
        private static final GSPlayerListEntryCellRenderer INSTANCE = new GSPlayerListEntryCellRenderer();

        private GSPlayerListEntryCellRenderer() {
        }

        public void render(GSIRenderer2D renderer, class_640 value, GSCellContext context) {
            context.bounds.x += 2;
            context.bounds.width -= 4;
            GSPanelUtil.drawLabel((GSIRenderer2D)renderer, (GSIcon)this.getIcon(value), (int)5, (class_2561)this.getNameAsText(value), (int)context.textColor, (boolean)false, (GSEIconAlignment)GSEIconAlignment.LEFT, (GSETextAlignment)context.textAlignment, (GSRectangle)context.bounds);
        }

        public GSDimension getMinimumSize(class_640 value) {
            return GSPanelUtil.labelPreferredSize((GSIcon)this.getIcon(value), (class_2561)this.getNameAsText(value), (int)5);
        }

        private class_2561 getNameAsText(class_640 value) {
            class_2561 displayText = value.method_2971();
            if (displayText != null) {
                return displayText;
            }
            return GSTextUtil.literal((String)value.method_2966().getName());
        }

        private GSIcon getIcon(class_640 value) {
            GSTexture texture = new GSTexture(value.method_52810().comp_1626(), 64, 64);
            return new GSTexturedIcon(texture.getRegion(8, 8, 8, 8));
        }
    }
}

