/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.mixin.common;

import com.g4mesoft.captureplayback.GSCapturePlaybackExtension;
import com.g4mesoft.captureplayback.access.GSIServerWorldAccess;
import com.g4mesoft.captureplayback.access.GSIWorldAccess;
import com.g4mesoft.captureplayback.common.GSESignalEdge;
import com.g4mesoft.captureplayback.common.GSETickPhase;
import com.g4mesoft.captureplayback.stream.GSICaptureStream;
import com.g4mesoft.captureplayback.stream.GSIPlaybackStream;
import com.g4mesoft.captureplayback.stream.GSIStream;
import com.g4mesoft.captureplayback.stream.GSSignalEvent;
import com.g4mesoft.captureplayback.stream.frame.GSBasicSignalFrame;
import com.g4mesoft.captureplayback.stream.frame.GSISignalFrame;
import com.g4mesoft.captureplayback.stream.frame.GSMergedSignalFrame;
import com.g4mesoft.captureplayback.stream.handler.GSISignalEventContext;
import com.g4mesoft.captureplayback.stream.handler.GSISignalEventHandler;
import com.g4mesoft.captureplayback.stream.handler.GSPoweredState;
import com.g4mesoft.captureplayback.stream.handler.GSServerWorldSignalEventContext;
import com.g4mesoft.core.server.GSServerController;
import it.unimi.dsi.fastutil.objects.ObjectLinkedOpenHashSet;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.UUID;
import java.util.function.BooleanSupplier;
import java.util.function.Supplier;
import net.minecraft.class_1919;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2596;
import net.minecraft.class_2623;
import net.minecraft.class_2665;
import net.minecraft.class_2680;
import net.minecraft.class_2874;
import net.minecraft.class_3218;
import net.minecraft.class_3324;
import net.minecraft.class_3695;
import net.minecraft.class_5269;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.server.MinecraftServer;
import org.spongepowered.asm.mixin.Final;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Shadow;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.Redirect;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;
import org.spongepowered.asm.mixin.injection.callback.LocalCapture;

@Mixin(value={class_3218.class})
public abstract class GSServerWorldMixin
extends class_1937
implements GSIServerWorldAccess,
GSIWorldAccess {
    @Shadow
    @Final
    private MinecraftServer field_13959;
    @Unique
    private final GSCapturePlaybackExtension gcp_extension = GSCapturePlaybackExtension.getInstance();
    @Unique
    private final Map<UUID, GSIPlaybackStream> gcp_playbackStreams = new HashMap<UUID, GSIPlaybackStream>();
    @Unique
    private final Map<UUID, GSICaptureStream> gcp_captureStreams = new HashMap<UUID, GSICaptureStream>();
    @Unique
    private LinkedList<GSSignalEvent> gcp_capturedEvents = new LinkedList();
    @Unique
    private GSISignalFrame gcp_signalFrame;
    @Unique
    private Map<class_2338, GSPoweredState> gcp_poweredStates = new HashMap<class_2338, GSPoweredState>();
    @Unique
    private GSISignalEventContext gcp_signalEventContext = new GSServerWorldSignalEventContext((class_3218)this);
    private GSETickPhase gcp_phase = GSETickPhase.BLOCK_EVENTS;
    private int gcp_blockEventCount = 0;
    private int gcp_microtick = -1;

    protected GSServerWorldMixin(class_5269 properties, class_5321<class_1937> registryRef, class_5455 registryManager, class_6880<class_2874> dimensionEntry, Supplier<class_3695> profiler, boolean isClient, boolean debugWorld, long biomeAccess, int maxChainedNeighborUpdates) {
        super(properties, registryRef, registryManager, dimensionEntry, profiler, isClient, debugWorld, biomeAccess, maxChainedNeighborUpdates);
    }

    @Shadow
    protected abstract boolean method_14174(class_1919 var1);

    @Shadow
    public abstract void method_8427(class_2338 var1, class_2248 var2, int var3, int var4);

    @Inject(method={"tick"}, at={@At(value="HEAD")})
    public void onTickHead(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        if (!this.gcp_playbackStreams.isEmpty() && this.field_13959.method_54833().method_54751()) {
            GSMergedSignalFrame mergedFrame = new GSMergedSignalFrame();
            Iterator<GSIPlaybackStream> playbackStreamItr = this.gcp_playbackStreams.values().iterator();
            while (playbackStreamItr.hasNext()) {
                GSIPlaybackStream playbackStream = playbackStreamItr.next();
                if (playbackStream.isClosed()) {
                    playbackStreamItr.remove();
                    continue;
                }
                mergedFrame.merge((GSISignalFrame)playbackStream.read());
            }
            this.gcp_signalFrame = mergedFrame;
        } else {
            this.gcp_signalFrame = GSISignalFrame.EMPTY;
        }
        Iterator<GSICaptureStream> captureStreamItr = this.gcp_captureStreams.values().iterator();
        while (captureStreamItr.hasNext()) {
            GSICaptureStream captureStream = captureStreamItr.next();
            if (!captureStream.isClosed()) continue;
            captureStreamItr.remove();
        }
        while (this.gcp_signalFrame.hasNext() && this.gcp_signalFrame.peek().getPhase() == GSETickPhase.IMMEDIATE) {
            this.handleSignalEvent(this.gcp_signalFrame.next());
        }
        this.gcp_capturedEvents.clear();
        this.gcp_signalFrame.mark();
    }

    @Unique
    private void handleReadySignalEvents() {
        while (this.gcp_signalFrame.hasNext() && this.isEventReady(this.gcp_signalFrame.peek())) {
            this.handleSignalEvent(this.gcp_signalFrame.next());
        }
    }

    @Unique
    private void handleSignalEvent(GSSignalEvent event) {
        class_2680 state;
        GSISignalEventHandler handler;
        boolean rising;
        boolean bl = rising = event.getEdge() == GSESignalEdge.RISING_EDGE;
        if (rising) {
            this.incrementPowered(event.getPos());
        } else {
            this.decrementPowered(event.getPos());
        }
        if (!event.isShadow() && (handler = this.gcp_extension.getSignalEventHandler((state = this.method_8320(event.getPos())).method_26204())) != null) {
            handler.handle(state, event, this.gcp_signalEventContext);
        }
    }

    @Unique
    private boolean isEventReady(GSSignalEvent event) {
        if (this.gcp_phase.isBefore(event.getPhase())) {
            return false;
        }
        if (this.gcp_phase == GSETickPhase.BLOCK_EVENTS && event.getPhase() == this.gcp_phase) {
            return this.gcp_microtick >= event.getMicrotick();
        }
        return true;
    }

    @Inject(method={"tick"}, at={@At(value="RETURN")})
    public void onTickReturn(BooleanSupplier shouldKeepTicking, CallbackInfo ci) {
        if (!this.gcp_captureStreams.isEmpty()) {
            GSISignalFrame capturedFrame;
            this.gcp_signalFrame.reset();
            if (this.gcp_capturedEvents.isEmpty()) {
                capturedFrame = this.gcp_signalFrame;
            } else {
                GSMergedSignalFrame mergedFrame = new GSMergedSignalFrame();
                mergedFrame.merge(this.gcp_signalFrame);
                mergedFrame.merge(new GSBasicSignalFrame(this.gcp_capturedEvents));
                capturedFrame = mergedFrame;
            }
            for (GSICaptureStream captureStream : this.gcp_captureStreams.values()) {
                captureStream.write(capturedFrame);
            }
        }
    }

    @Inject(method={"processSyncedBlockEvents"}, at={@At(value="HEAD")})
    public void onBlockActionHead(CallbackInfo ci) {
        this.gcp_phase = GSETickPhase.BLOCK_EVENTS;
        this.gcp_blockEventCount = 0;
        this.gcp_microtick = -1;
    }

    @Redirect(method={"processSyncedBlockEvents"}, at=@At(value="INVOKE", ordinal=0, target="Lit/unimi/dsi/fastutil/objects/ObjectLinkedOpenHashSet;isEmpty()Z"))
    public boolean onProcessSyncedBlockEventsLoop(ObjectLinkedOpenHashSet<class_1919> blockEventQueue) {
        while (this.gcp_blockEventCount == 0) {
            this.gcp_blockEventCount = blockEventQueue.size();
            if (this.gcp_blockEventCount != 0) {
                ++this.gcp_microtick;
            } else if (this.gcp_signalFrame.hasNext()) {
                this.gcp_microtick = this.gcp_signalFrame.peek().getMicrotick();
            } else {
                return true;
            }
            this.handleReadySignalEvents();
        }
        return false;
    }

    @Inject(method={"processSyncedBlockEvents"}, allow=1, at={@At(value="INVOKE", shift=At.Shift.AFTER, target="Lit/unimi/dsi/fastutil/objects/ObjectLinkedOpenHashSet;removeFirst()Ljava/lang/Object;")})
    public void onProcessSyncedBlockEventsProcessing(CallbackInfo ci) {
        --this.gcp_blockEventCount;
    }

    @Inject(method={"processSyncedBlockEvents"}, locals=LocalCapture.CAPTURE_FAILEXCEPTION, at={@At(value="INVOKE", shift=At.Shift.BEFORE, target="Lnet/minecraft/server/MinecraftServer;getPlayerManager()Lnet/minecraft/server/PlayerManager;")})
    public void onProcessSyncedBlockEventsSuccess(CallbackInfo ci, class_1919 blockEvent) {
        class_2248 block;
        if (this.gcp_isCapturePosition(blockEvent.comp_60()) && ((block = blockEvent.comp_61()) == class_2246.field_10615 || block == class_2246.field_10560)) {
            GSESignalEdge edge = blockEvent.comp_62() == 0 ? GSESignalEdge.RISING_EDGE : GSESignalEdge.FALLING_EDGE;
            this.gcp_handleCaptureEvent(edge, blockEvent.comp_60());
        }
    }

    @Inject(method={"processSyncedBlockEvents"}, at={@At(value="RETURN")})
    public void onProcessSyncedBlockEventsReturn(CallbackInfo ci) {
        this.gcp_microtick = -1;
    }

    @Override
    public boolean gcp_isPoweredByPlayback(class_2338 pos) {
        class_2248 block = this.method_8320(pos).method_26204();
        if (this.gcp_extension.hasSignalEventHandler(block)) {
            return this.gcp_isPlaybackPowering(pos);
        }
        return false;
    }

    @Override
    public void gcp_handleCaptureEvent(GSESignalEdge edge, class_2338 pos) {
        if (!this.gcp_captureStreams.isEmpty()) {
            this.gcp_capturedEvents.add(new GSSignalEvent(this.gcp_phase, this.gcp_microtick, this.gcp_capturedEvents.size(), edge, pos, false));
        }
    }

    @Override
    public boolean gcp_hasPlaybackStream(UUID assetUUID) {
        return this.gcp_playbackStreams.containsKey(assetUUID);
    }

    @Override
    public void gcp_addPlaybackStream(UUID assetUUID, GSIPlaybackStream playbackStream) {
        if (!playbackStream.isClosed()) {
            this.gcp_playbackStreams.put(assetUUID, playbackStream);
        }
    }

    @Override
    public GSIPlaybackStream gcp_getPlaybackStream(UUID assetUUID) {
        return this.gcp_playbackStreams.get(assetUUID);
    }

    @Override
    public Collection<GSIPlaybackStream> gcp_getPlaybackStreams() {
        return Collections.unmodifiableCollection(this.gcp_playbackStreams.values());
    }

    @Override
    public boolean gcp_hasCaptureStream(UUID assetUUID) {
        return this.gcp_captureStreams.containsKey(assetUUID);
    }

    @Override
    public void gcp_addCaptureStream(UUID assetUUID, GSICaptureStream captureStream) {
        if (!captureStream.isClosed()) {
            this.gcp_captureStreams.put(assetUUID, captureStream);
        }
    }

    @Override
    public GSICaptureStream gcp_getCaptureStream(UUID assetUUID) {
        return this.gcp_captureStreams.get(assetUUID);
    }

    @Override
    public Collection<GSICaptureStream> gcp_getCaptureStreams() {
        return Collections.unmodifiableCollection(this.gcp_captureStreams.values());
    }

    @Override
    public boolean gcp_isPlaybackPosition(class_2338 pos) {
        return this.isPositionInStreams(this.gcp_playbackStreams.values(), pos);
    }

    @Override
    public boolean gcp_isCapturePosition(class_2338 pos) {
        return this.isPositionInStreams(this.gcp_captureStreams.values(), pos);
    }

    @Unique
    private boolean isPositionInStreams(Collection<? extends GSIStream> streams, class_2338 pos) {
        for (GSIStream gSIStream : streams) {
            if (!gSIStream.getBlockRegion().contains(pos.method_10263(), pos.method_10264(), pos.method_10260())) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean gcp_isPlaybackPowering(class_2338 pos) {
        GSPoweredState poweredState = this.gcp_poweredStates.get(pos);
        return poweredState != null && poweredState.isPowered();
    }

    @Unique
    private void incrementPowered(class_2338 pos) {
        GSPoweredState poweredState = this.gcp_poweredStates.get(pos);
        if (poweredState != null) {
            poweredState.increment();
        } else {
            this.gcp_poweredStates.put(pos, new GSPoweredState(1));
        }
    }

    @Unique
    private void decrementPowered(class_2338 pos) {
        GSPoweredState poweredState = this.gcp_poweredStates.get(pos);
        if (poweredState != null) {
            poweredState.decrement();
            if (!poweredState.isPowered()) {
                this.gcp_poweredStates.remove(pos);
            }
        }
    }

    @Override
    public boolean gcp_dispatchBlockEvent(class_2338 pos, class_2248 block, int type, int data) {
        class_1919 blockAction = new class_1919(pos, block, type, data);
        if (this.method_14174(blockAction)) {
            class_2623 packet = new class_2623(pos, block, type, data);
            double dist = 64.0;
            if (block instanceof class_2665) {
                dist = 16.0 * (double)GSServerController.getInstance().getTpsModule().sBlockEventDistance.get().intValue();
            }
            class_3324 playerManager = this.field_13959.method_3760();
            playerManager.method_14605(null, (double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260(), dist, this.method_27983(), (class_2596)packet);
            return true;
        }
        return false;
    }

    @Override
    public void gcp_dispatchNeighborUpdate(class_2338 pos, class_2248 fromBlock, class_2350 fromDir) {
        this.method_8492(pos, fromBlock, pos.method_10093(fromDir));
    }

    @Override
    public boolean gcp_setState(class_2338 pos, class_2680 state, int flags) {
        return this.method_8652(pos, state, flags);
    }
}

