/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.module.client;

import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.captureplayback.common.asset.GSAssetCollaboratorPacket;
import com.g4mesoft.captureplayback.common.asset.GSAssetHandle;
import com.g4mesoft.captureplayback.common.asset.GSAssetHistory;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSCreateAssetPacket;
import com.g4mesoft.captureplayback.common.asset.GSDecodedAssetFile;
import com.g4mesoft.captureplayback.common.asset.GSDeleteAssetPacket;
import com.g4mesoft.captureplayback.common.asset.GSEAssetType;
import com.g4mesoft.captureplayback.common.asset.GSIAssetHistory;
import com.g4mesoft.captureplayback.common.asset.GSImportAssetPacket;
import com.g4mesoft.captureplayback.common.asset.GSPlayerCache;
import com.g4mesoft.captureplayback.common.asset.GSRequestAssetPacket;
import com.g4mesoft.captureplayback.common.asset.GSUnmodifiableAssetHistory;
import com.g4mesoft.captureplayback.gui.GSCompositionEditPanel;
import com.g4mesoft.captureplayback.gui.GSSequenceEditPanel;
import com.g4mesoft.captureplayback.session.GSESessionRequestType;
import com.g4mesoft.captureplayback.session.GSESessionType;
import com.g4mesoft.captureplayback.session.GSISessionListener;
import com.g4mesoft.captureplayback.session.GSSession;
import com.g4mesoft.captureplayback.session.GSSessionDeltasPacket;
import com.g4mesoft.captureplayback.session.GSSessionRequestPacket;
import com.g4mesoft.captureplayback.session.GSSessionSide;
import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.core.client.GSIClientModuleManager;
import com.g4mesoft.packet.GSIPacket;
import com.g4mesoft.ui.panel.GSPanel;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import java.util.function.Consumer;
import net.minecraft.class_1657;
import net.minecraft.class_746;

public class GSClientAssetManager
implements GSISessionListener {
    private final GSIClientModuleManager manager;
    private final Map<UUID, GSSession> sessions;
    private final Map<GSESessionType, GSSession> sessionByType;
    private final Map<GSESessionType, GSPanel> sessionPanels;
    private final GSIAssetHistory history;
    private final GSIAssetHistory unmodifiableHistory;
    private final Map<UUID, Consumer<GSDecodedAssetFile>> requestCallbacks;
    private final GSPlayerCache playerCache;

    GSClientAssetManager(GSIClientModuleManager manager) {
        this.manager = manager;
        this.sessions = new HashMap<UUID, GSSession>();
        this.sessionByType = new EnumMap<GSESessionType, GSSession>(GSESessionType.class);
        this.sessionPanels = new EnumMap<GSESessionType, GSPanel>(GSESessionType.class);
        this.history = new GSAssetHistory();
        this.unmodifiableHistory = new GSUnmodifiableAssetHistory(this.history);
        this.requestCallbacks = new HashMap<UUID, Consumer<GSDecodedAssetFile>>();
        this.playerCache = new GSPlayerCache();
    }

    void onDisconnect() {
        UUID[] assetUUIDs;
        this.history.clear();
        for (UUID assetUUID : assetUUIDs = this.sessions.keySet().toArray(new UUID[0])) {
            this.onSessionStop(assetUUID);
        }
    }

    public void requestSession(GSESessionRequestType requestType, UUID assetUUID) {
        this.manager.sendPacket((GSIPacket)new GSSessionRequestPacket(requestType, assetUUID));
    }

    public void requestSession(GSESessionRequestType requestType, GSAssetHandle handle) {
        GSAssetInfo info = this.history.getFromHandle(handle);
        if (info != null) {
            this.requestSession(requestType, info.getAssetUUID());
        }
    }

    public GSSession getSession(GSESessionType sessionType) {
        return this.sessionByType.get((Object)sessionType);
    }

    public void createAsset(String name, GSEAssetType type, GSAssetHandle handle, UUID originalAssetUUID) {
        if (originalAssetUUID == null || this.hasPermission(originalAssetUUID)) {
            this.manager.sendPacket((GSIPacket)new GSCreateAssetPacket(name, type, handle, originalAssetUUID));
        }
    }

    public void deleteAsset(UUID assetUUID) {
        if (this.hasExtendedPermission(assetUUID)) {
            this.manager.sendPacket((GSIPacket)new GSDeleteAssetPacket(assetUUID));
        }
    }

    public void importAsset(String name, GSAssetHandle handle, GSDecodedAssetFile assetFile) {
        this.manager.sendPacket((GSIPacket)new GSImportAssetPacket(name, handle, assetFile));
    }

    public void requestAsset(UUID assetUUID, Consumer<GSDecodedAssetFile> callback) {
        if (callback == null) {
            throw new IllegalArgumentException("callback is null");
        }
        if (this.hasPermission(assetUUID)) {
            this.requestCallbacks.put(assetUUID, callback);
            this.manager.sendPacket((GSIPacket)new GSRequestAssetPacket(assetUUID));
        } else {
            callback.accept(null);
        }
    }

    public void addCollaborator(UUID assetUUID, UUID collabUUID) {
        GSAssetInfo info;
        if (this.hasExtendedPermission(assetUUID) && !(info = this.history.get(assetUUID)).getCollaboratorUUIDs().contains(collabUUID)) {
            this.manager.sendPacket((GSIPacket)new GSAssetCollaboratorPacket(assetUUID, collabUUID, false));
        }
    }

    public void removeCollaborator(UUID assetUUID, UUID collabUUID) {
        GSAssetInfo info;
        if (this.hasExtendedPermission(assetUUID) && (info = this.history.get(assetUUID)).getCollaboratorUUIDs().contains(collabUUID)) {
            this.manager.sendPacket((GSIPacket)new GSAssetCollaboratorPacket(assetUUID, collabUUID, true));
        }
    }

    public boolean hasPermission(UUID assetUUID) {
        GSAssetInfo info = this.history.get(assetUUID);
        class_746 player = GSClientController.getInstance().getPlayer();
        return info != null && info.hasPermission((class_1657)player);
    }

    public boolean hasExtendedPermission(UUID assetUUID) {
        GSAssetInfo info = this.history.get(assetUUID);
        class_746 player = GSClientController.getInstance().getPlayer();
        return info != null && info.hasExtendedPermission((class_1657)player);
    }

    public void onSessionStart(GSSession session) {
        GSSession activeSession = this.getSession(session.getType());
        if (activeSession != null) {
            UUID assetUUID = activeSession.get(GSSession.ASSET_UUID);
            this.requestSession(GSESessionRequestType.REQUEST_STOP, assetUUID);
            this.onSessionStop(assetUUID);
        }
        this.sessions.put(session.get(GSSession.ASSET_UUID), session);
        this.sessionByType.put(session.getType(), session);
        session.setSide(GSSessionSide.CLIENT_SIDE);
        session.addListener(this);
        switch (session.getType()) {
            case COMPOSITION: {
                this.openSessionPanel(session.getType(), (GSPanel)new GSCompositionEditPanel(session));
                break;
            }
            case SEQUENCE: {
                this.openSessionPanel(session.getType(), (GSPanel)new GSSequenceEditPanel(session));
            }
        }
    }

    public void onSessionStop(UUID assetUUID) {
        GSSession session = this.sessions.remove(assetUUID);
        if (session != null) {
            this.sessionByType.remove((Object)session.getType());
            session.removeListener(this);
            this.closeSessionPanel(session.getType());
        }
    }

    private void openSessionPanel(GSESessionType sessionType, GSPanel panel) {
        if (this.sessionPanels.containsKey((Object)sessionType)) {
            this.closeSessionPanel(sessionType);
        }
        this.sessionPanels.put(sessionType, panel);
        GSClientController.getInstance().getPrimaryGUI().setContent(panel);
    }

    private void closeSessionPanel(GSESessionType sessionType) {
        GSPanel panel = this.sessionPanels.remove((Object)sessionType);
        if (panel != null) {
            GSClientController.getInstance().getPrimaryGUI().removeHistory(panel);
        }
    }

    @Override
    public void onSessionDeltas(GSSession session, GSIDelta<GSSession>[] deltas) {
        this.manager.sendPacket((GSIPacket)new GSSessionDeltasPacket(session.get(GSSession.ASSET_UUID), deltas));
    }

    public void onSessionDeltasReceived(UUID assetUUID, GSIDelta<GSSession>[] deltas) {
        GSSession session = this.sessions.get(assetUUID);
        if (session != null) {
            session.applySessionDeltas(deltas);
        }
    }

    public void onAssetHistoryReceived(GSAssetHistory history) {
        this.history.set(history);
    }

    public void onAssetInfoChanged(GSAssetInfo info) {
        this.history.add(info);
    }

    public void onAssetInfoRemoved(UUID assetUUID) {
        this.history.remove(assetUUID);
    }

    public void onAssetRequestDenied(UUID assetUUID) {
        Consumer<GSDecodedAssetFile> callback = this.requestCallbacks.remove(assetUUID);
        if (callback != null) {
            callback.accept(null);
        }
    }

    public void onAssetRequestSuccess(GSDecodedAssetFile assetFile) {
        UUID assetUUID = assetFile.getAsset().getUUID();
        Consumer<GSDecodedAssetFile> callback = this.requestCallbacks.remove(assetUUID);
        if (callback != null) {
            callback.accept(assetFile);
        }
    }

    public GSIAssetHistory getAssetHistory() {
        return this.unmodifiableHistory;
    }

    public GSPlayerCache getPlayerCache() {
        return this.playerCache;
    }
}

