/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.module.client;

import com.g4mesoft.captureplayback.module.client.GSCapturePlaybackClientModule;
import com.g4mesoft.captureplayback.module.client.GSClientAssetManager;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSChannelInfo;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.session.GSESessionType;
import com.g4mesoft.captureplayback.session.GSSession;
import com.g4mesoft.ui.renderer.GSERenderPhase;
import com.g4mesoft.ui.renderer.GSIRenderable3D;
import com.g4mesoft.ui.renderer.GSIRenderer3D;
import com.g4mesoft.ui.util.GSColorUtil;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_243;
import net.minecraft.class_290;
import net.minecraft.class_310;

public class GSSequencePositionRenderable
implements GSIRenderable3D {
    private static final int COLOR_ALPHA = 128;
    private static final float UNIT_SURFACE_OFFSET = 2.0E-4f;
    private static final float MINIMUM_SURFACE_OFFSET = 0.001f;
    private static final float SELECTION_THICKNESS = 0.0625f;
    private static final float SELECTION_NOTCH = 0.25f;
    private static final float[] SELECTION_VERTICES = GSSequencePositionRenderable.computeSelectionVertices(0.0625f, 0.25f);
    private final GSCapturePlaybackClientModule module;
    private final GSClientAssetManager assetManager;

    public GSSequencePositionRenderable(GSCapturePlaybackClientModule module) {
        this.module = module;
        this.assetManager = module.getAssetManager();
    }

    public void render(GSIRenderer3D renderer) {
        GSSession session = this.assetManager.getSession(GSESessionType.SEQUENCE);
        if (session != null) {
            GSSequence sequence = session.get(GSSession.SEQUENCE);
            switch (this.module.cChannelRenderingType.get()) {
                case 1: {
                    this.renderCubes(renderer, session, sequence);
                    break;
                }
                case 2: {
                    RenderSystem.disableDepthTest();
                    this.renderCubes(renderer, session, sequence);
                    RenderSystem.enableDepthTest();
                    break;
                }
            }
        }
    }

    private void renderCubes(GSIRenderer3D renderer, GSSession session, GSSequence sequence) {
        class_310 client = class_310.method_1551();
        class_243 cameraPos = client.field_1773.method_19418().method_19326();
        float viewDistance = client.field_1773.method_3193();
        UUID selectedChannelUUID = session.get(GSSession.SELECTED_CHANNEL);
        ArrayList<GSCubeEntry> cubes = new ArrayList<GSCubeEntry>();
        for (GSChannel channel : sequence.getChannels()) {
            GSChannelInfo info = channel.getInfo();
            boolean selected = Objects.equals(selectedChannelUUID, channel.getChannelUUID());
            for (class_2338 position : info.getPositions()) {
                double dz;
                double dy;
                double dx = (double)position.method_10263() - cameraPos.method_10216() + 0.5;
                float dist = (float)Math.sqrt(dx * dx + (dy = (double)position.method_10264() - cameraPos.method_10214() + 0.5) * dy + (dz = (double)position.method_10260() - cameraPos.method_10215() + 0.5) * dz);
                if (!(dist <= viewDistance)) continue;
                cubes.add(new GSCubeEntry(this, position, info.getColor(), dist, selected));
            }
        }
        Collections.sort(cubes, (c0, c1) -> Float.compare(c1.dist, c0.dist));
        renderer.build(GSIRenderer3D.QUADS, class_290.field_1576);
        for (GSCubeEntry cube : cubes) {
            float rx = (float)((double)cube.position.method_10263() - cameraPos.method_10216());
            float ry = (float)((double)cube.position.method_10264() - cameraPos.method_10214());
            float rz = (float)((double)cube.position.method_10260() - cameraPos.method_10215());
            float offset = Math.max(0.001f, cube.dist * 2.0E-4f);
            int color = cube.color & 0xFFFFFF | Integer.MIN_VALUE;
            renderer.fillCuboid(rx - offset, ry - offset, rz - offset, rx + 1.0f + offset, ry + 1.0f + offset, rz + 1.0f + offset, color);
            if (!cube.selected) continue;
            this.renderSelectedOutline(renderer, rx, ry, rz, 2.0f * offset, -1593835521);
        }
        renderer.finish();
    }

    private void renderSelectedOutline(GSIRenderer3D renderer, float rx, float ry, float rz, float offset, int color) {
        float rx0 = rx - offset;
        float ry0 = ry - offset;
        float rz0 = rz - offset;
        float rx1 = rx + 1.0f + offset;
        float ry1 = ry + 1.0f + offset;
        float rz1 = rz + 1.0f + offset;
        float r = (float)GSColorUtil.unpackR((int)color) / 255.0f;
        float g = (float)GSColorUtil.unpackG((int)color) / 255.0f;
        float b = (float)GSColorUtil.unpackB((int)color) / 255.0f;
        float a = (float)GSColorUtil.unpackA((int)color) / 255.0f;
        int i = 0;
        while (i < SELECTION_VERTICES.length) {
            float x0 = rx0 + (rx1 - rx0) * SELECTION_VERTICES[i++];
            float y0 = ry0 + (ry1 - ry0) * SELECTION_VERTICES[i++];
            float z0 = rz0 + (rz1 - rz0) * SELECTION_VERTICES[i++];
            renderer.vert(x0, y0, z0).color(r, g, b, a).next();
        }
    }

    public GSERenderPhase getRenderPhase() {
        return GSERenderPhase.TRANSPARENT_LAST;
    }

    private static float[] computeSelectionVertices(float thickness, float notch) {
        int i;
        float[] faceVertices = new float[]{0.0f, 0.0f, 0.0f, thickness, notch, thickness, notch, 0.0f, 0.0f, thickness, 0.0f, notch, thickness, notch, thickness, thickness, 0.0f, 1.0f, notch, 1.0f, notch, 1.0f - thickness, 0.0f, 1.0f - thickness, 0.0f, 1.0f - thickness, thickness, 1.0f - thickness, thickness, 1.0f - notch, 0.0f, 1.0f - notch, 1.0f, 0.0f, 1.0f - notch, 0.0f, 1.0f - notch, thickness, 1.0f, thickness, 1.0f, thickness, 1.0f - thickness, thickness, 1.0f - thickness, notch, 1.0f, notch, 1.0f, 1.0f, 1.0f, 1.0f - thickness, 1.0f - notch, 1.0f - thickness, 1.0f - notch, 1.0f, 1.0f, 1.0f - thickness, 1.0f, 1.0f - notch, 1.0f - thickness, 1.0f - notch, 1.0f - thickness, 1.0f - thickness};
        int vertexCount = faceVertices.length / 2;
        float[] vertices = new float[18 * vertexCount];
        int v = 0;
        for (i = 0; i < vertexCount; ++i) {
            vertices[v++] = faceVertices[2 * i + 0];
            vertices[v++] = faceVertices[2 * i + 1];
            vertices[v++] = 0.0f;
        }
        for (i = 0; i < vertexCount; ++i) {
            vertices[v++] = faceVertices[2 * i + 1];
            vertices[v++] = faceVertices[2 * i + 0];
            vertices[v++] = 1.0f;
        }
        for (i = 0; i < vertexCount; ++i) {
            vertices[v++] = 0.0f;
            vertices[v++] = faceVertices[2 * i + 0];
            vertices[v++] = faceVertices[2 * i + 1];
        }
        for (i = 0; i < vertexCount; ++i) {
            vertices[v++] = 1.0f;
            vertices[v++] = faceVertices[2 * i + 1];
            vertices[v++] = faceVertices[2 * i + 0];
        }
        for (i = 0; i < vertexCount; ++i) {
            vertices[v++] = faceVertices[2 * i + 1];
            vertices[v++] = 0.0f;
            vertices[v++] = faceVertices[2 * i + 0];
        }
        for (i = 0; i < vertexCount; ++i) {
            vertices[v++] = faceVertices[2 * i + 0];
            vertices[v++] = 1.0f;
            vertices[v++] = faceVertices[2 * i + 1];
        }
        return vertices;
    }

    private class GSCubeEntry {
        private final class_2338 position;
        private final int color;
        private final float dist;
        private boolean selected;

        public GSCubeEntry(GSSequencePositionRenderable gSSequencePositionRenderable, class_2338 position, int color, float distSqr, boolean selected) {
            this.position = position;
            this.color = color;
            this.dist = distSqr;
            this.selected = selected;
        }
    }
}

