/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.module.server;

import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSAssetRef;
import com.g4mesoft.captureplayback.common.asset.GSCompositionAsset;
import com.g4mesoft.captureplayback.common.asset.GSEAssetType;
import com.g4mesoft.captureplayback.common.asset.GSSequenceAsset;
import com.g4mesoft.captureplayback.module.server.GSISessionStatusListener;
import com.g4mesoft.captureplayback.session.GSESessionRequestType;
import com.g4mesoft.captureplayback.session.GSESessionType;
import com.g4mesoft.captureplayback.session.GSISessionListener;
import com.g4mesoft.captureplayback.session.GSSession;
import com.g4mesoft.captureplayback.session.GSSessionDeltasPacket;
import com.g4mesoft.captureplayback.session.GSSessionSide;
import com.g4mesoft.captureplayback.session.GSSessionStartPacket;
import com.g4mesoft.captureplayback.session.GSSessionStopPacket;
import com.g4mesoft.core.server.GSIServerModuleManager;
import com.g4mesoft.packet.GSIPacket;
import com.g4mesoft.util.GSFileUtil;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_3222;

public class GSSessionTracker
implements GSISessionListener {
    private static final String SESSION_EXTENSION = ".session";
    private final GSIServerModuleManager manager;
    private final GSAssetInfo info;
    private final GSAssetRef ref;
    private final File cacheDir;
    private final GSESessionType sessionType;
    private final Map<UUID, GSSession> playerUUIDToSession;
    private final Map<GSSession, UUID> sessionToPlayerUUID;
    private GSISessionStatusListener listener;

    GSSessionTracker(GSIServerModuleManager manager, GSAssetInfo info, GSAssetRef ref, File cacheDir) {
        if (!info.getAssetUUID().equals(ref.get().getUUID())) {
            throw new IllegalArgumentException("Asset info does not correspond to the asset.");
        }
        this.manager = manager;
        this.info = info;
        this.ref = ref;
        this.cacheDir = cacheDir;
        GSEAssetType assetType = info.getType();
        if (assetType == null) {
            throw new IllegalArgumentException("Unknown asset type (null)!");
        }
        this.sessionType = GSSessionTracker.toSessionType(assetType);
        this.playerUUIDToSession = new HashMap<UUID, GSSession>();
        this.sessionToPlayerUUID = new IdentityHashMap<GSSession, UUID>();
        this.listener = null;
    }

    private static GSESessionType toSessionType(GSEAssetType assetType) {
        switch (assetType) {
            case COMPOSITION: {
                return GSESessionType.COMPOSITION;
            }
            case SEQUENCE: {
                return GSESessionType.SEQUENCE;
            }
        }
        throw new IllegalStateException("Unknown asset type");
    }

    public boolean onRequest(class_3222 player, GSESessionRequestType requestType) {
        switch (requestType) {
            case REQUEST_START: {
                return this.onRequestStart(player);
            }
            case REQUEST_STOP: {
                return this.onRequestStop(player);
            }
        }
        throw new IllegalStateException("Unknown request type");
    }

    private boolean onRequestStart(class_3222 player) {
        GSSession session;
        UUID playerUUID = player.method_5667();
        if (this.playerUUIDToSession.containsKey(playerUUID)) {
            this.onRequestStop(player);
        }
        if ((session = this.readSession(playerUUID)) == null || !this.info.getAssetUUID().equals(session.get(GSSession.ASSET_UUID))) {
            session = new GSSession(this.sessionType);
            session.set(GSSession.ASSET_UUID, this.info.getAssetUUID());
            session.set(GSSession.ASSET_HANDLE, this.info.getHandle());
        }
        switch (this.sessionType) {
            case COMPOSITION: {
                session.set(GSSession.COMPOSITION, ((GSCompositionAsset)this.ref.get()).getComposition());
                break;
            }
            case SEQUENCE: {
                session.set(GSSession.SEQUENCE, ((GSSequenceAsset)this.ref.get()).getSequence());
            }
        }
        session.setSide(GSSessionSide.SERVER_SIDE);
        this.playerUUIDToSession.put(playerUUID, session);
        this.sessionToPlayerUUID.put(session, playerUUID);
        this.onSessionStarted(player, session);
        return true;
    }

    private void onSessionStarted(class_3222 player, GSSession session) {
        session.addListener(this);
        this.manager.sendPacket((GSIPacket)new GSSessionStartPacket(session), player);
        this.dispatchSessionStarted(player, this.info.getAssetUUID());
    }

    private boolean onRequestStop(class_3222 player) {
        GSSession session = this.playerUUIDToSession.remove(player.method_5667());
        if (session != null) {
            this.sessionToPlayerUUID.remove(session);
            this.onSessionStopped(player, session);
            return true;
        }
        return false;
    }

    private void onSessionStopped(class_3222 player, GSSession session) {
        this.writeSession(player.method_5667(), session);
        session.removeListener(this);
        this.manager.sendPacket((GSIPacket)new GSSessionStopPacket(this.info.getAssetUUID()), player);
        this.dispatchSessionStopped(player, this.info.getAssetUUID());
    }

    public void onDeltasReceived(class_3222 player, GSIDelta<GSSession>[] deltas) {
        GSSession session = this.playerUUIDToSession.get(player.method_5667());
        if (session != null) {
            session.applySessionDeltas(deltas);
        }
    }

    public void stopAll() {
        for (Map.Entry<UUID, GSSession> entry : this.playerUUIDToSession.entrySet()) {
            class_3222 player = this.manager.getPlayer(entry.getKey());
            if (player == null) continue;
            this.onSessionStopped(player, entry.getValue());
        }
        this.playerUUIDToSession.clear();
        this.sessionToPlayerUUID.clear();
    }

    public GSSession getSession(class_3222 player) {
        return this.playerUUIDToSession.get(player.method_5667());
    }

    public void setListener(GSISessionStatusListener listener) {
        if (this.listener != null && listener != null) {
            throw new IllegalStateException("Tracker only supports a single listener");
        }
        this.listener = listener;
    }

    private void dispatchSessionStarted(class_3222 player, UUID assetUUID) {
        if (this.listener != null) {
            this.listener.sessionStarted(player, assetUUID);
        }
    }

    private void dispatchSessionStopped(class_3222 player, UUID assetUUID) {
        if (this.listener != null) {
            this.listener.sessionStopped(player, assetUUID);
        }
    }

    private GSSession readSession(UUID playerUUID) {
        try {
            return (GSSession)GSFileUtil.readFile((File)this.getSessionFile(playerUUID), GSSession::read);
        }
        catch (IOException iOException) {
            return null;
        }
    }

    private void writeSession(UUID playerUUID, GSSession session) {
        try {
            GSFileUtil.writeFile((File)this.getSessionFile(playerUUID), (Object)session, GSSession::writeCache);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    private File getSessionFile(UUID playerUUID) {
        return new File(this.cacheDir, playerUUID.toString() + SESSION_EXTENSION);
    }

    public GSESessionType getSessionType() {
        return this.sessionType;
    }

    public boolean isEmpty() {
        return this.playerUUIDToSession.isEmpty();
    }

    public GSAssetRef getRef() {
        return this.ref;
    }

    @Override
    public void onSessionDeltas(GSSession session, GSIDelta<GSSession>[] deltas) {
        class_3222 player;
        UUID playerUUID = this.sessionToPlayerUUID.get(session);
        if (playerUUID != null && (player = this.manager.getPlayer(playerUUID)) != null) {
            this.manager.sendPacket((GSIPacket)new GSSessionDeltasPacket(this.info.getAssetUUID(), deltas), player);
        }
    }
}

