/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.panel.composition;

import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSTrack;
import com.g4mesoft.captureplayback.panel.GSIModelViewListener;
import com.g4mesoft.captureplayback.panel.composition.GSCompositionModelView;
import com.g4mesoft.ui.panel.GSDimension;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSRectangle;
import com.g4mesoft.ui.panel.scroll.GSIScrollable;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import com.g4mesoft.ui.util.GSColorUtil;

public class GSCompositionTrackHeaderPanel
extends GSPanel
implements GSIScrollable,
GSIModelViewListener {
    private static final int TRACK_HEADER_PREFERRED_WIDTH = 90;
    private static final int TRACK_LABEL_COLOR = -12303292;
    private final GSComposition composition;
    private final GSCompositionModelView modelView;

    public GSCompositionTrackHeaderPanel(GSComposition composition, GSCompositionModelView modelView) {
        this.composition = composition;
        this.modelView = modelView;
    }

    protected void onShown() {
        super.onShown();
        this.modelView.addModelViewListener(this);
    }

    protected void onHidden() {
        super.onHidden();
        this.modelView.removeModelViewListener(this);
    }

    public void render(GSIRenderer2D renderer) {
        super.render(renderer);
        GSRectangle bounds = renderer.getClipBounds().intersection(0, 0, this.width, this.height);
        this.renderBackground(renderer, bounds);
        this.renderHeaders(renderer, bounds);
    }

    private void renderBackground(GSIRenderer2D renderer, GSRectangle bounds) {
        renderer.fillRect(bounds.x, bounds.y, bounds.width, bounds.height, -13421773);
    }

    private void renderHeaders(GSIRenderer2D renderer, GSRectangle bounds) {
        for (GSTrack track : this.composition.getTracks()) {
            this.renderHeader(renderer, track, 1, this.width - 1, bounds);
        }
    }

    private void renderHeader(GSIRenderer2D renderer, GSTrack track, int x, int width, GSRectangle bounds) {
        int y = this.modelView.getTrackY(track.getTrackUUID());
        if (y + this.modelView.getTrackHeight() >= bounds.y && y - bounds.y < bounds.height) {
            renderer.fillRect(x, y, width, this.modelView.getTrackHeight(), -12303292);
            renderer.drawTextNoStyle((CharSequence)track.getName(), x + 2, y + 2, GSColorUtil.brighter((int)track.getColor()), false);
        }
    }

    protected GSDimension calculatePreferredSize() {
        return new GSDimension(90, this.modelView.getMinimumHeight());
    }

    public void setEditable(boolean editable) {
    }

    public boolean isScrollableHeightFilled() {
        return true;
    }

    @Override
    public void modelViewChanged() {
        this.invalidate();
    }
}

