/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.panel.sequence;

import com.g4mesoft.captureplayback.panel.sequence.GSEditorPanel;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSChannelInfo;
import com.g4mesoft.ui.panel.GSEAnchor;
import com.g4mesoft.ui.panel.GSEFill;
import com.g4mesoft.ui.panel.GSGridLayoutManager;
import com.g4mesoft.ui.panel.GSILayoutManager;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.field.GSColorPickerField;
import com.g4mesoft.ui.panel.field.GSTextField;
import com.g4mesoft.ui.panel.field.GSTextLabel;
import com.g4mesoft.ui.panel.scroll.GSScrollPanel;
import com.g4mesoft.ui.panel.table.GSEHeaderResizePolicy;
import com.g4mesoft.ui.panel.table.GSITableModel;
import com.g4mesoft.ui.panel.table.GSTablePanel;
import com.g4mesoft.ui.util.GSTextUtil;
import java.util.Set;
import net.minecraft.class_2338;
import net.minecraft.class_2561;

public class GSChannelEditorPanel
extends GSEditorPanel {
    private static final int FIELD_MARGIN = 2;
    private static final class_2561 TITLE_TEXT = GSTextUtil.translatable((String)"panel.edit.channel.title");
    private static final class_2561 NAME_TEXT = GSTextUtil.translatable((String)"panel.edit.channel.name");
    private static final class_2561 COLOR_TEXT = GSTextUtil.translatable((String)"panel.edit.channel.color");
    private static final class_2561 POSITIONS_TEXT = GSTextUtil.translatable((String)"panel.edit.channel.positions");
    private final GSChannel channel;
    private GSChannelInfo info;
    private final GSTextField nameField;
    private final GSColorPickerField colorPickerField;

    public GSChannelEditorPanel(GSChannel channel) {
        this.channel = channel;
        this.info = channel.getInfo();
        this.nameField = new GSTextField(this.info.getName());
        this.colorPickerField = new GSColorPickerField(this.info.getColor());
        this.setTitle(TITLE_TEXT);
        this.initLayout(this.getContentPanel());
    }

    private void initLayout(GSPanel contentPanel) {
        contentPanel.setLayoutManager((GSILayoutManager)new GSGridLayoutManager());
        int gridY = 0;
        GSTextLabel nameLabel = new GSTextLabel(NAME_TEXT);
        nameLabel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)gridY).set(GSGridLayoutManager.WEIGHT_X, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.WEST).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)2).set(GSGridLayoutManager.RIGHT_MARGIN, (Object)2);
        contentPanel.add((GSPanel)nameLabel);
        this.nameField.getLayout().set(GSGridLayoutManager.GRID_X, (Object)1).set(GSGridLayoutManager.GRID_Y, (Object)gridY++).set(GSGridLayoutManager.WEIGHT_X, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.FILL, (Object)GSEFill.HORIZONTAL).set(GSGridLayoutManager.LEFT_MARGIN, (Object)2).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)2);
        contentPanel.add((GSPanel)this.nameField);
        GSTextLabel colorLabel = new GSTextLabel(COLOR_TEXT);
        colorLabel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)gridY).set(GSGridLayoutManager.WEIGHT_X, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.WEST).set(GSGridLayoutManager.TOP_MARGIN, (Object)2).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)2).set(GSGridLayoutManager.RIGHT_MARGIN, (Object)2);
        contentPanel.add((GSPanel)colorLabel);
        this.colorPickerField.getLayout().set(GSGridLayoutManager.GRID_X, (Object)1).set(GSGridLayoutManager.GRID_Y, (Object)gridY++).set(GSGridLayoutManager.WEIGHT_X, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.FILL, (Object)GSEFill.HORIZONTAL).set(GSGridLayoutManager.TOP_MARGIN, (Object)2).set(GSGridLayoutManager.LEFT_MARGIN, (Object)2).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)2);
        contentPanel.add((GSPanel)this.colorPickerField);
        GSTextLabel positionsLabel = new GSTextLabel(POSITIONS_TEXT);
        positionsLabel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)gridY++).set(GSGridLayoutManager.GRID_WIDTH, (Object)2).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.WEST).set(GSGridLayoutManager.TOP_MARGIN, (Object)2).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)2);
        contentPanel.add((GSPanel)positionsLabel);
        Set<class_2338> positions = this.info.getPositions();
        GSTablePanel positionsTable = new GSTablePanel(1, positions.size());
        positionsTable.setColumnHeaderResizePolicy(GSEHeaderResizePolicy.RESIZE_ALL);
        positionsTable.setRowHeaderResizePolicy(GSEHeaderResizePolicy.RESIZE_OFF);
        GSITableModel positionsModel = positionsTable.getModel();
        int positionIndex = 0;
        for (class_2338 pos : positions) {
            String label = String.format("%d, %d, %d", pos.method_10263(), pos.method_10264(), pos.method_10260());
            positionsModel.setCellValue(0, positionIndex++, (Object)label);
        }
        GSScrollPanel positionScrollPanel = new GSScrollPanel((GSPanel)positionsTable);
        positionScrollPanel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)gridY++).set(GSGridLayoutManager.GRID_WIDTH, (Object)2).set(GSGridLayoutManager.WEIGHT_Y, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.FILL, (Object)GSEFill.BOTH).set(GSGridLayoutManager.TOP_MARGIN, (Object)2);
        contentPanel.add((GSPanel)positionScrollPanel);
    }

    @Override
    protected void apply() {
        this.info = this.info.withName(this.nameField.getText());
        this.info = this.info.withColor(this.colorPickerField.getColor());
        this.channel.setInfo(this.info);
    }
}

