/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.panel.sequence;

import com.g4mesoft.captureplayback.gui.GSCapturePlaybackPanel;
import com.g4mesoft.captureplayback.module.client.GSCapturePlaybackClientModule;
import com.g4mesoft.captureplayback.panel.GSIModelViewListener;
import com.g4mesoft.captureplayback.panel.sequence.GSChannelEditorPanel;
import com.g4mesoft.captureplayback.panel.sequence.GSSequenceModelView;
import com.g4mesoft.captureplayback.panel.sequence.GSSequencePanel;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSChannelInfo;
import com.g4mesoft.captureplayback.sequence.GSISequenceListener;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.ui.panel.GSDimension;
import com.g4mesoft.ui.panel.GSECursorType;
import com.g4mesoft.ui.panel.GSETextAlignment;
import com.g4mesoft.ui.panel.GSIcon;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSParentPanel;
import com.g4mesoft.ui.panel.GSTexturedIcon;
import com.g4mesoft.ui.panel.button.GSButton;
import com.g4mesoft.ui.panel.event.GSFocusEvent;
import com.g4mesoft.ui.panel.event.GSIFocusEventListener;
import com.g4mesoft.ui.panel.event.GSIKeyListener;
import com.g4mesoft.ui.panel.event.GSILayoutEventListener;
import com.g4mesoft.ui.panel.event.GSIMouseListener;
import com.g4mesoft.ui.panel.event.GSKeyEvent;
import com.g4mesoft.ui.panel.event.GSLayoutEvent;
import com.g4mesoft.ui.panel.event.GSMouseEvent;
import com.g4mesoft.ui.panel.field.GSTextField;
import com.g4mesoft.ui.panel.scroll.GSIScrollable;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import java.util.HashMap;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.class_2338;
import net.minecraft.class_3414;

public class GSChannelHeaderPanel
extends GSParentPanel
implements GSIScrollable,
GSISequenceListener,
GSIModelViewListener,
GSIMouseListener {
    private static final GSIcon EDIT_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(0, 0, 9, 9));
    private static final GSIcon HOVERED_EDIT_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(0, 9, 9, 9));
    private static final GSIcon DISABLED_EDIT_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(0, 18, 9, 9));
    private static final GSIcon DELETE_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(9, 0, 9, 9));
    private static final GSIcon HOVERED_DELETE_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(9, 9, 9, 9));
    private static final GSIcon DISABLED_DELETE_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(9, 18, 9, 9));
    private static final GSIcon MOVE_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(18, 0, 9, 9));
    private static final GSIcon HOVERED_MOVE_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(18, 9, 9, 9));
    private static final GSIcon DISABLED_MOVE_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(18, 18, 9, 9));
    private static final int BUTTON_MARGIN = 1;
    private static final int NAME_FIELD_HORIZONTAL_MARGIN = 4;
    public static final int CHANNEL_HEADER_COLOR = -15263977;
    public static final int CHANNEL_HOVER_COLOR = 0x30FFFFFF;
    public static final int CHANNEL_SPACING_COLOR = -14671840;
    private static final int CROSSHAIR_TARGET_BORDER_COLOR = -2039584;
    private static final int CHANNEL_HEADER_PREFERRED_WIDTH = 130;
    private final GSSequence sequence;
    private final GSSequenceModelView modelView;
    private final GSSequencePanel sequencePanel;
    private final Map<UUID, GSChannelLabelPanel> uuidToLabel;
    private UUID hoveredChannelUUID;
    private boolean editable;
    private int dragMouseOffsetY;
    private boolean dragging;

    public GSChannelHeaderPanel(GSSequence sequence, GSSequenceModelView modelView, GSSequencePanel sequencePanel) {
        this.sequence = sequence;
        this.modelView = modelView;
        this.sequencePanel = sequencePanel;
        this.uuidToLabel = new HashMap<UUID, GSChannelLabelPanel>();
        this.hoveredChannelUUID = null;
        this.editable = true;
        this.dragMouseOffsetY = 0;
        this.dragging = false;
        this.addMouseEventListener(this);
    }

    protected void layout() {
        this.layoutChannelLabels();
    }

    protected void onShown() {
        super.onShown();
        this.sequence.addSequenceListener(this);
        this.modelView.addModelViewListener(this);
        this.invalidate();
    }

    protected void onHidden() {
        super.onHidden();
        this.sequence.removeSequenceListener(this);
        this.modelView.removeModelViewListener(this);
        this.removeAllChannelLabels();
    }

    private void layoutChannelLabels() {
        for (GSChannel channel : this.sequence.getChannels()) {
            UUID channelUUID = channel.getChannelUUID();
            if (channelUUID.equals(this.sequencePanel.getDraggedChannelUUID())) continue;
            this.layoutChannelLabel(channelUUID);
        }
    }

    private void layoutChannelLabel(UUID channelUUID) {
        GSChannelLabelPanel labelPanel;
        if (!this.uuidToLabel.containsKey(channelUUID)) {
            this.addChannelLabel(channelUUID);
        }
        if ((labelPanel = this.uuidToLabel.get(channelUUID)) != null) {
            int cy = this.modelView.getChannelY(channelUUID);
            int ch = this.modelView.getChannelHeight();
            labelPanel.setBounds(0, cy, this.width, ch);
        }
    }

    private void addChannelLabel(UUID channelUUID) {
        GSChannel channel = this.sequence.getChannel(channelUUID);
        if (channel != null) {
            GSChannelLabelPanel labelPanel = new GSChannelLabelPanel(channel);
            this.uuidToLabel.put(channelUUID, labelPanel);
            this.add((GSPanel)labelPanel);
        }
    }

    private void removeAllChannelLabels() {
        for (GSChannelLabelPanel labelPanel : this.uuidToLabel.values()) {
            this.remove((GSPanel)labelPanel);
        }
        this.uuidToLabel.clear();
    }

    private void removeChannelLabel(UUID channelUUID) {
        GSChannelLabelPanel labelPanel = this.uuidToLabel.remove(channelUUID);
        if (labelPanel != null) {
            this.remove((GSPanel)labelPanel);
        }
    }

    public void render(GSIRenderer2D renderer) {
        renderer.fillRect(0, 0, this.width, this.height, -15263977);
        renderer.drawVLine(this.width - 1, 0, this.height, -14671840);
        this.renderChannelSpacing(renderer);
        super.render(renderer);
    }

    protected void renderChannelSpacing(GSIRenderer2D renderer) {
        int cs = this.modelView.getChannelSpacing();
        int ch = this.modelView.getChannelHeight();
        for (UUID channelUUID : this.uuidToLabel.keySet()) {
            int cy = this.modelView.getChannelY(channelUUID);
            renderer.fillRect(0, cy + ch, this.width, cs, -14671840);
        }
    }

    protected GSDimension calculatePreferredSize() {
        return new GSDimension(130, this.modelView.getMinimumHeight());
    }

    private void startDragging(UUID channelUUID, int draggedChannelY, int dragMouseOffsetY) {
        this.dragMouseOffsetY = dragMouseOffsetY;
        this.sequencePanel.setDraggedChannelUUID(channelUUID);
        this.sequencePanel.setDraggedChannelY(draggedChannelY);
        this.dragging = true;
    }

    private void stopDragging() {
        UUID draggedChannelUUID = this.sequencePanel.getDraggedChannelUUID();
        this.sequencePanel.setDraggedChannelUUID(null);
        this.dragging = false;
        this.layoutChannelLabel(draggedChannelUUID);
    }

    private void onChannelDragged(int mouseY) {
        int draggedChannelY = mouseY - this.dragMouseOffsetY;
        this.sequencePanel.setDraggedChannelY(draggedChannelY);
        UUID hoveredChannelUUID = this.modelView.getChannelUUIDFromView(mouseY);
        UUID draggedChannelUUID = this.sequencePanel.getDraggedChannelUUID();
        GSChannelLabelPanel labelPanel = this.uuidToLabel.get(draggedChannelUUID);
        if (labelPanel != null) {
            labelPanel.setBounds(labelPanel.x, draggedChannelY, labelPanel.width, labelPanel.height);
            if (draggedChannelUUID != null && !draggedChannelUUID.equals(hoveredChannelUUID)) {
                boolean moveBefore;
                boolean bl = moveBefore = this.modelView.getChannelY(draggedChannelUUID) >= draggedChannelY;
                if (hoveredChannelUUID == null) {
                    boolean bl2 = moveBefore = !moveBefore;
                }
                if (moveBefore) {
                    this.sequence.moveChannelBefore(draggedChannelUUID, hoveredChannelUUID);
                } else {
                    this.sequence.moveChannelAfter(draggedChannelUUID, hoveredChannelUUID);
                }
            }
        }
    }

    public void setHoveredChannelUUID(UUID hoveredChannelUUID) {
        if (!Objects.equals(this.hoveredChannelUUID, hoveredChannelUUID)) {
            GSChannelLabelPanel labelPanel = this.uuidToLabel.get(this.hoveredChannelUUID);
            if (labelPanel != null) {
                labelPanel.onHoveredChanged(false);
            }
            this.hoveredChannelUUID = hoveredChannelUUID;
            labelPanel = this.uuidToLabel.get(hoveredChannelUUID);
            if (labelPanel != null) {
                labelPanel.onHoveredChanged(true);
            }
        }
    }

    public void setEditable(boolean editable) {
        this.editable = editable;
        for (GSChannelLabelPanel labelPanel : this.uuidToLabel.values()) {
            labelPanel.onEditableChanged();
        }
    }

    public boolean isScrollableHeightFilled() {
        return true;
    }

    @Override
    public void channelRemoved(GSChannel channel, UUID oldPrevUUID) {
        this.removeChannelLabel(channel.getChannelUUID());
        this.layoutChannelLabels();
    }

    @Override
    public void channelInfoChanged(GSChannel channel, GSChannelInfo oldInfo) {
        GSChannelLabelPanel labelPanel = this.uuidToLabel.get(channel.getChannelUUID());
        if (labelPanel != null) {
            labelPanel.onChannelInfoChanged();
        }
    }

    @Override
    public void modelViewChanged() {
        this.layoutChannelLabels();
        this.invalidate();
    }

    public void mouseDragged(GSMouseEvent event) {
        if (this.dragging && event.getButton() == 0) {
            this.onChannelDragged(event.getY());
            event.consume();
        }
    }

    private class GSChannelLabelPanel
    extends GSParentPanel
    implements GSIMouseListener,
    GSIKeyListener {
        private final GSChannel channel;
        private final GSTextField nameField;
        private final GSButton deleteButton;
        private final GSButton editButton;
        private final GSButton moveButton;
        private boolean buttonsHidden;

        public GSChannelLabelPanel(final GSChannel channel) {
            this.channel = channel;
            this.nameField = new GSTextField();
            this.nameField.setBackgroundColor(0);
            this.nameField.setTextAlignment(GSETextAlignment.LEFT);
            this.nameField.setBorderWidth(0);
            this.nameField.setVerticalMargin(0);
            this.nameField.setHorizontalMargin(4);
            this.nameField.addFocusEventListener(new GSIFocusEventListener(){

                public void focusLost(GSFocusEvent event) {
                    if (GSChannelLabelPanel.this.nameField.isVisible() && !GSChannelLabelPanel.this.nameField.hasPopupVisible()) {
                        GSChannelLabelPanel.this.updateChannelName();
                    }
                }
            });
            this.deleteButton = new GSButton(DELETE_ICON);
            this.deleteButton.setHoveredIcon(HOVERED_DELETE_ICON);
            this.deleteButton.setDisabledIcon(DISABLED_DELETE_ICON);
            this.deleteButton.setCursor(GSECursorType.HAND);
            this.deleteButton.setBackgroundColor(0);
            this.deleteButton.setHoveredBackgroundColor(0);
            this.deleteButton.setDisabledBackgroundColor(0);
            this.deleteButton.setBorderWidth(0);
            this.deleteButton.addActionListener(() -> {
                GSChannelHeaderPanel.this.sequence.removeChannel(this.channel.getChannelUUID());
                GSChannelHeaderPanel.this.requestFocus();
            });
            this.editButton = new GSButton(EDIT_ICON);
            this.editButton.setHoveredIcon(HOVERED_EDIT_ICON);
            this.editButton.setDisabledIcon(DISABLED_EDIT_ICON);
            this.editButton.setCursor(GSECursorType.HAND);
            this.editButton.setBackgroundColor(0);
            this.editButton.setHoveredBackgroundColor(0);
            this.editButton.setDisabledBackgroundColor(0);
            this.editButton.setBorderWidth(0);
            this.editButton.addActionListener(this::openEditor);
            this.moveButton = new GSButton(MOVE_ICON);
            this.moveButton.setHoveredIcon(HOVERED_MOVE_ICON);
            this.moveButton.setDisabledIcon(DISABLED_MOVE_ICON);
            this.moveButton.setCursor(GSECursorType.VRESIZE);
            this.moveButton.setBackgroundColor(0);
            this.moveButton.setHoveredBackgroundColor(0);
            this.moveButton.setDisabledBackgroundColor(0);
            this.moveButton.setBorderWidth(0);
            this.moveButton.setClickSound((class_3414)null);
            this.moveButton.addMouseEventListener(new GSIMouseListener(){

                public void mousePressed(GSMouseEvent event) {
                    if (event.getButton() == 0) {
                        int draggedChannelY = GSChannelLabelPanel.this.getY();
                        int dragMouseOffsetY = GSChannelLabelPanel.this.moveButton.getY() + event.getY();
                        GSChannelHeaderPanel.this.startDragging(channel.getChannelUUID(), draggedChannelY, dragMouseOffsetY);
                        event.consume();
                    }
                }

                public void mouseReleased(GSMouseEvent event) {
                    GSChannelHeaderPanel.this.stopDragging();
                    event.consume();
                }
            });
            this.moveButton.addFocusEventListener(new GSIFocusEventListener(){

                public void focusLost(GSFocusEvent event) {
                    GSChannelHeaderPanel.this.stopDragging();
                    event.consume();
                }
            });
            this.buttonsHidden = true;
            this.addMouseEventListener(this);
            this.addKeyEventListener(this);
            this.add((GSPanel)this.nameField);
            this.onChannelInfoChanged();
            this.onEditableChanged();
        }

        private void openEditor() {
            GSChannelEditorPanel editor = new GSChannelEditorPanel(this.channel);
            editor.show(null);
            editor.addLayoutEventListener(new GSILayoutEventListener(){

                public void panelHidden(GSLayoutEvent event) {
                    GSChannelHeaderPanel.this.requestFocus();
                }
            });
        }

        private void onChannelInfoChanged() {
            GSChannelInfo info = this.channel.getInfo();
            this.nameField.setEditableTextColor(info.getColor());
            this.nameField.setUneditableTextColor(info.getColor());
            this.nameField.setText(info.getName());
        }

        protected void layout() {
            int bs = Math.max(1, this.height - 2);
            int nw = this.width;
            if (!this.buttonsHidden) {
                nw -= 3 * (bs + 2);
            }
            int x = 0;
            this.nameField.setBounds(x, 0, Math.max(0, nw), this.height);
            x += nw;
            if (!this.buttonsHidden) {
                this.deleteButton.setBounds(++x, 1, bs, bs);
                this.editButton.setBounds(x += bs + 2, 1, bs, bs);
                this.moveButton.setBounds(x += bs + 2, 1, bs, bs);
            }
        }

        public void render(GSIRenderer2D renderer) {
            if (this.channel.getChannelUUID().equals(GSChannelHeaderPanel.this.hoveredChannelUUID)) {
                renderer.fillRect(0, 0, this.width, this.height, 0x30FFFFFF);
            }
            super.render(renderer);
            class_2338 target = GSCapturePlaybackClientModule.getCrosshairTarget();
            if (target != null && this.channel.getInfo().getPositions().contains(target)) {
                renderer.drawRect(0, 0, this.width, this.height, -2039584);
            }
        }

        public void setPassingEvents(boolean passingEvents) {
            super.setPassingEvents(passingEvents);
            for (GSPanel child : this.getChildren()) {
                child.setPassingEvents(passingEvents);
            }
        }

        public void keyPressed(GSKeyEvent event) {
            if (GSChannelHeaderPanel.this.editable && this.nameField.isFocused()) {
                switch (event.getKeyCode()) {
                    case 256: {
                        this.onChannelInfoChanged();
                        this.requestFocus();
                        event.consume();
                        break;
                    }
                    case 257: {
                        if (this.nameField.getTextModel().getLength() == 0) {
                            this.onChannelInfoChanged();
                        } else {
                            this.updateChannelName();
                        }
                        this.requestFocus();
                        event.consume();
                        break;
                    }
                    case 258: {
                        if (!this.editNextChannel(true, event.isModifierHeld(1))) break;
                        event.consume();
                        break;
                    }
                    case 264: {
                        if (!this.editNextChannel(false, false)) break;
                        event.consume();
                        break;
                    }
                    case 265: {
                        if (!this.editNextChannel(false, true)) break;
                        event.consume();
                    }
                }
            }
        }

        private void updateChannelName() {
            this.channel.setInfo(this.channel.getInfo().withName(this.nameField.getText()));
        }

        private boolean editNextChannel(boolean selectAll, boolean descending) {
            UUID channelUUID = GSChannelHeaderPanel.this.modelView.getNextChannelUUID(this.channel.getChannelUUID(), descending);
            GSChannelLabelPanel labelPanel = GSChannelHeaderPanel.this.uuidToLabel.get(channelUUID);
            if (labelPanel != null) {
                labelPanel.nameField.requestFocus();
                if (selectAll) {
                    labelPanel.nameField.selectAll();
                }
                return true;
            }
            this.requestFocus();
            return false;
        }

        public void showButtons() {
            if (this.buttonsHidden) {
                this.buttonsHidden = false;
                this.add((GSPanel)this.deleteButton);
                this.add((GSPanel)this.editButton);
                this.add((GSPanel)this.moveButton);
            }
        }

        public void hideButtons() {
            if (!this.buttonsHidden) {
                if (this.deleteButton.isFocused() || this.editButton.isFocused() || this.moveButton.isFocused()) {
                    this.requestFocus();
                }
                this.buttonsHidden = true;
                this.remove((GSPanel)this.deleteButton);
                this.remove((GSPanel)this.editButton);
                this.remove((GSPanel)this.moveButton);
            }
        }

        public void onEditableChanged() {
            this.nameField.setEditable(GSChannelHeaderPanel.this.editable);
            if (!GSChannelHeaderPanel.this.editable) {
                this.hideButtons();
            }
        }

        public void onHoveredChanged(boolean hovered) {
            if (GSChannelHeaderPanel.this.editable && hovered) {
                this.showButtons();
            } else {
                this.hideButtons();
            }
        }
    }
}

