/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.panel.sequence;

import com.g4mesoft.captureplayback.panel.GSIModelViewListener;
import com.g4mesoft.captureplayback.panel.sequence.GSExpandedColumnModel;
import com.g4mesoft.captureplayback.panel.sequence.GSSequenceModelView;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.ui.panel.GSDimension;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSRectangle;
import com.g4mesoft.ui.panel.dropdown.GSDropdown;
import com.g4mesoft.ui.panel.dropdown.GSDropdownAction;
import com.g4mesoft.ui.panel.dropdown.GSDropdownItem;
import com.g4mesoft.ui.panel.event.GSIMouseListener;
import com.g4mesoft.ui.panel.event.GSMouseEvent;
import com.g4mesoft.ui.panel.scroll.GSIScrollable;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import com.g4mesoft.ui.util.GSTextUtil;
import net.minecraft.class_2561;

public class GSSequenceColumnHeaderPanel
extends GSPanel
implements GSIScrollable,
GSIModelViewListener,
GSIMouseListener {
    public static final int COLUMN_HEADER_COLOR = -14671840;
    public static final int HEADER_TEXT_COLOR = -2039584;
    public static final int DARK_HEADER_TEXT_COLOR = -6250336;
    public static final int COLUMN_LINE_COLOR = -14671840;
    public static final int DOTTED_LINE_COLOR = -12566464;
    public static final int DOTTED_LINE_LENGTH = 4;
    public static final int DOTTED_LINE_SPACING = 3;
    private static final int COLUMN_TITLE_LEFT_MARGIN = 2;
    private static final int SHADOW_WIDTH = 10;
    private static final int SHADOW_START_COLOR = -14671840;
    private static final int SHADOW_END_COLOR = 0x202020;
    private static final class_2561 EXPAND_TEXT = GSTextUtil.translatable((String)"panel.sequencecolumnheader.expand");
    private static final class_2561 COLLAPSE_TEXT = GSTextUtil.translatable((String)"panel.sequencecolumnheader.collapse");
    private static final class_2561 EXPAND_ALL_TEXT = GSTextUtil.translatable((String)"panel.sequencecolumnheader.expandall");
    private static final class_2561 COLLAPSE_ALL_TEXT = GSTextUtil.translatable((String)"panel.sequencecolumnheader.collapseall");
    private static final int COLUMN_HEADER_PREFERRED_HEIGHT = 30;
    private final GSExpandedColumnModel expandedColumnModel;
    private final GSSequenceModelView modelView;
    private int hoveredColumnIndex;

    public GSSequenceColumnHeaderPanel(GSSequence sequence, GSSequenceModelView modelView) {
        this.expandedColumnModel = modelView.getExpandedColumnModel();
        this.modelView = modelView;
        this.addMouseEventListener(this);
    }

    protected void onShown() {
        super.onShown();
        this.modelView.addModelViewListener(this);
    }

    protected void onHidden() {
        super.onHidden();
        this.modelView.removeModelViewListener(this);
    }

    public void render(GSIRenderer2D renderer) {
        super.render(renderer);
        GSRectangle bounds = renderer.getClipBounds().intersection(0, 0, this.width, this.height);
        this.renderBackground(renderer, bounds);
        this.renderColumnHeaders(renderer, bounds);
        renderer.drawHLine(bounds.x, bounds.x + bounds.width, this.height - 1, -14671840);
        renderer.fillHGradient(bounds.x + bounds.width - 10, 0, 10, this.height, 0x202020, -14671840);
    }

    private void renderBackground(GSIRenderer2D renderer, GSRectangle bounds) {
        renderer.fillRect(bounds.x, bounds.y, bounds.width, bounds.height, -14671840);
    }

    private void renderColumnHeaders(GSIRenderer2D renderer, GSRectangle bounds) {
        int columnIndex = Math.max(0, this.modelView.getColumnIndexFromX(bounds.x));
        int cx = this.modelView.getColumnX(columnIndex);
        while (cx < bounds.x + bounds.width) {
            int cw = this.modelView.getColumnWidth(columnIndex);
            this.renderColumnHeader(renderer, columnIndex, cx, cw);
            cx += cw;
            ++columnIndex;
        }
    }

    private void renderColumnHeader(GSIRenderer2D renderer, int columnIndex, int cx, int cw) {
        boolean expanded = this.expandedColumnModel.isColumnExpanded(columnIndex);
        int color = -2039584;
        if (!expanded && this.expandedColumnModel.hasExpandedColumn()) {
            color = -6250336;
        }
        String title = Long.toString(this.modelView.getColumnGametick(columnIndex));
        int ty = (this.height / 2 - renderer.getTextHeight() + 1) / 2;
        renderer.drawTextNoStyle((CharSequence)title, cx + 2, ty, color, false);
        if (columnIndex == this.hoveredColumnIndex) {
            renderer.drawVLine(cx - 1, 0, this.height, -14671840);
            renderer.drawVLine(cx + cw - 1, 0, this.height, -14671840);
        }
        if (expanded) {
            this.renderMicrotickLabels(renderer, columnIndex);
        }
    }

    private void renderMicrotickLabels(GSIRenderer2D renderer, int expandedColumnIndex) {
        int duration = this.modelView.getColumnDuration(expandedColumnIndex);
        int y = this.height * 3 / 4 - renderer.getTextHeight() / 2;
        for (int mt = 0; mt < duration; ++mt) {
            int x = this.modelView.getMicrotickColumnX(expandedColumnIndex, mt);
            int w = this.modelView.getMicrotickColumnWidth(expandedColumnIndex, mt);
            renderer.drawCenteredText(Integer.toString(mt), x + w / 2, y, -2039584);
            if (mt == 0) continue;
            int ly = this.height / 2 + 1;
            renderer.drawDottedVLine(x - 1, ly, this.height, 4, 3, -12566464);
        }
        int ex = this.modelView.getColumnX(expandedColumnIndex);
        int ew = this.modelView.getColumnWidth(expandedColumnIndex);
        renderer.fillRect(ex, this.height / 2 - 1, ew, 1, -12566464);
    }

    protected GSDimension calculatePreferredSize() {
        return new GSDimension(this.modelView.getMinimumWidth(), 30);
    }

    public void populateRightClickMenu(GSDropdown dropdown, int x, int y) {
        int hoveredColumn = this.modelView.getColumnIndexFromX(x);
        if (hoveredColumn != -1) {
            dropdown.addItem((GSDropdownItem)new GSDropdownAction(EXPAND_TEXT, () -> this.expandedColumnModel.setExpandedColumn(hoveredColumn)));
            GSDropdownAction collapseAction = new GSDropdownAction(COLLAPSE_TEXT, () -> this.expandedColumnModel.toggleExpandedColumn(hoveredColumn));
            dropdown.addItem((GSDropdownItem)collapseAction);
            dropdown.separate();
            dropdown.addItem((GSDropdownItem)new GSDropdownAction(EXPAND_ALL_TEXT, () -> this.expandedColumnModel.setExpandedColumnRange(0, Integer.MAX_VALUE)));
            dropdown.addItem((GSDropdownItem)new GSDropdownAction(COLLAPSE_ALL_TEXT, () -> this.expandedColumnModel.clearExpandedColumns()));
            collapseAction.setEnabled(this.expandedColumnModel.isColumnExpanded(hoveredColumn));
        }
    }

    public boolean isScrollableWidthFilled() {
        return true;
    }

    @Override
    public void modelViewChanged() {
        this.invalidate();
    }

    public void mousePressed(GSMouseEvent event) {
        int hoveredColumn;
        if (event.getButton() == 0 && (hoveredColumn = this.modelView.getColumnIndexFromX(event.getX())) != -1) {
            if (event.isModifierHeld(1)) {
                this.expandedColumnModel.includeExpandedColumn(hoveredColumn);
            } else {
                this.expandedColumnModel.toggleExpandedColumn(hoveredColumn);
            }
            event.consume();
        }
    }

    public void setHoveredColumn(int columnIndex) {
        this.hoveredColumnIndex = columnIndex;
    }
}

