/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.sequence;

import com.g4mesoft.captureplayback.common.GSSignalTime;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSEChannelEntryType;
import com.g4mesoft.captureplayback.sequence.GSISequenceListener;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public final class GSChannelEntry {
    public static final GSEChannelEntryType DEFAULT_ENTRY_TYPE = GSEChannelEntryType.EVENT_BOTH;
    private final UUID entryUUID;
    private GSSignalTime startTime;
    private GSSignalTime endTime;
    private GSEChannelEntryType type;
    private GSChannel parent;

    GSChannelEntry(GSChannelEntry other) {
        this(other.getEntryUUID(), other.getStartTime(), other.getEndTime());
        this.type = other.getType();
    }

    GSChannelEntry(UUID entryUUID, GSSignalTime startTime, GSSignalTime endTime) {
        if (entryUUID == null) {
            throw new NullPointerException("entryUUID is null");
        }
        this.entryUUID = entryUUID;
        this.startTime = startTime;
        this.endTime = endTime;
        this.type = DEFAULT_ENTRY_TYPE;
        this.parent = null;
        this.validateTimespan(startTime, endTime);
    }

    public GSChannel getParent() {
        return this.parent;
    }

    void onAdded(GSChannel parent) {
        if (this.parent != null) {
            throw new IllegalStateException("Entry already has a parent");
        }
        this.parent = parent;
    }

    void onRemoved(GSChannel parent) {
        if (this.parent != parent) {
            throw new IllegalStateException("Entry does not have specified parent");
        }
        this.parent = null;
    }

    void set(GSChannelEntry other) {
        this.setTimespan(other.getStartTime(), other.getEndTime());
        this.setType(other.getType());
    }

    private void validateTimespan(GSSignalTime startTime, GSSignalTime endTime) {
        if (startTime.isAfter(endTime)) {
            throw new IllegalArgumentException("Start time is after end time!");
        }
        if (this.parent != null && this.parent.isOverlappingEntries(startTime, endTime, this)) {
            throw new IllegalArgumentException("Timespan is overlapping other channel entries!");
        }
    }

    public void setTimespan(GSSignalTime startTime, GSSignalTime endTime) {
        GSSignalTime oldStartTime = this.startTime;
        GSSignalTime oldEndTime = this.endTime;
        if (!oldStartTime.isEqual(startTime) || !oldEndTime.isEqual(endTime)) {
            this.validateTimespan(startTime, endTime);
            this.startTime = startTime;
            this.endTime = endTime;
            this.dispatchEntryTimeChanged(this, oldStartTime, oldEndTime);
        }
    }

    public long getGametickDuration() {
        return this.endTime.getGametick() - this.startTime.getGametick();
    }

    public void setStartTime(GSSignalTime startTime) {
        if (startTime.isAfter(this.endTime)) {
            throw new IllegalArgumentException("Start time is after current end time!");
        }
        this.setTimespan(startTime, this.endTime);
    }

    public GSSignalTime getStartTime() {
        return this.startTime;
    }

    public void setEndTime(GSSignalTime endTime) {
        if (endTime.isBefore(this.startTime)) {
            throw new IllegalArgumentException("End time is before current start time!");
        }
        this.setTimespan(this.startTime, endTime);
    }

    public boolean isOverlapping(GSSignalTime startTime, GSSignalTime endTime) {
        return !startTime.isAfter(this.endTime) && !endTime.isBefore(this.startTime);
    }

    public boolean containsTimestamp(GSSignalTime time, boolean includeBlockEventDelay) {
        if (includeBlockEventDelay) {
            return !this.startTime.isAfter(time) && !this.endTime.isBefore(time);
        }
        return time.getGametick() >= this.startTime.getGametick() && time.getGametick() <= this.endTime.getGametick();
    }

    public GSSignalTime getEndTime() {
        return this.endTime;
    }

    public void setType(GSEChannelEntryType type) {
        if (type == null) {
            throw new NullPointerException();
        }
        GSEChannelEntryType oldType = this.type;
        if (type != oldType) {
            this.type = type;
            this.dispatchEntryTypeChanged(this, oldType);
        }
    }

    public GSEChannelEntryType getType() {
        return this.type;
    }

    public UUID getEntryUUID() {
        return this.entryUUID;
    }

    private void dispatchEntryTimeChanged(GSChannelEntry entry, GSSignalTime oldStart, GSSignalTime oldEnd) {
        if (this.parent != null && this.parent.getParent() != null) {
            for (GSISequenceListener listener : this.parent.getParent().getListeners()) {
                listener.entryTimeChanged(entry, oldStart, oldEnd);
            }
        }
    }

    private void dispatchEntryTypeChanged(GSChannelEntry entry, GSEChannelEntryType oldType) {
        if (this.parent != null && this.parent.getParent() != null) {
            for (GSISequenceListener listener : this.parent.getParent().getListeners()) {
                listener.entryTypeChanged(entry, oldType);
            }
        }
    }

    public static GSChannelEntry read(GSDecodeBuffer buf) throws IOException {
        GSSignalTime endTime;
        UUID entryUUID = buf.readUUID();
        GSSignalTime startTime = GSSignalTime.read(buf);
        if (startTime.isAfter(endTime = GSSignalTime.read(buf))) {
            throw new IOException("Invalid entry time-span");
        }
        GSChannelEntry entry = new GSChannelEntry(entryUUID, startTime, endTime);
        GSEChannelEntryType type = GSEChannelEntryType.fromIndex(buf.readInt());
        if (type == null) {
            throw new IOException("Invalid entry type");
        }
        entry.setType(type);
        return entry;
    }

    public static void write(GSEncodeBuffer buf, GSChannelEntry entry) throws IOException {
        buf.writeUUID(entry.getEntryUUID());
        GSSignalTime.write(buf, entry.getStartTime());
        GSSignalTime.write(buf, entry.getEndTime());
        buf.writeInt(entry.getType().getIndex());
    }
}

