/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.sequence.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.common.GSSignalTime;
import com.g4mesoft.captureplayback.sequence.GSChannelEntry;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelEntryDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public class GSChannelEntryTimeDelta
extends GSChannelEntryDelta {
    private GSSignalTime newStartTime;
    private GSSignalTime newEndTime;
    private GSSignalTime oldStartTime;
    private GSSignalTime oldEndTime;

    public GSChannelEntryTimeDelta() {
    }

    public GSChannelEntryTimeDelta(UUID channelUUID, UUID entryUUID, GSSignalTime newStartTime, GSSignalTime newEndTime, GSSignalTime oldStartTime, GSSignalTime oldEndTime) {
        super(channelUUID, entryUUID);
        this.newStartTime = newStartTime;
        this.newEndTime = newEndTime;
        this.oldStartTime = oldStartTime;
        this.oldEndTime = oldEndTime;
    }

    private void setEntryTime(GSSignalTime newStartTime, GSSignalTime newEndTime, GSSignalTime oldStartTime, GSSignalTime oldEndTime, GSSequence sequence) throws GSDeltaException {
        GSChannelEntry entry = this.getEntry(sequence);
        this.checkEntryTimespan(entry, oldStartTime, oldEndTime);
        try {
            entry.setTimespan(newStartTime, newEndTime);
        }
        catch (IllegalArgumentException e) {
            throw new GSDeltaException(e);
        }
    }

    @Override
    public void unapply(GSSequence sequence) throws GSDeltaException {
        this.setEntryTime(this.oldStartTime, this.oldEndTime, this.newStartTime, this.newEndTime, sequence);
    }

    @Override
    public void apply(GSSequence sequence) throws GSDeltaException {
        this.setEntryTime(this.newStartTime, this.newEndTime, this.oldStartTime, this.oldEndTime, sequence);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.newStartTime = GSSignalTime.read(buf);
        this.newEndTime = GSSignalTime.read(buf);
        this.oldStartTime = GSSignalTime.read(buf);
        this.oldEndTime = GSSignalTime.read(buf);
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        GSSignalTime.write(buf, this.newStartTime);
        GSSignalTime.write(buf, this.newEndTime);
        GSSignalTime.write(buf, this.oldStartTime);
        GSSignalTime.write(buf, this.oldEndTime);
    }
}

