/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.sequence.delta;

import com.g4mesoft.captureplayback.common.GSDeltaTransformer;
import com.g4mesoft.captureplayback.common.GSSignalTime;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSChannelEntry;
import com.g4mesoft.captureplayback.sequence.GSChannelInfo;
import com.g4mesoft.captureplayback.sequence.GSEChannelEntryType;
import com.g4mesoft.captureplayback.sequence.GSISequenceListener;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelAddedDelta;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelDisabledDelta;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelEntryAddedDelta;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelEntryRemovedDelta;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelEntryTimeDelta;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelEntryTypeDelta;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelInfoDelta;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelMovedDelta;
import com.g4mesoft.captureplayback.sequence.delta.GSChannelRemovedDelta;
import com.g4mesoft.captureplayback.sequence.delta.GSSequenceNameDelta;
import java.util.UUID;

public class GSSequenceDeltaTransformer
extends GSDeltaTransformer<GSSequence>
implements GSISequenceListener {
    @Override
    public void install(GSSequence model) {
        super.install(model);
        model.addSequenceListener(this);
    }

    @Override
    public void uninstall(GSSequence model) {
        super.uninstall(model);
        model.removeSequenceListener(this);
    }

    @Override
    public void sequenceNameChanged(String oldName) {
        this.dispatchDeltaEvent(new GSSequenceNameDelta(((GSSequence)this.model).getName(), oldName));
    }

    @Override
    public void channelAdded(GSChannel channel, UUID prevUUID) {
        this.dispatchDeltaEvent(new GSChannelAddedDelta(channel, prevUUID));
    }

    @Override
    public void channelRemoved(GSChannel channel, UUID oldPrevUUID) {
        this.dispatchDeltaEvent(new GSChannelRemovedDelta(channel, oldPrevUUID));
    }

    @Override
    public void channelMoved(GSChannel channel, UUID newPrevUUID, UUID oldPrevUUID) {
        this.dispatchDeltaEvent(new GSChannelMovedDelta(channel.getChannelUUID(), newPrevUUID, oldPrevUUID));
    }

    @Override
    public void channelInfoChanged(GSChannel channel, GSChannelInfo oldInfo) {
        this.dispatchDeltaEvent(new GSChannelInfoDelta(channel.getChannelUUID(), channel.getInfo(), oldInfo));
    }

    @Override
    public void channelDisabledChanged(GSChannel channel, boolean oldDisabled) {
        this.dispatchDeltaEvent(new GSChannelDisabledDelta(channel.getChannelUUID(), channel.isDisabled(), oldDisabled));
    }

    @Override
    public void entryAdded(GSChannelEntry entry) {
        this.dispatchDeltaEvent(new GSChannelEntryAddedDelta(entry));
    }

    @Override
    public void entryRemoved(GSChannelEntry entry) {
        this.dispatchDeltaEvent(new GSChannelEntryRemovedDelta(entry));
    }

    @Override
    public void entryTimeChanged(GSChannelEntry entry, GSSignalTime oldStart, GSSignalTime oldEnd) {
        this.dispatchDeltaEvent(new GSChannelEntryTimeDelta(entry.getParent().getChannelUUID(), entry.getEntryUUID(), entry.getStartTime(), entry.getEndTime(), oldStart, oldEnd));
    }

    @Override
    public void entryTypeChanged(GSChannelEntry entry, GSEChannelEntryType oldType) {
        this.dispatchDeltaEvent(new GSChannelEntryTypeDelta(entry.getParent().getChannelUUID(), entry.getEntryUUID(), entry.getType(), oldType));
    }
}

