/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.session;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.common.GSDeltaTransformer;
import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.captureplayback.common.GSIDeltaListener;
import com.g4mesoft.captureplayback.session.GSSession;
import com.g4mesoft.captureplayback.session.GSSessionField;
import com.g4mesoft.captureplayback.session.GSSessionFieldType;

public abstract class GSAssetSessionField<T>
extends GSSessionField<T>
implements GSIDeltaListener<T> {
    protected GSSession session = null;
    protected final GSDeltaTransformer<T> transformer;

    public GSAssetSessionField(GSSessionFieldType<T> type, GSDeltaTransformer<T> transformer) {
        super(type);
        this.transformer = transformer;
        this.transformer.addDeltaListener(this);
    }

    @Override
    public void onAdded(GSSession session) {
        super.onAdded(session);
        this.session = session;
    }

    @Override
    public void set(T value) {
        if (this.value != null) {
            this.transformer.uninstall(this.value);
        }
        super.set(value);
        if (value != null) {
            this.transformer.install(value);
        }
    }

    @Override
    public abstract void onDelta(GSIDelta<T> var1);

    public void applyDelta(GSIDelta<T> delta) throws GSDeltaException {
        if (this.value != null) {
            try {
                this.transformer.setEnabled(false);
                delta.apply(this.value);
            }
            finally {
                this.transformer.setEnabled(true);
            }
        }
    }
}

