/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.session;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.captureplayback.session.GSUndoRedoHistory;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;

public class GSMoveUndoRedoHistoryDelta
implements GSIDelta<GSUndoRedoHistory> {
    private boolean moveToRedo;
    private int count;

    public GSMoveUndoRedoHistoryDelta() {
    }

    public GSMoveUndoRedoHistoryDelta(boolean moveToRedo, int count) {
        this.moveToRedo = moveToRedo;
        this.count = count;
    }

    @Override
    public void apply(GSUndoRedoHistory history) throws GSDeltaException {
        if (history.moveEntries(this.moveToRedo, this.count) != this.count) {
            throw new GSDeltaException("Unable to move " + this.count + " entries");
        }
    }

    @Override
    public void unapply(GSUndoRedoHistory history) throws GSDeltaException {
        throw new GSDeltaException("Unapply unsupported");
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        this.moveToRedo = buf.readBoolean();
        this.count = buf.readInt();
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        buf.writeBoolean(this.moveToRedo);
        buf.writeInt(this.count);
    }
}

