/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.session;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.captureplayback.common.asset.GSAssetHandle;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.sequence.GSSequence;
import com.g4mesoft.captureplayback.session.GSBasicSessionFieldCodec;
import com.g4mesoft.captureplayback.session.GSCompositionSessionField;
import com.g4mesoft.captureplayback.session.GSDoubleSessionFieldCodec;
import com.g4mesoft.captureplayback.session.GSESessionType;
import com.g4mesoft.captureplayback.session.GSFieldSessionDelta;
import com.g4mesoft.captureplayback.session.GSFloatSessionFieldCodec;
import com.g4mesoft.captureplayback.session.GSISessionFieldCodec;
import com.g4mesoft.captureplayback.session.GSISessionListener;
import com.g4mesoft.captureplayback.session.GSIntegerSessionFieldCodec;
import com.g4mesoft.captureplayback.session.GSSequenceSessionField;
import com.g4mesoft.captureplayback.session.GSSessionField;
import com.g4mesoft.captureplayback.session.GSSessionFieldPair;
import com.g4mesoft.captureplayback.session.GSSessionFieldType;
import com.g4mesoft.captureplayback.session.GSSessionFieldTypeBuilder;
import com.g4mesoft.captureplayback.session.GSSessionFields;
import com.g4mesoft.captureplayback.session.GSSessionSide;
import com.g4mesoft.captureplayback.session.GSUndoRedoHistory;
import com.g4mesoft.captureplayback.session.GSUndoRedoHistorySessionField;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

public class GSSession {
    private static final GSISessionFieldCodec<Integer> INTEGER_CODEC = new GSIntegerSessionFieldCodec();
    private static final GSISessionFieldCodec<Float> FLOAT_CODEC = new GSFloatSessionFieldCodec();
    private static final GSISessionFieldCodec<Double> DOUBLE_CODEC = new GSDoubleSessionFieldCodec();
    private static final GSISessionFieldCodec<GSComposition> COMPOSITION_CODEC = new GSBasicSessionFieldCodec<GSComposition>(GSComposition::read, GSComposition::write);
    private static final GSISessionFieldCodec<GSSequence> SEQUENCE_CODEC = new GSBasicSessionFieldCodec<GSSequence>(GSSequence::read, GSSequence::write);
    private static final GSISessionFieldCodec<UUID> UUID_CODEC = new GSBasicSessionFieldCodec<UUID>(GSDecodeBuffer::readUUID, GSEncodeBuffer::writeUUID);
    private static final GSISessionFieldCodec<GSAssetHandle> ASSET_HANDLE_CODEC = new GSBasicSessionFieldCodec<GSAssetHandle>(GSAssetHandle::read, GSAssetHandle::write);
    private static final GSISessionFieldCodec<GSUndoRedoHistory> UNDO_REDO_HISTORY_CODEC = new GSBasicSessionFieldCodec<GSUndoRedoHistory>(GSUndoRedoHistory::read, GSUndoRedoHistory::write);
    public static final GSSessionFieldType<UUID> ASSET_UUID;
    public static final GSSessionFieldType<GSAssetHandle> ASSET_HANDLE;
    public static final GSSessionFieldType<Float> X_OFFSET;
    public static final GSSessionFieldType<Float> Y_OFFSET;
    public static final GSSessionFieldType<GSUndoRedoHistory> UNDO_REDO_HISTORY;
    public static final GSSessionFieldType<GSComposition> COMPOSITION;
    public static final GSSessionFieldType<Double> GAMETICK_WIDTH;
    public static final GSSessionFieldType<GSSequence> SEQUENCE;
    public static final GSSessionFieldType<UUID> SELECTED_CHANNEL;
    public static final GSSessionFieldType<Integer> MIN_EXPANDED_COLUMN;
    public static final GSSessionFieldType<Integer> MAX_EXPANDED_COLUMN;
    private static final Map<String, GSSessionFieldType<?>> nameToType;
    private static final Map<GSESessionType, Set<GSSessionFieldType<?>>> sessionFieldTypes;
    private final GSESessionType type;
    private GSSessionSide side;
    private final GSSessionFields fields;
    private List<GSISessionListener> listeners;
    private Set<GSSessionFieldType<?>> fieldsToSync;

    public GSSession(GSESessionType type) {
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        this.type = type;
        this.side = GSSessionSide.UNKNOWN;
        this.fields = new GSSessionFields(this);
        this.listeners = null;
        this.fieldsToSync = new HashSet();
        this.addFields();
    }

    private void addFields() {
        Set<GSSessionFieldType<?>> types = sessionFieldTypes.get((Object)this.type);
        if (types != null) {
            for (GSSessionFieldType<?> type : types) {
                this.fields.add(type);
            }
        }
    }

    public GSESessionType getType() {
        return this.type;
    }

    public GSSessionSide getSide() {
        return this.side;
    }

    public void setSide(GSSessionSide side) {
        if (side == null) {
            throw new IllegalArgumentException("side is null");
        }
        this.side = side;
    }

    public <T> boolean contains(GSSessionFieldType<T> type) {
        return this.fields.contains(type);
    }

    <T> void forceSet(GSSessionFieldPair<T> pair) {
        this.fields.forceSet(pair);
        this.onFieldChanged(pair.getType(), true);
    }

    <T> boolean set(GSSessionFieldPair<T> pair) {
        return this.set(pair.getType(), pair.getValue());
    }

    public <T> boolean set(GSSessionFieldType<T> type, T value) {
        if (this.fields.set(type, value)) {
            this.onFieldChanged(type, true);
            return true;
        }
        return false;
    }

    public <T> T get(GSSessionFieldType<T> type) {
        return this.fields.get(type);
    }

    GSSessionField<?> getField(GSSessionFieldType<?> type) {
        return this.fields.getField(type);
    }

    private void onFieldChanged(GSSessionFieldType<?> type, boolean shouldRequestSync) {
        if (shouldRequestSync) {
            this.requestSync(type);
        }
        this.dispatchFieldChanged(type);
    }

    public void requestSync(GSSessionFieldType<?> type) {
        if (type.isSynced()) {
            this.fieldsToSync.add(type);
        }
    }

    public void cancelSync(GSSessionFieldType<?> type) {
        this.fieldsToSync.remove(type);
    }

    public void sync() {
        if (!this.fieldsToSync.isEmpty()) {
            GSIDelta[] deltas = new GSIDelta[this.fieldsToSync.size()];
            int i = 0;
            for (GSSessionFieldType<?> type : this.fieldsToSync) {
                GSSessionFieldPair pair = new GSSessionFieldPair(type, this.get(type));
                deltas[i++] = new GSFieldSessionDelta(pair);
            }
            this.fieldsToSync.clear();
            this.dispatchSessionDeltas(deltas);
        }
    }

    public void addListener(GSISessionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null!");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<GSISessionListener>(2);
        }
        this.listeners.add(listener);
    }

    public void removeListener(GSISessionListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    private void dispatchFieldChanged(GSSessionFieldType<?> type) {
        if (this.listeners != null) {
            for (GSISessionListener listener : this.listeners) {
                listener.onFieldChanged(this, type);
            }
        }
    }

    void dispatchSessionDelta(GSIDelta<GSSession> delta) {
        GSIDelta[] deltas = new GSIDelta[]{delta};
        this.dispatchSessionDeltas(deltas);
    }

    private void dispatchSessionDeltas(GSIDelta<GSSession>[] deltas) {
        if (this.listeners != null) {
            for (GSISessionListener listener : this.listeners) {
                listener.onSessionDeltas(this, deltas);
            }
        }
    }

    public void applySessionDeltas(GSIDelta<GSSession>[] deltas) {
        for (GSIDelta<GSSession> delta : deltas) {
            try {
                delta.apply(this);
            }
            catch (GSDeltaException gSDeltaException) {
                // empty catch block
            }
        }
    }

    public static GSSessionFieldType<?> readFieldType(GSDecodeBuffer buf) throws IOException {
        GSSessionFieldType<?> type = nameToType.get(buf.readString());
        if (type == null) {
            throw new IOException("Unknown type");
        }
        return type;
    }

    public static void writeFieldType(GSEncodeBuffer buf, GSSessionFieldType<?> type) throws IOException {
        buf.writeString(type.getName());
    }

    public static <T> T readField(GSDecodeBuffer buf, GSSessionFieldType<T> type) throws IOException {
        return type.getCodec().decode(buf);
    }

    public static <T> void writeField(GSEncodeBuffer buf, GSSessionFieldType<T> type, T value) throws IOException {
        type.getCodec().encode(buf, value);
    }

    public static <T> GSSessionFieldPair<T> readFieldPair(GSDecodeBuffer buf) throws IOException {
        GSSessionFieldType<?> type = GSSession.readFieldType(buf);
        return new GSSessionFieldPair(type, GSSession.readField(buf, type));
    }

    public static <T> void writeFieldPair(GSEncodeBuffer buf, GSSessionFieldPair<T> pair) throws IOException {
        GSSession.writeFieldType(buf, pair.getType());
        GSSession.writeField(buf, pair.getType(), pair.getValue());
    }

    public static GSSession read(GSDecodeBuffer buf) throws IOException {
        GSESessionType sessionType = GSESessionType.fromIndex(buf.readInt());
        if (sessionType == null) {
            throw new IOException("Unknown session type");
        }
        GSSession session = new GSSession(sessionType);
        GSSessionFields fields = GSSessionFields.read(buf);
        for (GSSessionFieldPair<?> pair : fields) {
            session.forceSet(pair);
        }
        return session;
    }

    public static void writeCache(GSEncodeBuffer buf, GSSession session) throws IOException {
        GSSession.write(buf, session, true);
    }

    public static void writePacket(GSEncodeBuffer buf, GSSession session) throws IOException {
        GSSession.write(buf, session, false);
    }

    private static void write(GSEncodeBuffer buf, GSSession session, boolean cache) throws IOException {
        buf.writeInt(session.getType().getIndex());
        if (cache) {
            GSSessionFields.write(buf, session.fields, GSSessionFieldType::isCached);
        } else {
            GSSessionFields.write(buf, session.fields);
        }
    }

    static {
        nameToType = new HashMap();
        sessionFieldTypes = new EnumMap(GSESessionType.class);
        GSSessionFieldTypeBuilder builder = new GSSessionFieldTypeBuilder(nameToType, sessionFieldTypes);
        ASSET_UUID = builder.cast().name("assetUUID").nullable().assignOnce().codec(UUID_CODEC).noSync().session(GSESessionType.COMPOSITION).session(GSESessionType.SEQUENCE).build();
        ASSET_HANDLE = builder.cast().name("assetHandle").nullable().assignOnce().codec(ASSET_HANDLE_CODEC).noSync().session(GSESessionType.COMPOSITION).session(GSESessionType.SEQUENCE).build();
        X_OFFSET = builder.cast().name("xOffset").def(Float.valueOf(0.0f)).codec(FLOAT_CODEC).session(GSESessionType.COMPOSITION).session(GSESessionType.SEQUENCE).build();
        Y_OFFSET = builder.cast().name("yOffset").def(Float.valueOf(0.0f)).codec(FLOAT_CODEC).session(GSESessionType.COMPOSITION).session(GSESessionType.SEQUENCE).build();
        UNDO_REDO_HISTORY = builder.cast().name("undoRedoHistory").constr(GSUndoRedoHistorySessionField::new).def(GSUndoRedoHistory::new).assignOnce().codec(UNDO_REDO_HISTORY_CODEC).noSync().session(GSESessionType.COMPOSITION).session(GSESessionType.SEQUENCE).build();
        COMPOSITION = builder.cast().name("composition").constr(GSCompositionSessionField::new).nullable().assignOnce().codec(COMPOSITION_CODEC).noCache().noSync().session(GSESessionType.COMPOSITION).build();
        GAMETICK_WIDTH = builder.cast().name("gametickWidth").def(8.0).codec(DOUBLE_CODEC).session(GSESessionType.COMPOSITION).build();
        SEQUENCE = builder.cast().name("sequence").constr(GSSequenceSessionField::new).nullable().assignOnce().codec(SEQUENCE_CODEC).noCache().noSync().session(GSESessionType.SEQUENCE).build();
        SELECTED_CHANNEL = builder.cast().name("selectedChannel").nullable().codec(UUID_CODEC).session(GSESessionType.SEQUENCE).build();
        MIN_EXPANDED_COLUMN = builder.cast().name("minExpandedColumn").def(-1).codec(INTEGER_CODEC).session(GSESessionType.SEQUENCE).build();
        MAX_EXPANDED_COLUMN = builder.cast().name("maxExpandedColumn").def(-1).codec(INTEGER_CODEC).session(GSESessionType.SEQUENCE).build();
    }
}

