/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.session;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.captureplayback.common.GSIDeltaListener;
import com.g4mesoft.captureplayback.session.GSCompositionUndoRedoEntry;
import com.g4mesoft.captureplayback.session.GSIUndoRedoEntry;
import com.g4mesoft.captureplayback.session.GSIUndoRedoListener;
import com.g4mesoft.captureplayback.session.GSMoveUndoRedoHistoryDelta;
import com.g4mesoft.captureplayback.session.GSSequenceUndoRedoEntry;
import com.g4mesoft.captureplayback.session.GSSession;
import com.g4mesoft.captureplayback.session.GSTrackUndoRedoHistoryDelta;
import com.g4mesoft.registry.GSSupplierRegistry;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;

public class GSUndoRedoHistory {
    private static final int MAX_HISTORY_SIZE = 10000;
    private static final GSSupplierRegistry<Integer, GSIUndoRedoEntry> ENTRY_REGISTRY = new GSSupplierRegistry();
    private final Deque<GSIUndoRedoEntry> undoHistory;
    private final Deque<GSIUndoRedoEntry> redoHistory;
    private GSSession session;
    private boolean tracking;
    private boolean applyingDelta;
    private final List<GSIUndoRedoListener> historyListeners;
    private final List<GSIDeltaListener<GSUndoRedoHistory>> deltaListeners;

    public GSUndoRedoHistory() {
        this(new LinkedList<GSIUndoRedoEntry>(), new LinkedList<GSIUndoRedoEntry>());
    }

    private GSUndoRedoHistory(Deque<GSIUndoRedoEntry> undoHistory, Deque<GSIUndoRedoEntry> redoHistory) {
        this.undoHistory = undoHistory;
        this.redoHistory = redoHistory;
        this.session = null;
        this.tracking = true;
        this.applyingDelta = false;
        this.historyListeners = new ArrayList<GSIUndoRedoListener>(1);
        this.deltaListeners = new ArrayList<GSIDeltaListener<GSUndoRedoHistory>>(1);
    }

    void onAdded(GSSession session) {
        this.session = session;
    }

    void onRemoved(GSSession session) {
        this.session = null;
    }

    public void undo() {
        if (this.session != null) {
            this.applyHistory(this.undoHistory, this.redoHistory, true);
        }
    }

    public void redo() {
        if (this.session != null) {
            this.applyHistory(this.redoHistory, this.undoHistory, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void applyHistory(Deque<GSIUndoRedoEntry> srcHistory, Deque<GSIUndoRedoEntry> dstHistory, boolean undo) {
        if (!srcHistory.isEmpty()) {
            GSIUndoRedoEntry entry;
            int count = 0;
            do {
                entry = srcHistory.peekLast();
                try {
                    this.tracking = false;
                    if (undo) {
                        entry.undo(this.session);
                    } else {
                        entry.redo(this.session);
                    }
                }
                catch (GSDeltaException e) {
                    break;
                }
                finally {
                    this.tracking = true;
                }
                dstHistory.addLast(srcHistory.removeLast());
                ++count;
            } while (!srcHistory.isEmpty() && srcHistory.getLast().isChained(entry));
            if (count != 0) {
                this.dispatchHistoryChanged();
                this.dispatchHistoryDelta(new GSMoveUndoRedoHistoryDelta(undo, count));
            }
        }
    }

    public boolean hasUndoHistory() {
        return !this.undoHistory.isEmpty();
    }

    public boolean hasRedoHistory() {
        return !this.redoHistory.isEmpty();
    }

    public void addUndoRedoListener(GSIUndoRedoListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null!");
        }
        this.historyListeners.add(listener);
    }

    public void removeUndoRedoListener(GSIUndoRedoListener listener) {
        this.historyListeners.remove(listener);
    }

    private void dispatchHistoryChanged() {
        for (GSIUndoRedoListener listener : this.historyListeners) {
            listener.onHistoryChanged();
        }
    }

    void addDeltaListener(GSIDeltaListener<GSUndoRedoHistory> listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null!");
        }
        this.deltaListeners.add(listener);
    }

    void removeDeltaListener(GSIDeltaListener<GSUndoRedoHistory> listener) {
        this.deltaListeners.remove(listener);
    }

    private void dispatchHistoryDelta(GSIDelta<GSUndoRedoHistory> delta) {
        if (!this.applyingDelta) {
            for (GSIDeltaListener<GSUndoRedoHistory> listener : this.deltaListeners) {
                listener.onDelta(delta);
            }
        }
    }

    void applyDelta(GSIDelta<GSUndoRedoHistory> delta) throws GSDeltaException {
        this.applyingDelta = true;
        try {
            delta.apply(this);
        }
        finally {
            this.applyingDelta = false;
        }
    }

    void addEntry(GSIUndoRedoEntry entry) {
        if (this.tracking) {
            if (!this.redoHistory.isEmpty()) {
                this.redoHistory.clear();
            }
            this.undoHistory.addLast(entry);
            if (this.undoHistory.size() > 10000) {
                this.undoHistory.removeFirst();
            }
            this.dispatchHistoryChanged();
            this.dispatchHistoryDelta(new GSTrackUndoRedoHistoryDelta(entry));
        }
    }

    int moveEntries(boolean moveToRedo, int count) {
        int i;
        Deque<GSIUndoRedoEntry> srcHistory = moveToRedo ? this.undoHistory : this.redoHistory;
        Deque<GSIUndoRedoEntry> dstHistory = moveToRedo ? this.redoHistory : this.undoHistory;
        for (i = 0; i < count && !srcHistory.isEmpty(); ++i) {
            dstHistory.addLast(srcHistory.removeLast());
        }
        return i;
    }

    public static GSUndoRedoHistory read(GSDecodeBuffer buf) throws IOException {
        LinkedList<GSIUndoRedoEntry> undoHistory = new LinkedList<GSIUndoRedoEntry>();
        LinkedList<GSIUndoRedoEntry> redoHistory = new LinkedList<GSIUndoRedoEntry>();
        int undoCount = buf.readInt();
        while (undoCount-- != 0) {
            undoHistory.addLast(GSUndoRedoHistory.readEntry(buf));
        }
        int redoCount = buf.readInt();
        while (redoCount-- != 0) {
            redoHistory.addLast(GSUndoRedoHistory.readEntry(buf));
        }
        return new GSUndoRedoHistory(undoHistory, redoHistory);
    }

    public static void write(GSEncodeBuffer buf, GSUndoRedoHistory history) throws IOException {
        buf.writeInt(history.undoHistory.size());
        for (GSIUndoRedoEntry entry : history.undoHistory) {
            GSUndoRedoHistory.writeEntry(buf, entry);
        }
        buf.writeInt(history.redoHistory.size());
        for (GSIUndoRedoEntry entry : history.redoHistory) {
            GSUndoRedoHistory.writeEntry(buf, entry);
        }
    }

    static GSIUndoRedoEntry readEntry(GSDecodeBuffer buf) throws IOException {
        short identifier = buf.readUnsignedByte();
        GSIUndoRedoEntry entry = (GSIUndoRedoEntry)ENTRY_REGISTRY.createNewElement((Object)identifier);
        if (entry == null) {
            throw new IOException("Unknown entry identifier: " + identifier);
        }
        entry.read(buf);
        return entry;
    }

    static void writeEntry(GSEncodeBuffer buf, GSIUndoRedoEntry entry) throws IOException {
        buf.writeUnsignedByte(((Integer)ENTRY_REGISTRY.getIdentifier((Object)entry)).shortValue());
        entry.write(buf);
    }

    static {
        ENTRY_REGISTRY.register((Object)0, GSCompositionUndoRedoEntry.class, GSCompositionUndoRedoEntry::new);
        ENTRY_REGISTRY.register((Object)1, GSSequenceUndoRedoEntry.class, GSSequenceUndoRedoEntry::new);
    }
}

