/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.stream;

import com.g4mesoft.captureplayback.stream.GSBlockRegion;
import com.g4mesoft.captureplayback.stream.GSIPlaybackStream;
import com.g4mesoft.captureplayback.stream.GSIStreamCloseListener;
import com.g4mesoft.captureplayback.stream.frame.GSISignalFrame;

public class GSDelayedPlaybackStream
implements GSIPlaybackStream {
    private final GSIPlaybackStream stream;
    private int delay;

    public GSDelayedPlaybackStream(GSIPlaybackStream stream, int delay) {
        if (stream == null) {
            throw new IllegalArgumentException("stream is null");
        }
        this.stream = stream;
        this.delay = delay;
    }

    @Override
    public GSISignalFrame read() {
        if (this.delay > 0) {
            --this.delay;
            return GSISignalFrame.EMPTY;
        }
        return (GSISignalFrame)this.stream.read();
    }

    @Override
    public void addCloseListener(GSIStreamCloseListener listener) {
        this.stream.addCloseListener(listener);
    }

    @Override
    public void removeCloseListener(GSIStreamCloseListener listener) {
        this.stream.removeCloseListener(listener);
    }

    @Override
    public GSBlockRegion getBlockRegion() {
        return this.stream.getBlockRegion();
    }

    @Override
    public void close() {
        this.delay = 0;
        this.stream.close();
    }

    @Override
    public boolean isClosed() {
        return this.stream.isClosed();
    }

    @Override
    public boolean isForceClosed() {
        return this.stream.isForceClosed();
    }
}

