/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.stream;

import com.g4mesoft.captureplayback.common.GSAbstractStream;
import com.g4mesoft.captureplayback.common.GSESignalEdge;
import com.g4mesoft.captureplayback.common.GSETickPhase;
import com.g4mesoft.captureplayback.common.GSSignalTime;
import com.g4mesoft.captureplayback.sequence.GSChannel;
import com.g4mesoft.captureplayback.sequence.GSChannelEntry;
import com.g4mesoft.captureplayback.sequence.GSEChannelEntryType;
import com.g4mesoft.captureplayback.stream.GSBlockRegion;
import com.g4mesoft.captureplayback.stream.GSIPlaybackStream;
import com.g4mesoft.captureplayback.stream.GSPlaybackEntry;
import com.g4mesoft.captureplayback.stream.GSSignalEvent;
import com.g4mesoft.captureplayback.stream.frame.GSBasicSignalFrame;
import com.g4mesoft.captureplayback.stream.frame.GSISignalFrame;
import java.util.ArrayList;
import java.util.PriorityQueue;
import net.minecraft.class_2338;

public abstract class GSPlaybackStream
extends GSAbstractStream
implements GSIPlaybackStream {
    private final GSBlockRegion blockRegion;
    private final PriorityQueue<GSPlaybackEntry> entries;
    private long playbackTime;
    private boolean wasCloseCalled;

    public GSPlaybackStream(GSBlockRegion blockRegion) {
        this.blockRegion = blockRegion;
        this.entries = new PriorityQueue();
    }

    protected void addChannelPlayback(GSChannel channel, long offset) {
        for (class_2338 position : channel.getInfo().getPositions()) {
            for (GSChannelEntry entry : channel.getEntries()) {
                GSSignalTime endTime;
                GSSignalTime startTime;
                GSEChannelEntryType type = entry.getType();
                if (offset != 0L) {
                    startTime = entry.getStartTime().offsetCopy(offset, 0);
                    endTime = entry.getEndTime().offsetCopy(offset, 0);
                } else {
                    startTime = entry.getStartTime();
                    endTime = entry.getEndTime();
                }
                this.addEntry(position, startTime, GSESignalEdge.RISING_EDGE, !type.hasStartEvent());
                this.addEntry(position, endTime, GSESignalEdge.FALLING_EDGE, !type.hasEndEvent());
            }
        }
    }

    protected void addEntry(class_2338 pos, GSSignalTime time, GSESignalEdge edge, boolean shadow) {
        this.entries.add(new GSPlaybackEntry(pos, time, this.entries.size(), edge, shadow));
    }

    private GSSignalEvent toCleanupEvent(GSSignalEvent event) {
        return new GSSignalEvent(GSETickPhase.IMMEDIATE, -1, 0, event.getEdge(), event.getPos(), true);
    }

    @Override
    public GSISignalFrame read() {
        GSISignalFrame frame = GSISignalFrame.EMPTY;
        if (!this.isClosed()) {
            if (this.wasCloseCalled) {
                GSPlaybackEntry entry;
                ArrayList<GSSignalEvent> frameEvents = new ArrayList<GSSignalEvent>();
                while ((entry = this.entries.poll()) != null) {
                    frameEvents.add(this.toCleanupEvent(entry.getEvent()));
                }
                frame = new GSBasicSignalFrame(frameEvents);
            } else if (this.isEntryInFrame(this.entries.peek())) {
                ArrayList<GSSignalEvent> frameEvents = new ArrayList<GSSignalEvent>();
                do {
                    frameEvents.add(this.entries.poll().getEvent());
                } while (!this.isClosed() && this.isEntryInFrame(this.entries.peek()));
                frame = new GSBasicSignalFrame(frameEvents);
            }
        }
        ++this.playbackTime;
        if (this.isClosed()) {
            this.dispatchCloseEvent();
        }
        return frame;
    }

    private boolean isEntryInFrame(GSPlaybackEntry entry) {
        return entry.getPlaybackTime() <= this.playbackTime;
    }

    @Override
    public GSBlockRegion getBlockRegion() {
        return this.blockRegion;
    }

    @Override
    public void close() {
        this.wasCloseCalled = true;
    }

    @Override
    public boolean isClosed() {
        return this.entries.isEmpty();
    }

    @Override
    public boolean isForceClosed() {
        return this.isClosed() && this.wasCloseCalled;
    }
}

