/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common;

import com.g4mesoft.captureplayback.common.GSIDelta;
import com.g4mesoft.registry.GSSupplierRegistry;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.function.Supplier;

public class GSDeltaRegistry<M> {
    private final GSSupplierRegistry<Integer, GSIDelta<M>> registry = new GSSupplierRegistry();

    GSDeltaRegistry() {
    }

    public <T extends GSIDelta<M>> void register(int id, Class<T> deltaClazz, Supplier<T> deltaSupplier) {
        this.registry.register((Object)id, deltaClazz, deltaSupplier);
    }

    public GSIDelta<M> read(GSDecodeBuffer buf) throws IOException {
        GSIDelta delta = (GSIDelta)this.registry.createNewElement((Object)buf.readInt());
        if (delta == null) {
            throw new IOException("Invalid delta ID");
        }
        delta.read(buf);
        return delta;
    }

    public void write(GSEncodeBuffer buf, GSIDelta<M> delta) throws IOException {
        Integer identifier = (Integer)this.registry.getIdentifier(delta);
        if (identifier == null) {
            throw new IOException("Unknown delta");
        }
        buf.writeInt(identifier.intValue());
        delta.write(buf);
    }
}

