/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common;

import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;

public final class GSSignalTime {
    public static final GSSignalTime ZERO = new GSSignalTime(0L, 0);
    public static final GSSignalTime INFINITY = new GSSignalTime(Long.MAX_VALUE, Integer.MAX_VALUE);
    private final long gametick;
    private final int microtick;

    public GSSignalTime(long gametick, int microtick) {
        if (gametick < 0L || microtick < 0) {
            throw new IllegalArgumentException("Ticks must be non-negative!");
        }
        this.gametick = gametick;
        this.microtick = microtick;
    }

    public GSSignalTime offsetCopy(long gtOffset, int mtOffset) {
        return new GSSignalTime(this.gametick + gtOffset, this.microtick + mtOffset);
    }

    public boolean isAfter(GSSignalTime other) {
        if (this.gametick == other.gametick) {
            return this.microtick > other.microtick;
        }
        return this.gametick > other.gametick;
    }

    public boolean isBefore(GSSignalTime other) {
        if (this.gametick == other.gametick) {
            return this.microtick < other.microtick;
        }
        return this.gametick < other.gametick;
    }

    public boolean isEqual(GSSignalTime other) {
        return this.gametick == other.gametick && this.microtick == other.microtick;
    }

    public long getGametick() {
        return this.gametick;
    }

    public int getMicrotick() {
        return this.microtick;
    }

    public int hashCode() {
        return Long.hashCode(this.gametick) + 31 * this.microtick;
    }

    public boolean equals(Object other) {
        if (!(other instanceof GSSignalTime)) {
            return false;
        }
        return this.isEqual((GSSignalTime)other);
    }

    public static GSSignalTime read(GSDecodeBuffer buf) throws IOException {
        long gametick = buf.readLong();
        int microtick = buf.readInt();
        if (gametick < 0L || microtick < 0) {
            throw new IOException("Invalid time parameters!");
        }
        return new GSSignalTime(gametick, microtick);
    }

    public static void write(GSEncodeBuffer buf, GSSignalTime time) throws IOException {
        buf.writeLong(time.gametick);
        buf.writeInt(time.microtick);
    }
}

