/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.common.asset.GSIPlayerCache;
import com.g4mesoft.captureplayback.common.asset.GSIPlayerCacheListener;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

public abstract class GSAbstractPlayerCache
implements GSIPlayerCache {
    private final List<GSIPlayerCacheListener> listeners = new ArrayList<GSIPlayerCacheListener>();

    @Override
    public void addListener(GSIPlayerCacheListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null");
        }
        this.listeners.add(listener);
    }

    @Override
    public void removeListener(GSIPlayerCacheListener listener) {
        this.listeners.remove(listener);
    }

    protected void dispatchEntryAdded(UUID playerUUID) {
        for (GSIPlayerCacheListener listener : this.listeners) {
            listener.onEntryAdded(playerUUID);
        }
    }

    protected void dispatchEntryRemoved(UUID playerUUID) {
        for (GSIPlayerCacheListener listener : this.listeners) {
            listener.onEntryRemoved(playerUUID);
        }
    }
}

