/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSAssetManager;
import com.g4mesoft.captureplayback.module.server.GSCapturePlaybackServerModule;
import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.core.server.GSServerController;
import com.g4mesoft.packet.GSIPacket;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class GSAssetCollaboratorPacket
implements GSIPacket {
    private UUID assetUUID;
    private UUID collabUUID;
    private boolean removed;

    public GSAssetCollaboratorPacket() {
    }

    public GSAssetCollaboratorPacket(UUID assetUUID, UUID collabUUID, boolean removed) {
        this.assetUUID = assetUUID;
        this.collabUUID = collabUUID;
        this.removed = removed;
    }

    public void read(GSDecodeBuffer buf) throws IOException {
        this.assetUUID = buf.readUUID();
        this.collabUUID = buf.readUUID();
        this.removed = buf.readBoolean();
    }

    public void write(GSEncodeBuffer buf) throws IOException {
        buf.writeUUID(this.assetUUID);
        buf.writeUUID(this.collabUUID);
        buf.writeBoolean(this.removed);
    }

    public void handleOnServer(GSServerController controller, class_3222 player) {
        GSAssetManager assetManager;
        GSAssetInfo info;
        GSCapturePlaybackServerModule module = (GSCapturePlaybackServerModule)controller.getModule(GSCapturePlaybackServerModule.class);
        if (module != null && (info = (assetManager = module.getAssetManager()).getStoredHistory().get(this.assetUUID)) != null && info.hasExtendedPermission((class_1657)player)) {
            if (this.removed) {
                assetManager.removeCollaborator(this.assetUUID, this.collabUUID);
            } else {
                assetManager.addCollaborator(this.assetUUID, this.collabUUID);
            }
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void handleOnClient(GSClientController controller) {
    }
}

