/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSEAssetType;
import com.g4mesoft.captureplayback.common.asset.GSIPlayerCache;
import com.g4mesoft.captureplayback.common.asset.GSPlayerCacheEntry;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public class GSAssetFileHeader {
    private static final int VERSIONED_FORMAT_BIT = 128;
    public static final int PLAYER_CACHE_ENTRY_FORMAT_VERSION = 1;
    private static final int MIN_FORMAT_VERSION = 0;
    private static final int MAX_FORMAT_VERSION = 127;
    private static final int LATEST_FORMAT_VERSION = 1;
    private final int formatVersion;
    private final GSEAssetType type;
    private final long createdTimestamp;
    private final UUID createdByUUID;
    private final GSPlayerCacheEntry createdByCacheEntry;

    public GSAssetFileHeader(GSAssetInfo info, GSIPlayerCache playerCache) {
        this(1, info.getType(), info.getCreatedTimestamp(), info.getCreatedByUUID(), playerCache.get(info.getCreatedByUUID()));
    }

    private GSAssetFileHeader(int formatVersion, GSEAssetType type, long createdTimestamp, UUID createdByUUID, GSPlayerCacheEntry createdByCacheEntry) {
        if (formatVersion < 0 || formatVersion > 127) {
            throw new IllegalArgumentException("Invalid format version");
        }
        if (type == null) {
            throw new IllegalArgumentException("type is null");
        }
        if (createdByUUID == null) {
            throw new IllegalArgumentException("createdByUUID is null");
        }
        this.formatVersion = formatVersion;
        this.type = type;
        this.createdTimestamp = createdTimestamp;
        this.createdByUUID = createdByUUID;
        this.createdByCacheEntry = createdByCacheEntry;
    }

    public GSAssetFileHeader(GSAssetFileHeader other) {
        this.formatVersion = other.formatVersion;
        this.type = other.type;
        this.createdTimestamp = other.createdTimestamp;
        this.createdByUUID = other.createdByUUID;
        this.createdByCacheEntry = other.createdByCacheEntry;
    }

    public int getFormatVersion() {
        return this.formatVersion;
    }

    public GSEAssetType getType() {
        return this.type;
    }

    public long getCreatedTimestamp() {
        return this.createdTimestamp;
    }

    public UUID getCreatedByUUID() {
        return this.createdByUUID;
    }

    public GSPlayerCacheEntry getCreatedByCacheEntry() {
        return this.createdByCacheEntry;
    }

    public int hashCode() {
        int hash = 0;
        hash = 31 * hash + this.type.hashCode();
        hash = 31 * hash + Long.hashCode(this.createdTimestamp);
        hash = 31 * hash + this.createdByUUID.hashCode();
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GSAssetFileHeader) {
            GSAssetFileHeader other = (GSAssetFileHeader)obj;
            if (this.type != other.type) {
                return false;
            }
            if (this.createdTimestamp != other.createdTimestamp) {
                return false;
            }
            return this.createdByUUID.equals(other.createdByUUID);
        }
        return false;
    }

    public static GSAssetFileHeader read(GSDecodeBuffer buf) throws IOException {
        int typeIndex;
        int formatVersion = buf.readUnsignedByte();
        if ((formatVersion & 0x80) != 0) {
            if ((formatVersion &= 0xFFFFFF7F) == 0) {
                throw new IOException("Invalid format version");
            }
            typeIndex = buf.readUnsignedByte();
        } else {
            typeIndex = formatVersion & 0xFF;
            formatVersion = 0;
        }
        GSEAssetType type = GSEAssetType.fromIndex(typeIndex);
        if (type == null) {
            throw new IOException("Unknown asset type");
        }
        long createdTimestamp = buf.readLong();
        UUID createdByUUID = buf.readUUID();
        GSPlayerCacheEntry createdByCacheEntry = formatVersion >= 1 ? (buf.readBoolean() ? GSPlayerCacheEntry.read(buf) : null) : null;
        return new GSAssetFileHeader(formatVersion, type, createdTimestamp, createdByUUID, createdByCacheEntry);
    }

    public static void write(GSEncodeBuffer buf, GSAssetFileHeader header) throws IOException {
        buf.writeUnsignedByte((short)129);
        buf.writeUnsignedByte((short)header.getType().getIndex());
        buf.writeLong(header.getCreatedTimestamp());
        buf.writeUUID(header.getCreatedByUUID());
        buf.writeBoolean(header.getCreatedByCacheEntry() != null);
        if (header.getCreatedByCacheEntry() != null) {
            GSPlayerCacheEntry.write(buf, header.getCreatedByCacheEntry());
        }
    }
}

