/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.common.asset.GSAssetHandle;
import com.g4mesoft.captureplayback.common.asset.GSEAssetType;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.Collections;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_1657;

public class GSAssetInfo
implements Comparable<GSAssetInfo> {
    public static final UUID UNKNOWN_OWNER_UUID = new UUID(0L, 0L);
    private final int typeIndex;
    private final UUID assetUUID;
    private final GSAssetHandle handle;
    private final GSAssetInfo refInfo;
    private String assetName;
    private final long createdTimestamp;
    private long lastModifiedTimestamp;
    private final UUID createdByUUID;
    private UUID ownerUUID;
    private final Set<UUID> collabUUIDs;

    public GSAssetInfo(GSEAssetType type, UUID assetUUID, GSAssetHandle handle, String assetName, long createdTimestamp, UUID createdByUUID, UUID ownerUUID) {
        this(type, assetUUID, handle, assetName, createdTimestamp, createdTimestamp, createdByUUID, ownerUUID);
    }

    public GSAssetInfo(GSEAssetType type, UUID assetUUID, GSAssetHandle handle, String assetName, long createdTimestamp, long lastModifiedTimestamp, UUID createdByUUID, UUID ownerUUID) {
        this(type, assetUUID, handle, assetName, createdTimestamp, lastModifiedTimestamp, createdByUUID, ownerUUID, null);
    }

    public GSAssetInfo(GSEAssetType type, UUID assetUUID, GSAssetHandle handle, String assetName, long createdTimestamp, long lastModifiedTimestamp, UUID createdByUUID, UUID ownerUUID, Set<UUID> collabUUIDs) {
        this(type.getIndex(), assetUUID, handle, assetName, createdTimestamp, lastModifiedTimestamp, createdByUUID, ownerUUID, null);
    }

    public GSAssetInfo(int typeIndex, UUID assetUUID, GSAssetHandle handle, String assetName, long createdTimestamp, long lastModifiedTimestamp, UUID createdByUUID, UUID ownerUUID, Set<UUID> collabUUIDs) {
        this.typeIndex = typeIndex;
        this.assetUUID = assetUUID;
        this.handle = handle;
        this.refInfo = null;
        this.assetName = assetName;
        this.createdTimestamp = createdTimestamp;
        this.lastModifiedTimestamp = lastModifiedTimestamp;
        this.createdByUUID = createdByUUID;
        this.ownerUUID = ownerUUID;
        this.collabUUIDs = collabUUIDs != null ? new LinkedHashSet<UUID>(collabUUIDs) : new LinkedHashSet();
    }

    public GSAssetInfo(GSEAssetType type, UUID assetUUID, GSAssetInfo refInfo) {
        this.typeIndex = type.getIndex();
        this.assetUUID = assetUUID;
        this.refInfo = refInfo;
        this.assetName = null;
        this.createdTimestamp = 0L;
        this.lastModifiedTimestamp = 0L;
        this.createdByUUID = null;
        this.ownerUUID = null;
        this.collabUUIDs = null;
        this.handle = null;
    }

    public GSAssetInfo(GSAssetInfo other) {
        this.typeIndex = other.typeIndex;
        this.assetUUID = other.assetUUID;
        this.handle = other.handle;
        this.refInfo = other.refInfo;
        this.assetName = other.assetName;
        this.createdTimestamp = other.createdTimestamp;
        this.lastModifiedTimestamp = other.lastModifiedTimestamp;
        this.createdByUUID = other.createdByUUID;
        this.ownerUUID = other.ownerUUID;
        this.collabUUIDs = other.collabUUIDs != null ? new LinkedHashSet<UUID>(other.collabUUIDs) : null;
    }

    public GSEAssetType getType() {
        return GSEAssetType.fromIndex(this.typeIndex);
    }

    public int getTypeIndex() {
        return this.typeIndex;
    }

    public UUID getAssetUUID() {
        return this.assetUUID;
    }

    public GSAssetHandle getHandle() {
        return this.handle;
    }

    public String getAssetName() {
        return this.isDerived() ? this.refInfo.getAssetName() : this.assetName;
    }

    void setAssetName(String assetName) {
        if (this.isDerived()) {
            throw new IllegalStateException("Unable to modify derived asset info");
        }
        this.assetName = assetName;
    }

    public long getCreatedTimestamp() {
        return this.isDerived() ? this.refInfo.getCreatedTimestamp() : this.createdTimestamp;
    }

    public long getLastModifiedTimestamp() {
        return this.isDerived() ? this.refInfo.getLastModifiedTimestamp() : this.lastModifiedTimestamp;
    }

    void setLastModifiedTimestamp(long timestamp) {
        if (this.isDerived()) {
            throw new IllegalStateException("Unable to modify derived asset info");
        }
        this.lastModifiedTimestamp = timestamp;
    }

    public UUID getCreatedByUUID() {
        return this.createdByUUID;
    }

    public UUID getOwnerUUID() {
        return this.isDerived() ? this.refInfo.getOwnerUUID() : this.ownerUUID;
    }

    public boolean hasExtendedPermission(class_1657 player) {
        if (player.method_64475(2)) {
            return true;
        }
        return this.getOwnerUUID().equals(player.method_5667());
    }

    void setOwnerUUID(UUID ownerUUID) {
        if (this.isDerived()) {
            throw new IllegalStateException("Unable to modify derived asset info");
        }
        this.ownerUUID = ownerUUID;
    }

    public Set<UUID> getCollaboratorUUIDs() {
        return this.isDerived() ? this.refInfo.getCollaboratorUUIDs() : Collections.unmodifiableSet(this.collabUUIDs);
    }

    public boolean isCollaborator(UUID collabUUID) {
        return this.getCollaboratorUUIDs().contains(collabUUID);
    }

    void addCollaborator(UUID collabUUID) {
        if (this.isDerived()) {
            throw new IllegalStateException("Unable to modify derived asset info");
        }
        this.collabUUIDs.add(collabUUID);
    }

    void removeCollaborator(UUID collabUUID) {
        if (this.isDerived()) {
            throw new IllegalStateException("Unable to modify derived asset info");
        }
        this.collabUUIDs.remove(collabUUID);
    }

    public boolean hasPermission(class_1657 player) {
        if (player.method_64475(2)) {
            return true;
        }
        UUID ownerUUID = this.getOwnerUUID();
        if (ownerUUID.equals(player.method_5667())) {
            return true;
        }
        if (ownerUUID.equals(UNKNOWN_OWNER_UUID)) {
            return true;
        }
        return this.getCollaboratorUUIDs().contains(player.method_5667());
    }

    public boolean isDerived() {
        return this.refInfo != null;
    }

    public int hashCode() {
        int hash = 0;
        hash = 31 * hash + Integer.hashCode(this.typeIndex);
        hash = 31 * hash + this.assetUUID.hashCode();
        hash = 31 * hash + Objects.hashCode(this.handle);
        hash = 31 * hash + Long.hashCode(this.createdTimestamp);
        hash = 31 * hash + Long.hashCode(this.lastModifiedTimestamp);
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj instanceof GSAssetInfo) {
            GSAssetInfo other = (GSAssetInfo)obj;
            if (this.typeIndex != other.typeIndex) {
                return false;
            }
            if (!this.assetUUID.equals(other.assetUUID)) {
                return false;
            }
            if (!Objects.equals(this.handle, other.handle)) {
                return false;
            }
            if (this.createdTimestamp != other.createdTimestamp) {
                return false;
            }
            return this.lastModifiedTimestamp == other.lastModifiedTimestamp;
        }
        return false;
    }

    @Override
    public int compareTo(GSAssetInfo other) {
        long lastModifiedDelta = this.lastModifiedTimestamp - other.lastModifiedTimestamp;
        if (lastModifiedDelta != 0L) {
            return lastModifiedDelta > 0L ? -1 : 1;
        }
        long createdDelta = this.createdTimestamp - other.createdTimestamp;
        if (createdDelta != 0L) {
            return createdDelta > 0L ? -1 : 1;
        }
        if (this.typeIndex != other.typeIndex) {
            return this.typeIndex < other.typeIndex ? -1 : 1;
        }
        if (!Objects.equals(this.handle, other.handle)) {
            if (other.handle == null) {
                return -1;
            }
            if (this.handle == null) {
                return 1;
            }
            return this.handle.compareTo(other.handle);
        }
        return this.assetUUID.compareTo(other.assetUUID);
    }

    public static GSAssetInfo read(GSDecodeBuffer buf) throws IOException {
        short typeIndex = buf.readUnsignedByte();
        UUID assetUUID = buf.readUUID();
        GSAssetHandle handle = GSAssetHandle.read(buf);
        String assetName = buf.readString();
        long createdTimestamp = buf.readLong();
        long lastModifiedTimestamp = buf.readLong();
        UUID createdByUUID = buf.readUUID();
        UUID ownerUUID = buf.readUUID();
        int collabUUIDCount = buf.readInt();
        GSAssetInfo info = new GSAssetInfo(typeIndex, assetUUID, handle, assetName, createdTimestamp, lastModifiedTimestamp, createdByUUID, ownerUUID, null);
        while (collabUUIDCount-- > 0) {
            info.addCollaborator(buf.readUUID());
        }
        return info;
    }

    public static void write(GSEncodeBuffer buf, GSAssetInfo info) throws IOException {
        if (info.isDerived()) {
            throw new IOException("Writing derived asset info is unsupported");
        }
        buf.writeUnsignedByte((short)info.getTypeIndex());
        buf.writeUUID(info.getAssetUUID());
        GSAssetHandle.write(buf, info.getHandle());
        buf.writeString(info.getAssetName());
        buf.writeLong(info.getCreatedTimestamp());
        buf.writeLong(info.getLastModifiedTimestamp());
        buf.writeUUID(info.getCreatedByUUID());
        buf.writeUUID(info.getOwnerUUID());
        Set<UUID> collabUUIDs = info.getCollaboratorUUIDs();
        buf.writeInt(collabUUIDs.size());
        for (UUID collabUUID : collabUUIDs) {
            buf.writeUUID(collabUUID);
        }
    }
}

