/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.common.asset.GSAssetHandle;
import com.g4mesoft.captureplayback.common.asset.GSDecodedAssetFile;
import com.g4mesoft.captureplayback.module.server.GSCapturePlaybackServerModule;
import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.core.server.GSServerController;
import com.g4mesoft.packet.GSIPacket;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_3222;

public class GSImportAssetPacket
implements GSIPacket {
    private String name;
    private GSAssetHandle handle;
    private GSDecodedAssetFile assetFile;

    public GSImportAssetPacket() {
    }

    public GSImportAssetPacket(String name, GSAssetHandle handle, GSDecodedAssetFile assetFile) {
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        if (handle == null) {
            throw new IllegalArgumentException("handle is null");
        }
        if (assetFile == null) {
            throw new IllegalArgumentException("assetFile is null");
        }
        this.name = name;
        this.handle = handle;
        this.assetFile = assetFile;
    }

    public void read(GSDecodeBuffer buf) throws IOException {
        this.name = buf.readString();
        this.handle = GSAssetHandle.read(buf);
        this.assetFile = GSDecodedAssetFile.read(buf);
    }

    public void write(GSEncodeBuffer buf) throws IOException {
        buf.writeString(this.name);
        GSAssetHandle.write(buf, this.handle);
        GSDecodedAssetFile.write(buf, this.assetFile);
    }

    public void handleOnServer(GSServerController controller, class_3222 player) {
        GSCapturePlaybackServerModule module = (GSCapturePlaybackServerModule)controller.getModule(GSCapturePlaybackServerModule.class);
        if (module != null) {
            module.getAssetManager().importAsset(this.handle, this.name, player.method_5667(), this.assetFile);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void handleOnClient(GSClientController controller) {
    }
}

