/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.common.asset.GSAbstractPlayerCache;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSIPlayerCache;
import com.g4mesoft.captureplayback.common.asset.GSPlayerCacheEntry;
import com.g4mesoft.ui.util.GSTextUtil;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import net.minecraft.class_2561;

public class GSPlayerCache
extends GSAbstractPlayerCache {
    public static final class_2561 UNKNOWN_OWNER_NAME = GSTextUtil.translatable((String)"gui.tab.capture-playback.unknownOwner");
    private final Map<UUID, GSPlayerCacheEntry> entries;

    public GSPlayerCache() {
        this.entries = new HashMap<UUID, GSPlayerCacheEntry>();
    }

    public GSPlayerCache(GSIPlayerCache other) {
        this();
        this.set(other);
    }

    private GSPlayerCache(Map<UUID, GSPlayerCacheEntry> entries) {
        this.entries = entries;
    }

    @Override
    public GSPlayerCacheEntry get(UUID playerUUID) {
        return this.entries.get(playerUUID);
    }

    @Override
    public Iterable<UUID> getPlayers() {
        return Collections.unmodifiableSet(this.entries.keySet());
    }

    public class_2561 getNameText(UUID playerUUID) {
        if (playerUUID.equals(GSAssetInfo.UNKNOWN_OWNER_UUID)) {
            return UNKNOWN_OWNER_NAME;
        }
        GSPlayerCacheEntry entry = this.get(playerUUID);
        return GSTextUtil.literal((String)(entry != null ? entry.getName() : playerUUID.toString()));
    }

    void set(GSIPlayerCache playerCache) {
        this.entries.clear();
        for (UUID playerUUID : playerCache.getPlayers()) {
            this.entries.put(playerUUID, playerCache.get(playerUUID));
        }
        this.dispatchEntryAdded(null);
    }

    void add(UUID playerUUID, GSPlayerCacheEntry entry) {
        if (!this.entries.containsKey(playerUUID)) {
            this.entries.put(playerUUID, entry);
            this.dispatchEntryAdded(playerUUID);
        }
    }

    void remove(UUID playerUUID) {
        if (this.entries.remove(playerUUID) != null) {
            this.dispatchEntryRemoved(playerUUID);
        }
    }

    public static GSPlayerCache read(GSDecodeBuffer buf) throws IOException {
        int count = buf.readInt();
        if (count < 0) {
            throw new IOException("Player cache corrupted");
        }
        HashMap<UUID, GSPlayerCacheEntry> entries = new HashMap<UUID, GSPlayerCacheEntry>();
        while (count-- != 0) {
            UUID playerUUID = buf.readUUID();
            GSPlayerCacheEntry entry = GSPlayerCacheEntry.read(buf);
            entries.put(playerUUID, entry);
        }
        return new GSPlayerCache(entries);
    }

    public static void write(GSEncodeBuffer buf, GSPlayerCache cache) throws IOException {
        buf.writeInt(cache.entries.size());
        for (Map.Entry<UUID, GSPlayerCacheEntry> entryKV : cache.entries.entrySet()) {
            buf.writeUUID(entryKV.getKey());
            GSPlayerCacheEntry.write(buf, entryKV.getValue());
        }
    }
}

