/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.common.asset;

import com.g4mesoft.captureplayback.common.asset.GSAssetFileHeader;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSAssetManager;
import com.g4mesoft.captureplayback.common.asset.GSAssetRef;
import com.g4mesoft.captureplayback.common.asset.GSAssetRequestResponsePacket;
import com.g4mesoft.captureplayback.common.asset.GSDecodedAssetFile;
import com.g4mesoft.captureplayback.module.server.GSCapturePlaybackServerModule;
import com.g4mesoft.core.client.GSClientController;
import com.g4mesoft.core.server.GSServerController;
import com.g4mesoft.packet.GSIPacket;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;
import net.fabricmc.api.EnvType;
import net.fabricmc.api.Environment;
import net.minecraft.class_1657;
import net.minecraft.class_3222;

public class GSRequestAssetPacket
implements GSIPacket {
    private UUID assetUUID;

    public GSRequestAssetPacket() {
    }

    public GSRequestAssetPacket(UUID assetUUID) {
        if (assetUUID == null) {
            throw new IllegalArgumentException("assetUUID is null");
        }
        this.assetUUID = assetUUID;
    }

    public void read(GSDecodeBuffer buf) throws IOException {
        this.assetUUID = buf.readUUID();
    }

    public void write(GSEncodeBuffer buf) throws IOException {
        buf.writeUUID(this.assetUUID);
    }

    public void handleOnServer(GSServerController controller, class_3222 player) {
        GSAssetRef ref;
        GSAssetManager assetManager;
        GSAssetInfo info;
        GSCapturePlaybackServerModule module = (GSCapturePlaybackServerModule)controller.getModule(GSCapturePlaybackServerModule.class);
        GSAssetRequestResponsePacket packet = null;
        if (module != null && (info = (assetManager = module.getAssetManager()).getInfo(this.assetUUID)) != null && info.hasPermission((class_1657)player) && (ref = assetManager.requestAsset(this.assetUUID)) != null) {
            GSAssetFileHeader header = new GSAssetFileHeader(info, assetManager.getPlayerCache());
            GSDecodedAssetFile assetFile = new GSDecodedAssetFile(header, ref.get());
            packet = new GSAssetRequestResponsePacket(assetFile);
            ref.release();
        }
        if (packet != null) {
            controller.sendPacket(packet, player);
        } else {
            controller.sendPacket((GSIPacket)new GSAssetRequestResponsePacket(this.assetUUID), player);
        }
    }

    @Environment(value=EnvType.CLIENT)
    public void handleOnClient(GSClientController controller) {
    }
}

