/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition;

import com.g4mesoft.captureplayback.composition.GSCompositionCaptureStream;
import com.g4mesoft.captureplayback.composition.GSCompositionPlaybackStream;
import com.g4mesoft.captureplayback.composition.GSICompositionListener;
import com.g4mesoft.captureplayback.composition.GSTrack;
import com.g4mesoft.captureplayback.composition.GSTrackGroup;
import com.g4mesoft.captureplayback.stream.GSBlockRegion;
import com.g4mesoft.captureplayback.stream.GSICaptureStream;
import com.g4mesoft.captureplayback.stream.GSIPlaybackStream;
import com.g4mesoft.captureplayback.util.GSMutableLinkedHashMap;
import com.g4mesoft.captureplayback.util.GSUUIDUtil;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.minecraft.class_2338;

public class GSComposition {
    private final UUID compositionUUID;
    private String name;
    private final Map<UUID, GSTrackGroup> groups;
    private final Map<UUID, GSTrack> tracks;
    private List<GSICompositionListener> listeners;

    public GSComposition(GSComposition other) {
        this(other.getCompositionUUID(), other.getName());
        for (GSTrackGroup group : other.getGroups()) {
            this.addGroupInternal(new GSTrackGroup(group));
        }
        for (GSTrack track : other.getTracks()) {
            this.addTrackInternal(new GSTrack(track));
        }
    }

    public GSComposition(UUID compositionUUID) {
        this(compositionUUID, "");
    }

    public GSComposition(UUID compositionUUID, String name) {
        if (compositionUUID == null) {
            throw new IllegalArgumentException("compositionUUID is null");
        }
        if (name == null) {
            throw new IllegalArgumentException("name is null");
        }
        this.compositionUUID = compositionUUID;
        this.name = name;
        this.groups = new GSMutableLinkedHashMap<UUID, GSTrackGroup>();
        this.tracks = new LinkedHashMap<UUID, GSTrack>();
        this.listeners = null;
    }

    public void duplicateFrom(GSComposition other) {
        if (!this.groups.isEmpty() || !this.tracks.isEmpty()) {
            throw new IllegalArgumentException("Expected an empty composition");
        }
        HashMap<UUID, UUID> otherGroupToUUID = new HashMap<UUID, UUID>();
        for (GSTrackGroup group : other.getGroups()) {
            GSTrackGroup newGroup = this.addGroup(group.getName());
            newGroup.duplicateFrom(group);
            otherGroupToUUID.put(group.getGroupUUID(), newGroup.getGroupUUID());
        }
        for (GSTrack track : other.getTracks()) {
            UUID groupUUID = (UUID)otherGroupToUUID.get(track.getGroupUUID());
            GSTrack newTrack = this.addTrack(track.getName(), track.getColor(), groupUUID);
            newTrack.duplicateFrom(track);
        }
    }

    public void set(GSComposition other) {
        this.clear();
        this.setName(other.getName());
        for (GSTrackGroup group : other.getGroups()) {
            this.addGroup(group.getGroupUUID(), group.getName()).set(group);
        }
        for (GSTrack track : other.getTracks()) {
            this.addTrack(track.getTrackUUID(), track.getName(), track.getColor(), track.getGroupUUID()).set(track);
        }
    }

    private void clear() {
        Iterator<GSTrack> trackItr = this.tracks.values().iterator();
        while (trackItr.hasNext()) {
            GSTrack track = trackItr.next();
            trackItr.remove();
            this.onTrackRemoved(track);
        }
        Iterator<GSTrackGroup> groupItr = this.groups.values().iterator();
        while (groupItr.hasNext()) {
            GSTrackGroup group = groupItr.next();
            groupItr.remove();
            this.onGroupRemoved(group);
        }
    }

    public GSTrackGroup addGroup(String groupName) {
        return this.addGroup(GSUUIDUtil.randomUnique(this::hasGroupUUID), groupName);
    }

    public GSTrackGroup addGroup(UUID groupUUID, String groupName) {
        if (this.hasGroupUUID(groupUUID)) {
            throw new IllegalStateException("Duplicate group UUID");
        }
        GSTrackGroup group = new GSTrackGroup(groupUUID, groupName);
        this.addGroupInternal(group);
        this.dispatchGroupAdded(group);
        return group;
    }

    private void addGroupInternal(GSTrackGroup group) {
        group.onAdded(this);
        this.groups.put(group.getGroupUUID(), group);
    }

    public boolean removeGroup(UUID groupUUID) {
        GSTrackGroup group = this.groups.get(groupUUID);
        if (group != null) {
            for (UUID trackUUID : group.getTrackUUIDs()) {
                this.removeTrack(trackUUID);
            }
            this.groups.remove(groupUUID);
            this.onGroupRemoved(group);
            return true;
        }
        return false;
    }

    private void onGroupRemoved(GSTrackGroup group) {
        this.dispatchGroupRemoved(group);
        group.onRemoved(this);
    }

    public GSTrack addTrack(String trackName, int color, UUID groupUUID) {
        return this.addTrack(GSUUIDUtil.randomUnique(this::hasTrackUUID), trackName, color, groupUUID);
    }

    public GSTrack addTrack(UUID trackUUID, String trackName, int color, UUID groupUUID) {
        if (this.hasTrackUUID(trackUUID)) {
            throw new IllegalStateException("Duplicate track UUID");
        }
        if (!this.hasGroupUUID(groupUUID)) {
            throw new IllegalArgumentException("Group does not exist");
        }
        GSTrack track = new GSTrack(trackUUID, trackName, color, groupUUID);
        this.addTrackInternal(track);
        this.dispatchTrackAdded(track);
        return track;
    }

    private void addTrackInternal(GSTrack track) {
        track.onAdded(this);
        this.tracks.put(track.getTrackUUID(), track);
    }

    public boolean removeTrack(UUID trackUUID) {
        GSTrack track = this.tracks.remove(trackUUID);
        if (track != null) {
            this.onTrackRemoved(track);
            return true;
        }
        return false;
    }

    private void onTrackRemoved(GSTrack track) {
        this.dispatchTrackRemoved(track);
        track.onRemoved(this);
    }

    public UUID getCompositionUUID() {
        return this.compositionUUID;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        if (!name.equals(this.name)) {
            String oldName = this.name;
            this.name = name;
            this.dispatchCompositionNameChanged(oldName);
        }
    }

    public GSTrackGroup getGroup(UUID groupUUID) {
        return this.groups.get(groupUUID);
    }

    public boolean hasGroupUUID(UUID groupUUID) {
        return this.groups.containsKey(groupUUID);
    }

    public GSTrack getTrack(UUID trackUUID) {
        return this.tracks.get(trackUUID);
    }

    public boolean hasTrackUUID(UUID trackUUID) {
        return this.tracks.containsKey(trackUUID);
    }

    public Collection<GSTrackGroup> getGroups() {
        return Collections.unmodifiableCollection(this.groups.values());
    }

    public Set<UUID> getGroupUUIDs() {
        return Collections.unmodifiableSet(this.groups.keySet());
    }

    public Collection<GSTrack> getTracks() {
        return Collections.unmodifiableCollection(this.tracks.values());
    }

    public Set<UUID> getTrackUUIDs() {
        return Collections.unmodifiableSet(this.tracks.keySet());
    }

    public void addCompositionListener(GSICompositionListener listener) {
        if (listener == null) {
            throw new IllegalArgumentException("listener is null!");
        }
        if (this.listeners == null) {
            this.listeners = new ArrayList<GSICompositionListener>();
        }
        this.listeners.add(listener);
    }

    public void removeCompositionListener(GSICompositionListener listener) {
        if (this.listeners != null) {
            this.listeners.remove(listener);
        }
    }

    Iterable<GSICompositionListener> getListeners() {
        return this.listeners == null ? Collections.emptyList() : this.listeners;
    }

    private void dispatchCompositionNameChanged(String oldName) {
        for (GSICompositionListener listener : this.getListeners()) {
            listener.compositionNameChanged(oldName);
        }
    }

    private void dispatchGroupAdded(GSTrackGroup group) {
        for (GSICompositionListener listener : this.getListeners()) {
            listener.groupAdded(group);
        }
    }

    private void dispatchGroupRemoved(GSTrackGroup group) {
        for (GSICompositionListener listener : this.getListeners()) {
            listener.groupRemoved(group);
        }
    }

    private void dispatchTrackAdded(GSTrack track) {
        for (GSICompositionListener listener : this.getListeners()) {
            listener.trackAdded(track);
        }
    }

    private void dispatchTrackRemoved(GSTrack track) {
        for (GSICompositionListener listener : this.getListeners()) {
            listener.trackRemoved(track);
        }
    }

    public static GSComposition read(GSDecodeBuffer buf) throws IOException {
        buf.readByte();
        UUID compositionUUID = buf.readUUID();
        String name = buf.readString();
        GSComposition composition = new GSComposition(compositionUUID, name);
        int groupCount = buf.readInt();
        while (groupCount-- != 0) {
            GSTrackGroup group = GSTrackGroup.read(buf);
            if (composition.hasGroupUUID(group.getGroupUUID())) {
                throw new IOException("Duplicate group UUID");
            }
            composition.addGroupInternal(group);
        }
        int trackCount = buf.readInt();
        while (trackCount-- != 0) {
            GSTrack track = GSTrack.read(buf);
            if (composition.hasTrackUUID(track.getTrackUUID())) {
                throw new IOException("Duplicate track UUID");
            }
            composition.addTrackInternal(track);
        }
        return composition;
    }

    public static void write(GSEncodeBuffer buf, GSComposition composition) throws IOException {
        buf.writeByte((byte)0);
        buf.writeUUID(composition.getCompositionUUID());
        buf.writeString(composition.getName());
        Collection<GSTrackGroup> groups = composition.getGroups();
        buf.writeInt(groups.size());
        for (GSTrackGroup group : groups) {
            GSTrackGroup.write(buf, group);
        }
        Collection<GSTrack> tracks = composition.getTracks();
        buf.writeInt(tracks.size());
        for (GSTrack track : tracks) {
            GSTrack.write(buf, track);
        }
    }

    public GSIPlaybackStream getPlaybackStream() {
        return new GSCompositionPlaybackStream(this);
    }

    public GSICaptureStream getCaptureStream() {
        return new GSCompositionCaptureStream(this);
    }

    GSBlockRegion getBlockRegion() {
        int x0 = Integer.MAX_VALUE;
        int y0 = Integer.MAX_VALUE;
        int z0 = Integer.MAX_VALUE;
        int x1 = Integer.MIN_VALUE;
        int y1 = Integer.MIN_VALUE;
        int z1 = Integer.MIN_VALUE;
        for (GSTrack track : this.getTracks()) {
            GSBlockRegion region = track.getSequence().getBlockRegion();
            if (region.getX0() < x0) {
                x0 = region.getX0();
            }
            if (region.getY0() < y0) {
                y0 = region.getY0();
            }
            if (region.getZ0() < z0) {
                z0 = region.getZ0();
            }
            if (region.getX1() > x1) {
                x1 = region.getX1();
            }
            if (region.getY1() > y1) {
                y1 = region.getY1();
            }
            if (region.getZ1() <= z1) continue;
            z1 = region.getZ1();
        }
        return new GSBlockRegion(x0, y0, z0, x1, y1, z1);
    }

    public class_2338 getOrigin() {
        return this.getBlockRegion().getPos0();
    }

    public void offsetOrigin(int dx, int dy, int dz) {
        if (dx != 0 || dy != 0 || dz != 0) {
            for (GSTrack track : this.getTracks()) {
                track.getSequence().offsetOrigin(dx, dy, dz);
            }
        }
    }
}

