/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSTrack;
import com.g4mesoft.captureplayback.composition.delta.GSTrackDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public class GSTrackAddedDelta
extends GSTrackDelta {
    private String name;
    private int color;
    private UUID groupUUID;

    public GSTrackAddedDelta() {
    }

    public GSTrackAddedDelta(GSTrack track) {
        this(track.getTrackUUID(), track.getName(), track.getColor(), track.getGroupUUID());
    }

    public GSTrackAddedDelta(UUID trackUUID, String name, int color, UUID groupUUID) {
        super(trackUUID);
        this.name = name;
        this.color = color;
        this.groupUUID = groupUUID;
    }

    @Override
    public void unapply(GSComposition composition) throws GSDeltaException {
        this.removeTrack(composition, this.name, this.color, this.groupUUID, 0, 0, 0);
    }

    @Override
    public void apply(GSComposition composition) throws GSDeltaException {
        this.addTrack(composition, this.name, this.color, this.groupUUID);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.name = buf.readString();
        this.color = buf.readInt();
        this.groupUUID = buf.readUUID();
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        buf.writeString(this.name);
        buf.writeInt(this.color);
        buf.writeUUID(this.groupUUID);
    }
}

