/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSTrack;
import com.g4mesoft.captureplayback.composition.GSTrackEntry;
import com.g4mesoft.captureplayback.composition.delta.GSTrackDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public abstract class GSTrackEntryDelta
extends GSTrackDelta {
    protected UUID entryUUID;

    protected GSTrackEntryDelta() {
    }

    protected GSTrackEntryDelta(UUID trackUUID, UUID entryUUID) {
        super(trackUUID);
        this.entryUUID = entryUUID;
    }

    protected GSTrackEntry getEntry(GSComposition composition) throws GSDeltaException {
        return this.getEntry(this.getTrack(composition));
    }

    protected GSTrackEntry getEntry(GSTrack track) throws GSDeltaException {
        GSTrackEntry entry = track.getEntry(this.entryUUID);
        if (entry == null) {
            throw new GSDeltaException("Expected entry does not exist");
        }
        return entry;
    }

    protected void checkEntryOffset(GSTrackEntry entry, long expectedOffset) throws GSDeltaException {
        if (entry.getOffset() != expectedOffset) {
            throw new GSDeltaException("Entry does not have the expected offset");
        }
    }

    protected void removeEntry(GSComposition composition, long offset) throws GSDeltaException {
        GSTrackEntry entry = this.getEntry(composition);
        this.checkEntryOffset(entry, offset);
        entry.getParent().removeEntry(this.entryUUID);
    }

    protected GSTrackEntry addEntry(GSComposition composition, long offset) throws GSDeltaException {
        GSTrack track = this.getTrack(composition);
        if (track.hasEntryUUID(this.entryUUID)) {
            throw new GSDeltaException("Entry already exists");
        }
        try {
            return track.addEntry(this.entryUUID, offset);
        }
        catch (Throwable t) {
            track.removeEntry(this.entryUUID);
            throw new GSDeltaException("Failed to add entry", t);
        }
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.entryUUID = buf.readUUID();
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        buf.writeUUID(this.entryUUID);
    }
}

