/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.composition.delta;

import com.g4mesoft.captureplayback.common.GSDeltaException;
import com.g4mesoft.captureplayback.composition.GSComposition;
import com.g4mesoft.captureplayback.composition.GSTrack;
import com.g4mesoft.captureplayback.composition.delta.GSTrackDelta;
import com.g4mesoft.util.GSDecodeBuffer;
import com.g4mesoft.util.GSEncodeBuffer;
import java.io.IOException;
import java.util.UUID;

public class GSTrackGroupDelta
extends GSTrackDelta {
    private UUID newGroupUUID;
    private UUID oldGroupUUID;

    public GSTrackGroupDelta() {
    }

    public GSTrackGroupDelta(UUID trackUUID, UUID newGroupUUID, UUID oldGroupUUID) {
        super(trackUUID);
        this.newGroupUUID = newGroupUUID;
        this.oldGroupUUID = oldGroupUUID;
    }

    private void setTrackGroup(GSComposition composition, UUID newGroupUUID, UUID oldGroupUUID) throws GSDeltaException {
        GSTrack track = this.getTrack(composition);
        this.checkGroup(track, oldGroupUUID);
        track.setGroupUUID(newGroupUUID);
    }

    @Override
    public void unapply(GSComposition composition) throws GSDeltaException {
        this.setTrackGroup(composition, this.oldGroupUUID, this.newGroupUUID);
    }

    @Override
    public void apply(GSComposition composition) throws GSDeltaException {
        this.setTrackGroup(composition, this.newGroupUUID, this.oldGroupUUID);
    }

    @Override
    public void read(GSDecodeBuffer buf) throws IOException {
        super.read(buf);
        this.newGroupUUID = buf.readUUID();
        this.oldGroupUUID = buf.readUUID();
    }

    @Override
    public void write(GSEncodeBuffer buf) throws IOException {
        super.write(buf);
        buf.writeUUID(this.newGroupUUID);
        buf.writeUUID(this.oldGroupUUID);
    }
}

