/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.gui;

import com.g4mesoft.captureplayback.CapturePlaybackMod;
import com.g4mesoft.captureplayback.common.asset.GSAssetHandle;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSDecodedAssetFile;
import com.g4mesoft.captureplayback.common.asset.GSEAssetNamespace;
import com.g4mesoft.captureplayback.common.asset.GSEAssetType;
import com.g4mesoft.captureplayback.common.asset.GSIAssetHistory;
import com.g4mesoft.captureplayback.common.asset.GSIAssetHistoryListener;
import com.g4mesoft.captureplayback.common.asset.GSPlayerCache;
import com.g4mesoft.captureplayback.gui.GSAssetPermissionPanel;
import com.g4mesoft.captureplayback.gui.GSCapturePlaybackPanel;
import com.g4mesoft.captureplayback.gui.GSCreateAssetPanel;
import com.g4mesoft.captureplayback.gui.GSFilteredSet;
import com.g4mesoft.captureplayback.gui.GSSearchFilter;
import com.g4mesoft.captureplayback.module.client.GSClientAssetManager;
import com.g4mesoft.captureplayback.session.GSESessionRequestType;
import com.g4mesoft.ui.panel.GSEAnchor;
import com.g4mesoft.ui.panel.GSEFill;
import com.g4mesoft.ui.panel.GSETextAlignment;
import com.g4mesoft.ui.panel.GSGridLayoutManager;
import com.g4mesoft.ui.panel.GSILayoutManager;
import com.g4mesoft.ui.panel.GSIcon;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSParentPanel;
import com.g4mesoft.ui.panel.GSTexturedIcon;
import com.g4mesoft.ui.panel.button.GSButton;
import com.g4mesoft.ui.panel.dialog.GSConfirmDialog;
import com.g4mesoft.ui.panel.dialog.GSConfirmOption;
import com.g4mesoft.ui.panel.dialog.GSFileDialog;
import com.g4mesoft.ui.panel.dialog.GSFileExtensionFilter;
import com.g4mesoft.ui.panel.dialog.GSIFileNameFilter;
import com.g4mesoft.ui.panel.field.GSTextField;
import com.g4mesoft.ui.panel.field.GSTextLabel;
import com.g4mesoft.ui.panel.scroll.GSScrollPanel;
import com.g4mesoft.ui.panel.table.GSBasicTableModel;
import com.g4mesoft.ui.panel.table.GSEHeaderResizePolicy;
import com.g4mesoft.ui.panel.table.GSEHeaderSelectionPolicy;
import com.g4mesoft.ui.panel.table.GSITableColumn;
import com.g4mesoft.ui.panel.table.GSITableModel;
import com.g4mesoft.ui.panel.table.GSTablePanel;
import com.g4mesoft.util.GSFileUtil;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.time.Instant;
import java.util.Collection;
import java.util.UUID;
import net.minecraft.class_2561;
import org.apache.commons.lang3.StringUtils;

public class GSAssetHistoryPanel
extends GSParentPanel
implements GSIAssetHistoryListener {
    private static final class_2561 ASSET_HISTORY_TITLE = GSCapturePlaybackPanel.translatable("historyTitle");
    private static final int NAME_COLUMN_INDEX;
    private static final int OWNER_UUID_COLUMN_INDEX;
    private static final int MODIFIED_COLUMN_INDEX;
    private static final int CREATED_COLUMN_INDEX;
    private static final int NAMESPACE_COLUMN_INDEX;
    private static final int HANDLE_COLUMN_INDEX;
    private static final int TYPE_COLUMN_INDEX;
    private static final class_2561[] TABLE_TITLES;
    private static final int[] TABLE_WIDTHS;
    static final class_2561[] TYPE_TEXTS;
    static final class_2561 UNKNOWN_TYPE_TEXT;
    static final class_2561[] NAMESPACE_TEXTS;
    private static final GSIcon SEARCH_ICON;
    private static final GSIcon HOVERED_SEARCH_ICON;
    private static final GSIcon DISABLED_SEARCH_ICON;
    private static final class_2561 IMPORT_TEXT;
    private static final class_2561 EXPORT_TEXT;
    private static final class_2561 NEW_TEXT;
    private static final class_2561 EDIT_TEXT;
    private static final class_2561 DUPLICATE_TEXT;
    private static final class_2561 DELETE_TEXT;
    private static final class_2561 CONFIRM_DESCRIPTION;
    private static final class_2561 IMPORT_FAILED_TEXT;
    private static final class_2561 EXPORT_FAILED_TEXT;
    private static final class_2561 EXPORT_DENIED_TEXT;
    private static final class_2561 DUPLICATE_FAILED_TEXT;
    private static final class_2561 DELETE_FAILED_TEXT;
    private static final class_2561 EDIT_FAILED_TEXT;
    private static final GSIFileNameFilter GSA_FILE_NAME_FILTER;
    private static final int SEARCH_FIELD_PREFERRED_WIDTH = 200;
    private static final int BUTTON_PREFERRED_WIDTH = 75;
    private final GSClientAssetManager assetManager;
    private final GSAssetPermissionPanel assetPermPanel;
    private final GSIAssetHistory history;
    private final GSPlayerCache playerCache;
    private final GSTablePanel table;
    private final GSTextField searchField;
    private final GSButton searchButton;
    private final GSButton importButton;
    private final GSButton exportButton;
    private final GSButton newButton;
    private final GSButton editButton;
    private final GSButton duplicateButton;
    private final GSButton deleteButton;
    private GSAssetHandle selectedHandle;

    public GSAssetHistoryPanel(GSClientAssetManager assetManager, GSAssetPermissionPanel assetPermPanel) {
        this.assetManager = assetManager;
        this.history = assetManager.getAssetHistory();
        this.playerCache = assetManager.getPlayerCache();
        this.assetPermPanel = assetPermPanel;
        this.table = new GSTablePanel(this.createTableModel(null));
        this.table.setColumnHeaderResizePolicy(GSEHeaderResizePolicy.RESIZE_SUBSEQUENT);
        this.table.setRowHeaderResizePolicy(GSEHeaderResizePolicy.RESIZE_OFF);
        this.table.setColumnSelectionPolicy(GSEHeaderSelectionPolicy.DISABLED);
        this.table.setRowSelectionPolicy(GSEHeaderSelectionPolicy.SINGLE_SELECTION);
        this.table.setBorderWidth(0, 1);
        this.table.setPreferredRowCount(10);
        this.table.setMinimumRowHeight(16);
        this.searchField = new GSTextField();
        this.searchField.setFocusLostOnConfirm(false);
        this.searchButton = new GSButton(SEARCH_ICON);
        this.searchButton.setHoveredIcon(HOVERED_SEARCH_ICON);
        this.searchButton.setDisabledIcon(DISABLED_SEARCH_ICON);
        this.importButton = new GSButton(IMPORT_TEXT);
        this.exportButton = new GSButton(EXPORT_TEXT);
        this.newButton = new GSButton(NEW_TEXT);
        this.editButton = new GSButton(EDIT_TEXT);
        this.duplicateButton = new GSButton(DUPLICATE_TEXT);
        this.deleteButton = new GSButton(DELETE_TEXT);
        this.selectedHandleChanged(null);
        this.initLayout();
        this.initEventListeners();
    }

    private GSITableModel createTableModel(String pattern) {
        Collection<GSAssetInfo> filtered;
        if (pattern == null || pattern.isEmpty()) {
            filtered = this.history.asCollection();
        } else {
            filtered = new GSFilteredSet<GSAssetInfo>(new GSAssetSearchFilter(pattern));
            filtered.addAll(this.history.asCollection());
        }
        GSBasicTableModel model = new GSBasicTableModel(TABLE_TITLES.length, filtered.size());
        for (int c = 0; c < TABLE_TITLES.length; ++c) {
            GSITableColumn column = model.getColumn(c);
            column.setHeaderValue((Object)TABLE_TITLES[c]);
            column.setTextAlignment(GSETextAlignment.LEFT);
            column.setMinimumWidth(TABLE_WIDTHS[c]);
            if (c == NAME_COLUMN_INDEX) continue;
            column.setMaximumWidth(TABLE_WIDTHS[c]);
        }
        model.setRowHeaderHidden(true);
        int r = 0;
        for (GSAssetInfo info : filtered) {
            GSEAssetNamespace namespace = info.getHandle().getNamespace();
            model.setCellValue(NAME_COLUMN_INDEX, r, (Object)info.getAssetName());
            model.setCellValue(OWNER_UUID_COLUMN_INDEX, r, (Object)this.playerCache.getNameText(info.getOwnerUUID()));
            model.setCellValue(CREATED_COLUMN_INDEX, r, (Object)Instant.ofEpochMilli(info.getCreatedTimestamp()));
            model.setCellValue(MODIFIED_COLUMN_INDEX, r, (Object)Instant.ofEpochMilli(info.getLastModifiedTimestamp()));
            model.setCellValue(NAMESPACE_COLUMN_INDEX, r, (Object)NAMESPACE_TEXTS[namespace.getIndex()]);
            model.setCellValue(HANDLE_COLUMN_INDEX, r, (Object)info.getHandle().toString());
            if (info.getTypeIndex() >= TYPE_TEXTS.length) {
                model.setCellValue(TYPE_COLUMN_INDEX, r, (Object)UNKNOWN_TYPE_TEXT);
            } else {
                model.setCellValue(TYPE_COLUMN_INDEX, r, (Object)TYPE_TEXTS[info.getTypeIndex()]);
            }
            ++r;
        }
        return model;
    }

    private void initLayout() {
        this.setLayoutManager((GSILayoutManager)new GSGridLayoutManager());
        GSTextLabel historyTitle = new GSTextLabel(ASSET_HISTORY_TITLE);
        historyTitle.getLayout().set(GSGridLayoutManager.GRID_Y, (Object)0).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)10).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.WEST);
        this.add((GSPanel)historyTitle);
        GSParentPanel topButtonPanel = new GSParentPanel((GSILayoutManager)new GSGridLayoutManager());
        this.importButton.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(PREFERRED_WIDTH, (Object)75);
        topButtonPanel.add((GSPanel)this.importButton);
        this.exportButton.getLayout().set(GSGridLayoutManager.GRID_X, (Object)1).set(GSGridLayoutManager.LEFT_MARGIN, (Object)5).set(PREFERRED_WIDTH, (Object)75);
        topButtonPanel.add((GSPanel)this.exportButton);
        this.searchField.getLayout().set(GSGridLayoutManager.GRID_X, (Object)2).set(GSGridLayoutManager.WEIGHT_X, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.FILL, (Object)GSEFill.VERTICAL).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.EAST).set(PREFERRED_WIDTH, (Object)200);
        topButtonPanel.add((GSPanel)this.searchField);
        this.searchButton.getLayout().set(GSGridLayoutManager.GRID_X, (Object)3).set(GSGridLayoutManager.FILL, (Object)GSEFill.VERTICAL).set(PREFERRED_WIDTH, (Object)((Integer)this.importButton.getProperty(PREFERRED_HEIGHT)));
        topButtonPanel.add((GSPanel)this.searchButton);
        topButtonPanel.getLayout().set(GSGridLayoutManager.GRID_Y, (Object)1).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)10).set(GSGridLayoutManager.WEIGHT_X, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.FILL, (Object)GSEFill.HORIZONTAL);
        this.add((GSPanel)topButtonPanel);
        GSScrollPanel scrollPanel = new GSScrollPanel((GSPanel)this.table);
        scrollPanel.getLayout().set(GSGridLayoutManager.GRID_Y, (Object)2).set(GSGridLayoutManager.WEIGHT_X, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.WEIGHT_Y, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)10).set(GSGridLayoutManager.FILL, (Object)GSEFill.BOTH);
        this.add((GSPanel)scrollPanel);
        GSParentPanel bottomButtonPanel = new GSParentPanel((GSILayoutManager)new GSGridLayoutManager());
        this.newButton.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(PREFERRED_WIDTH, (Object)75);
        bottomButtonPanel.add((GSPanel)this.newButton);
        this.editButton.getLayout().set(GSGridLayoutManager.GRID_X, (Object)1).set(GSGridLayoutManager.LEFT_MARGIN, (Object)5).set(PREFERRED_WIDTH, (Object)75);
        bottomButtonPanel.add((GSPanel)this.editButton);
        this.duplicateButton.getLayout().set(GSGridLayoutManager.GRID_X, (Object)2).set(GSGridLayoutManager.LEFT_MARGIN, (Object)5).set(PREFERRED_WIDTH, (Object)75);
        bottomButtonPanel.add((GSPanel)this.duplicateButton);
        this.deleteButton.getLayout().set(GSGridLayoutManager.GRID_X, (Object)3).set(GSGridLayoutManager.WEIGHT_X, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.LEFT_MARGIN, (Object)5).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.EAST).set(PREFERRED_WIDTH, (Object)75);
        bottomButtonPanel.add((GSPanel)this.deleteButton);
        bottomButtonPanel.getLayout().set(GSGridLayoutManager.GRID_Y, (Object)3).set(GSGridLayoutManager.WEIGHT_X, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.FILL, (Object)GSEFill.HORIZONTAL);
        this.add((GSPanel)bottomButtonPanel);
    }

    private void initEventListeners() {
        this.importButton.addActionListener(() -> {
            GSFileDialog dialog = GSFileDialog.showOpenDialog(null);
            dialog.setFileNameFilter(GSA_FILE_NAME_FILTER);
            dialog.addActionListener(() -> {
                if (!dialog.isCanceled()) {
                    this.importAsset(dialog.getSelectedPath());
                }
            });
        });
        this.exportButton.addActionListener(() -> {
            GSFileDialog dialog = GSFileDialog.showSaveDialog(null);
            dialog.setFileNameFilter(GSA_FILE_NAME_FILTER);
            dialog.addActionListener(() -> {
                if (!dialog.isCanceled()) {
                    this.exportAsset(dialog.getSelectedPath());
                }
            });
        });
        this.newButton.addActionListener(() -> GSCreateAssetPanel.show(null, this.assetManager));
        this.editButton.addActionListener(this::editSelection);
        this.duplicateButton.addActionListener(() -> {
            GSAssetInfo info = this.history.getFromHandle(this.selectedHandle);
            if (info != null && info.getType() != null) {
                GSCreateAssetPanel.show(null, this.assetManager, info);
            } else {
                GSConfirmDialog.showOkDialog(null, (class_2561)DUPLICATE_FAILED_TEXT);
            }
        });
        this.deleteButton.addActionListener(() -> {
            GSAssetInfo info = this.history.getFromHandle(this.selectedHandle);
            if (info != null) {
                this.confirmDeletion(info);
            } else {
                GSConfirmDialog.showOkDialog(null, (class_2561)DELETE_FAILED_TEXT);
            }
        });
        this.searchField.addChangeListener(this::updateTableModel);
        this.searchButton.addActionListener(this::updateTableModel);
        this.table.addActionListener(this::editSelection);
        this.table.getRowSelectionModel().addListener(this::onSelectionChanged);
    }

    private void importAsset(Path path) {
        GSDecodedAssetFile assetFile = null;
        try {
            assetFile = (GSDecodedAssetFile)GSFileUtil.readFile((File)path.toFile(), GSDecodedAssetFile::read);
        }
        catch (IOException e) {
            CapturePlaybackMod.GSCP_LOGGER.warn("Unable to import asset", (Throwable)e);
        }
        if (assetFile != null) {
            GSCreateAssetPanel.show(null, this.assetManager, assetFile);
        } else {
            GSConfirmDialog.showOkDialog(null, (class_2561)IMPORT_FAILED_TEXT);
        }
    }

    private void exportAsset(Path path) {
        GSAssetInfo info = this.history.getFromHandle(this.selectedHandle);
        if (info != null) {
            this.assetManager.requestAsset(info.getAssetUUID(), assetFile -> {
                if (assetFile != null) {
                    try {
                        GSFileUtil.writeFile((File)path.toFile(), (Object)assetFile, GSDecodedAssetFile::write);
                    }
                    catch (IOException e) {
                        CapturePlaybackMod.GSCP_LOGGER.warn("Unable to export asset ({})", (Object)assetFile.getAsset().getUUID(), (Object)e);
                    }
                } else {
                    GSConfirmDialog.showOkDialog(null, (class_2561)EXPORT_DENIED_TEXT);
                }
            });
        } else {
            GSConfirmDialog.showOkDialog(null, (class_2561)EXPORT_FAILED_TEXT);
        }
    }

    private void editSelection() {
        GSAssetInfo info = this.history.getFromHandle(this.selectedHandle);
        if (info != null && info.getType() != null) {
            this.assetManager.requestSession(GSESessionRequestType.REQUEST_START, info.getAssetUUID());
        } else {
            GSConfirmDialog.showOkDialog(null, (class_2561)EDIT_FAILED_TEXT);
        }
    }

    private void confirmDeletion(GSAssetInfo info) {
        class_2561 title = GSCapturePlaybackPanel.translatable("confirmDelete", info.getAssetName());
        GSConfirmDialog dialog = GSConfirmDialog.showDialog(null, (class_2561)title, (GSConfirmOption[])GSConfirmDialog.YES_CANCEL_OPTIONS);
        GSTextLabel content = new GSTextLabel(CONFIRM_DESCRIPTION);
        content.setTextAlignment(GSETextAlignment.LEFT);
        dialog.setContent((GSPanel)content);
        dialog.addActionListener(() -> {
            GSConfirmOption option;
            if (dialog.hasSelection() && (option = dialog.getSelectedOption()) == GSConfirmOption.YES) {
                this.assetManager.deleteAsset(info.getAssetUUID());
            }
        });
    }

    protected void onShown() {
        super.onShown();
        this.history.addListener(this);
        this.onHistoryChanged(null);
        this.table.requestFocus();
    }

    protected void onHidden() {
        super.onHidden();
        this.history.removeListener(this);
    }

    @Override
    public void onHistoryChanged(UUID assetUUID) {
        this.updateTableModel();
    }

    private void updateTableModel() {
        GSAssetHandle oldSelectedHandle = this.selectedHandle;
        String pattern = this.searchField.getText();
        pattern = StringUtils.normalizeSpace((String)pattern);
        this.table.setModel(this.createTableModel(pattern));
        this.setSelectedHandle(oldSelectedHandle);
        if (this.selectedHandle == null && this.table.getModel().getRowCount() > 0) {
            this.table.setSelectedRows(0, 0);
        }
    }

    public void onSelectionChanged() {
        GSITableModel model = this.table.getModel();
        GSAssetHandle handleToSelect = null;
        int selectedRow = this.table.getRowSelectionModel().getIntervalMin();
        if (selectedRow >= 0 && selectedRow < model.getRowCount()) {
            String str = (String)model.getCellValue(HANDLE_COLUMN_INDEX, selectedRow);
            try {
                handleToSelect = GSAssetHandle.fromString(str);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
        this.selectedHandleChanged(handleToSelect);
    }

    private void selectedHandleChanged(GSAssetHandle handle) {
        this.selectedHandle = handle;
        GSAssetInfo info = handle != null ? this.history.getFromHandle(handle) : null;
        boolean enableAccessButtons = info != null && this.assetManager.hasPermission(info.getAssetUUID());
        this.exportButton.setEnabled(enableAccessButtons);
        this.editButton.setEnabled(enableAccessButtons);
        this.duplicateButton.setEnabled(enableAccessButtons);
        boolean enableDeleteButton = info != null && this.assetManager.hasExtendedPermission(info.getAssetUUID());
        this.deleteButton.setEnabled(enableDeleteButton);
        this.assetPermPanel.setInfo(info);
    }

    private void setSelectedHandle(GSAssetHandle handle) {
        int rowToSelect = -1;
        if (handle != null) {
            String str = handle.toString();
            GSITableModel model = this.table.getModel();
            for (int r = 0; r < model.getRowCount(); ++r) {
                if (!str.equals(model.getCellValue(HANDLE_COLUMN_INDEX, r))) continue;
                rowToSelect = r;
                break;
            }
        }
        this.table.setSelectedRows(rowToSelect, rowToSelect);
    }

    static {
        UNKNOWN_TYPE_TEXT = GSCapturePlaybackPanel.translatable("type.unknown");
        SEARCH_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(27, 0, 11, 11));
        HOVERED_SEARCH_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(27, 11, 11, 11));
        DISABLED_SEARCH_ICON = new GSTexturedIcon(GSCapturePlaybackPanel.ICONS_SHEET.getRegion(27, 22, 11, 11));
        IMPORT_TEXT = GSCapturePlaybackPanel.translatable("import");
        EXPORT_TEXT = GSCapturePlaybackPanel.translatable("export");
        NEW_TEXT = GSCapturePlaybackPanel.translatable("new");
        EDIT_TEXT = GSCapturePlaybackPanel.translatable("edit");
        DUPLICATE_TEXT = GSCapturePlaybackPanel.translatable("duplicate");
        DELETE_TEXT = GSCapturePlaybackPanel.translatable("delete");
        CONFIRM_DESCRIPTION = GSCapturePlaybackPanel.translatable("confirmDesc");
        IMPORT_FAILED_TEXT = GSCapturePlaybackPanel.translatable("importFailed");
        EXPORT_FAILED_TEXT = GSCapturePlaybackPanel.translatable("exportFailed");
        EXPORT_DENIED_TEXT = GSCapturePlaybackPanel.translatable("exportDenied");
        DUPLICATE_FAILED_TEXT = GSCapturePlaybackPanel.translatable("duplicateFailed");
        DELETE_FAILED_TEXT = GSCapturePlaybackPanel.translatable("deleteFailed");
        EDIT_FAILED_TEXT = GSCapturePlaybackPanel.translatable("editFailed");
        GSA_FILE_NAME_FILTER = new GSFileExtensionFilter(new String[]{"gsa"});
        int titleCount = 0;
        NAME_COLUMN_INDEX = titleCount++;
        TYPE_COLUMN_INDEX = titleCount++;
        OWNER_UUID_COLUMN_INDEX = titleCount++;
        HANDLE_COLUMN_INDEX = titleCount++;
        MODIFIED_COLUMN_INDEX = titleCount++;
        CREATED_COLUMN_INDEX = titleCount++;
        NAMESPACE_COLUMN_INDEX = titleCount++;
        TABLE_TITLES = new class_2561[titleCount];
        GSAssetHistoryPanel.TABLE_TITLES[GSAssetHistoryPanel.NAME_COLUMN_INDEX] = GSCapturePlaybackPanel.translatable("name");
        GSAssetHistoryPanel.TABLE_TITLES[GSAssetHistoryPanel.OWNER_UUID_COLUMN_INDEX] = GSCapturePlaybackPanel.translatable("ownerUUID");
        GSAssetHistoryPanel.TABLE_TITLES[GSAssetHistoryPanel.MODIFIED_COLUMN_INDEX] = GSCapturePlaybackPanel.translatable("modified");
        GSAssetHistoryPanel.TABLE_TITLES[GSAssetHistoryPanel.CREATED_COLUMN_INDEX] = GSCapturePlaybackPanel.translatable("created");
        GSAssetHistoryPanel.TABLE_TITLES[GSAssetHistoryPanel.NAMESPACE_COLUMN_INDEX] = GSCapturePlaybackPanel.translatable("namespace");
        GSAssetHistoryPanel.TABLE_TITLES[GSAssetHistoryPanel.HANDLE_COLUMN_INDEX] = GSCapturePlaybackPanel.translatable("handle");
        GSAssetHistoryPanel.TABLE_TITLES[GSAssetHistoryPanel.TYPE_COLUMN_INDEX] = GSCapturePlaybackPanel.translatable("type");
        TABLE_WIDTHS = new int[titleCount];
        GSAssetHistoryPanel.TABLE_WIDTHS[GSAssetHistoryPanel.NAME_COLUMN_INDEX] = 100;
        GSAssetHistoryPanel.TABLE_WIDTHS[GSAssetHistoryPanel.OWNER_UUID_COLUMN_INDEX] = 100;
        GSAssetHistoryPanel.TABLE_WIDTHS[GSAssetHistoryPanel.MODIFIED_COLUMN_INDEX] = 110;
        GSAssetHistoryPanel.TABLE_WIDTHS[GSAssetHistoryPanel.CREATED_COLUMN_INDEX] = 110;
        GSAssetHistoryPanel.TABLE_WIDTHS[GSAssetHistoryPanel.NAMESPACE_COLUMN_INDEX] = 60;
        GSAssetHistoryPanel.TABLE_WIDTHS[GSAssetHistoryPanel.HANDLE_COLUMN_INDEX] = 140;
        GSAssetHistoryPanel.TABLE_WIDTHS[GSAssetHistoryPanel.TYPE_COLUMN_INDEX] = 70;
        GSEAssetType[] assetTypes = GSEAssetType.values();
        TYPE_TEXTS = new class_2561[assetTypes.length];
        for (GSEAssetType type : assetTypes) {
            GSAssetHistoryPanel.TYPE_TEXTS[type.getIndex()] = GSCapturePlaybackPanel.translatable("type." + type.getName());
        }
        GSEAssetNamespace[] namespaces = GSEAssetNamespace.values();
        NAMESPACE_TEXTS = new class_2561[namespaces.length];
        for (GSEAssetNamespace namespace : namespaces) {
            GSAssetHistoryPanel.NAMESPACE_TEXTS[namespace.getIndex()] = GSCapturePlaybackPanel.translatable("namespace." + namespace.getName());
        }
    }

    private static class GSAssetSearchFilter
    extends GSSearchFilter<GSAssetInfo> {
        public GSAssetSearchFilter(String pattern) {
            super(pattern);
        }

        @Override
        protected int matchCost(GSAssetInfo info) {
            GSEAssetType type = info.getType();
            if (type != null && this.pattern.equals(type.getName())) {
                return 0;
            }
            int cost = Integer.MAX_VALUE;
            cost = Math.min(cost, this.minimumMatchCost(info.getAssetName()));
            cost = Math.min(cost, this.minimumMatchCost(info.getHandle().toString()));
            return cost;
        }
    }
}

