/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.gui;

import com.g4mesoft.captureplayback.common.asset.GSAssetHandle;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSDecodedAssetFile;
import com.g4mesoft.captureplayback.common.asset.GSEAssetNamespace;
import com.g4mesoft.captureplayback.common.asset.GSEAssetType;
import com.g4mesoft.captureplayback.common.asset.GSIAssetHistory;
import com.g4mesoft.captureplayback.gui.GSAssetHistoryPanel;
import com.g4mesoft.captureplayback.gui.GSCapturePlaybackPanel;
import com.g4mesoft.captureplayback.module.client.GSClientAssetManager;
import com.g4mesoft.ui.panel.GSEAnchor;
import com.g4mesoft.ui.panel.GSEFill;
import com.g4mesoft.ui.panel.GSEPopupPlacement;
import com.g4mesoft.ui.panel.GSGridLayoutManager;
import com.g4mesoft.ui.panel.GSILayoutManager;
import com.g4mesoft.ui.panel.GSPanel;
import com.g4mesoft.ui.panel.GSPanelContext;
import com.g4mesoft.ui.panel.GSParentPanel;
import com.g4mesoft.ui.panel.GSPopup;
import com.g4mesoft.ui.panel.button.GSButton;
import com.g4mesoft.ui.panel.dropdown.GSDropdownList;
import com.g4mesoft.ui.panel.event.GSIButtonStroke;
import com.g4mesoft.ui.panel.event.GSKeyButtonStroke;
import com.g4mesoft.ui.panel.field.GSTextField;
import com.g4mesoft.ui.panel.field.GSTextLabel;
import com.g4mesoft.ui.renderer.GSIRenderer2D;
import java.util.UUID;
import net.minecraft.class_2561;

public class GSCreateAssetPanel
extends GSParentPanel {
    private static final int BACKGROUND_COLOR = -14342874;
    private static final class_2561 CREATE_TITLE = GSCapturePlaybackPanel.translatable("popup.createTitle");
    private static final class_2561 DUPLICATE_TITLE = GSCapturePlaybackPanel.translatable("popup.duplicateTitle");
    private static final class_2561 IMPORT_TITLE = GSCapturePlaybackPanel.translatable("popup.importTitle");
    private static final class_2561 NAME_TEXT = GSCapturePlaybackPanel.translatable("popup.name");
    private static final class_2561 TYPE_TEXT = GSCapturePlaybackPanel.translatable("popup.type");
    private static final class_2561 NAMESPACE_TEXT = GSCapturePlaybackPanel.translatable("popup.namespace");
    private static final class_2561 HANDLE_TEXT = GSCapturePlaybackPanel.translatable("popup.handle");
    private static final class_2561 CREATE_TEXT = GSCapturePlaybackPanel.translatable("create");
    private static final class_2561 CANCEL_TEXT = GSCapturePlaybackPanel.translatable("cancel");
    private static final int OUTER_MARGIN = 10;
    private static final int TITLE_MARGIN = 10;
    private static final int BUTTON_MARGIN = 5;
    private static final int FIELD_MARGIN = 5;
    private static final int FIELD_WIDTH = 135;
    private static final String NAME_COPY_KEY = "gui.tab.capture-playback.nameCopy";
    private final GSClientAssetManager assetManager;
    private final GSIAssetHistory history;
    private GSAssetInfo originalInfo;
    private GSDecodedAssetFile assetFile;
    private final GSTextLabel titleLabel;
    private final GSTextField nameField;
    private final GSDropdownList<class_2561> typeField;
    private final GSDropdownList<class_2561> namespaceField;
    private final GSTextField handleField;
    private final GSButton createButton;
    private final GSButton cancelButton;

    private GSCreateAssetPanel(GSClientAssetManager assetManager) {
        this.assetManager = assetManager;
        this.history = assetManager.getAssetHistory();
        this.titleLabel = new GSTextLabel(CREATE_TEXT);
        this.nameField = new GSTextField();
        this.typeField = new GSDropdownList((Object[])GSAssetHistoryPanel.TYPE_TEXTS);
        this.typeField.setEmptySelectionAllowed(false);
        this.namespaceField = new GSDropdownList((Object[])GSAssetHistoryPanel.NAMESPACE_TEXTS);
        this.namespaceField.setEmptySelectionAllowed(false);
        this.handleField = new GSTextField();
        this.createButton = new GSButton(CREATE_TEXT);
        this.cancelButton = new GSButton(CANCEL_TEXT);
        this.handleField.setEditable(false);
        this.initLayout();
        this.initEventListeners();
    }

    private GSCreateAssetPanel(GSClientAssetManager assetManager, GSAssetInfo originalInfo) {
        this(assetManager);
        this.originalInfo = originalInfo;
        this.titleLabel.setText(originalInfo != null ? DUPLICATE_TITLE : CREATE_TITLE);
        if (originalInfo != null) {
            if (originalInfo.getType() == null) {
                throw new IllegalArgumentException("Unknown asset type!");
            }
            this.nameField.setText(this.copyOfName(originalInfo.getAssetName()));
            this.typeField.setSelectedIndex(originalInfo.getType().getIndex());
            this.namespaceField.setSelectedIndex(originalInfo.getHandle().getNamespace().getIndex());
            this.typeField.setEnabled(false);
        } else {
            this.updateHandle();
        }
    }

    private GSCreateAssetPanel(GSClientAssetManager assetManager, GSDecodedAssetFile assetFile) {
        this(assetManager);
        if (assetFile == null) {
            throw new IllegalArgumentException("assetFile is null");
        }
        this.assetFile = assetFile;
        this.titleLabel.setText(IMPORT_TITLE);
        this.nameField.setText(assetFile.getAsset().getName());
        this.typeField.setSelectedIndex(assetFile.getHeader().getType().getIndex());
        this.typeField.setEnabled(false);
    }

    private void initLayout() {
        this.setLayoutManager((GSILayoutManager)new GSGridLayoutManager());
        this.titleLabel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)0).set(GSGridLayoutManager.GRID_WIDTH, (Object)2).set(GSGridLayoutManager.TOP_MARGIN, (Object)10).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)10);
        this.add((GSPanel)this.titleLabel);
        GSParentPanel contentPanel = new GSParentPanel();
        contentPanel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)1).set(GSGridLayoutManager.GRID_WIDTH, (Object)2).set(GSGridLayoutManager.WEIGHT_Y, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.FILL, (Object)GSEFill.BOTH).set(GSGridLayoutManager.LEFT_MARGIN, (Object)10).set(GSGridLayoutManager.RIGHT_MARGIN, (Object)10);
        this.add((GSPanel)contentPanel);
        this.createButton.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)2).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.WEST).set(GSGridLayoutManager.TOP_MARGIN, (Object)5).set(GSGridLayoutManager.LEFT_MARGIN, (Object)10).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)10);
        this.add((GSPanel)this.createButton);
        this.cancelButton.getLayout().set(GSGridLayoutManager.GRID_X, (Object)1).set(GSGridLayoutManager.GRID_Y, (Object)2).set(GSGridLayoutManager.WEIGHT_X, (Object)Float.valueOf(1.0f)).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.EAST).set(GSGridLayoutManager.TOP_MARGIN, (Object)5).set(GSGridLayoutManager.LEFT_MARGIN, (Object)5).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)10).set(GSGridLayoutManager.RIGHT_MARGIN, (Object)10);
        this.add((GSPanel)this.cancelButton);
        this.initContentLayout((GSPanel)contentPanel);
        this.setProperty(PREFERRED_HEIGHT, 200);
    }

    private void initContentLayout(GSPanel contentPanel) {
        contentPanel.setLayoutManager((GSILayoutManager)new GSGridLayoutManager());
        int gridY = 0;
        GSTextLabel nameLabel = new GSTextLabel(NAME_TEXT);
        nameLabel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)gridY).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.WEST).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)5).set(GSGridLayoutManager.RIGHT_MARGIN, (Object)5);
        contentPanel.add((GSPanel)nameLabel);
        this.nameField.getLayout().set(GSGridLayoutManager.GRID_X, (Object)1).set(GSGridLayoutManager.GRID_Y, (Object)gridY++).set(GSGridLayoutManager.FILL, (Object)GSEFill.HORIZONTAL).set(GSGridLayoutManager.LEFT_MARGIN, (Object)5).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)5).set(GSGridLayoutManager.PREFERRED_WIDTH, (Object)135);
        contentPanel.add((GSPanel)this.nameField);
        GSTextLabel typeLabel = new GSTextLabel(TYPE_TEXT);
        typeLabel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)gridY).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.WEST).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)5).set(GSGridLayoutManager.RIGHT_MARGIN, (Object)5);
        contentPanel.add((GSPanel)typeLabel);
        this.typeField.getLayout().set(GSGridLayoutManager.GRID_X, (Object)1).set(GSGridLayoutManager.GRID_Y, (Object)gridY++).set(GSGridLayoutManager.FILL, (Object)GSEFill.HORIZONTAL).set(GSGridLayoutManager.LEFT_MARGIN, (Object)5).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)5);
        contentPanel.add(this.typeField);
        GSTextLabel namespaceLabel = new GSTextLabel(NAMESPACE_TEXT);
        namespaceLabel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)gridY).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.WEST).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)5).set(GSGridLayoutManager.RIGHT_MARGIN, (Object)5);
        contentPanel.add((GSPanel)namespaceLabel);
        this.namespaceField.getLayout().set(GSGridLayoutManager.GRID_X, (Object)1).set(GSGridLayoutManager.GRID_Y, (Object)gridY++).set(GSGridLayoutManager.FILL, (Object)GSEFill.HORIZONTAL).set(GSGridLayoutManager.LEFT_MARGIN, (Object)5).set(GSGridLayoutManager.BOTTOM_MARGIN, (Object)5);
        contentPanel.add(this.namespaceField);
        GSTextLabel handleLabel = new GSTextLabel(HANDLE_TEXT);
        handleLabel.getLayout().set(GSGridLayoutManager.GRID_X, (Object)0).set(GSGridLayoutManager.GRID_Y, (Object)gridY).set(GSGridLayoutManager.ANCHOR, (Object)GSEAnchor.WEST).set(GSGridLayoutManager.RIGHT_MARGIN, (Object)5);
        contentPanel.add((GSPanel)handleLabel);
        this.handleField.getLayout().set(GSGridLayoutManager.GRID_X, (Object)1).set(GSGridLayoutManager.GRID_Y, (Object)gridY++).set(GSGridLayoutManager.FILL, (Object)GSEFill.HORIZONTAL).set(GSGridLayoutManager.LEFT_MARGIN, (Object)5).set(GSGridLayoutManager.PREFERRED_WIDTH, (Object)135);
        contentPanel.add((GSPanel)this.handleField);
    }

    private void initEventListeners() {
        this.nameField.addChangeListener(this::updateHandle);
        this.namespaceField.addChangeListener(this::updateHandle);
        this.createButton.addActionListener(this::createAndHide);
        this.cancelButton.addActionListener(this::hide);
        this.putButtonStroke((GSIButtonStroke)new GSKeyButtonStroke(257), this::createAndHide);
        this.putButtonStroke((GSIButtonStroke)new GSKeyButtonStroke(256), this::hide);
    }

    private void updateHandle() {
        String name = this.getName();
        GSEAssetNamespace namespace = this.getNamespace();
        GSAssetHandle handle = GSAssetHandle.fromNameUnique(namespace, name, this.history::containsHandle);
        this.handleField.setText(handle.toString());
    }

    private String copyOfName(String name) {
        return GSPanelContext.i18nTranslateFormatted((String)NAME_COPY_KEY, (Object[])new Object[]{name});
    }

    public String getName() {
        return this.nameField.getText();
    }

    public GSEAssetType getType() {
        int index = this.typeField.getSelectedIndex();
        return GSEAssetType.fromIndex(index);
    }

    public GSEAssetNamespace getNamespace() {
        int index = this.namespaceField.getSelectedIndex();
        return GSEAssetNamespace.fromIndex(index);
    }

    public GSAssetHandle getHandle() {
        GSAssetHandle handle = null;
        try {
            handle = GSAssetHandle.fromString(this.handleField.getText());
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        return handle;
    }

    private void createAndHide() {
        if (this.assetFile != null) {
            this.assetManager.importAsset(this.getName(), this.getHandle(), this.assetFile);
        } else {
            UUID originalAssetUUID = this.originalInfo != null ? this.originalInfo.getAssetUUID() : null;
            this.assetManager.createAsset(this.getName(), this.getType(), this.getHandle(), originalAssetUUID);
        }
        this.hide();
    }

    public void render(GSIRenderer2D renderer) {
        renderer.fillRect(0, 0, this.width, this.height, -14342874);
        super.render(renderer);
    }

    public static GSCreateAssetPanel show(GSPanel source, GSClientAssetManager assetManager) {
        return GSCreateAssetPanel.show(source, new GSCreateAssetPanel(assetManager, (GSAssetInfo)null));
    }

    public static GSCreateAssetPanel show(GSPanel source, GSClientAssetManager assetManager, GSAssetInfo originalInfo) {
        return GSCreateAssetPanel.show(source, new GSCreateAssetPanel(assetManager, originalInfo));
    }

    public static GSCreateAssetPanel show(GSPanel source, GSClientAssetManager assetManager, GSDecodedAssetFile assetFile) {
        return GSCreateAssetPanel.show(source, new GSCreateAssetPanel(assetManager, assetFile));
    }

    private static GSCreateAssetPanel show(GSPanel source, GSCreateAssetPanel panel) {
        GSPopup popup = new GSPopup((GSPanel)panel, true);
        popup.setHiddenOnFocusLost(false);
        popup.setSourceFocusedOnHide(source != null);
        popup.show(source, 0, 0, GSEPopupPlacement.CENTER);
        return panel;
    }

    public void hide() {
        GSPanel parent = this.getParent();
        if (parent instanceof GSPopup) {
            ((GSPopup)parent).hide();
        }
    }
}

