/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.gui;

import java.util.Comparator;

public abstract class GSSearchFilter<T extends Comparable<T>>
implements Comparator<T> {
    protected static final float NO_INSERTIONS_ALLOWED = 0.0f;
    protected static final float HALF_INSERTIONS_ALLOWED = 0.5f;
    private static final int VALUE_INDEX_MASK = 3;
    private static final int SUBSTITUTION_COST = 4;
    private static final int INSERTION_COST = 3;
    private static final int DELETION_COST = 1;
    private static final int LATE_DELETION_COST = 10;
    private static final int TRANSPOSITION_COST = 1;
    protected final String pattern;
    private final int[][] dists;

    public GSSearchFilter(String pattern) {
        if (pattern == null) {
            throw new IllegalArgumentException("pattern is null!");
        }
        this.pattern = pattern.toLowerCase();
        this.dists = new int[4][this.pattern.length() + 1];
    }

    protected abstract int matchCost(T var1);

    public final boolean filter(T o) {
        return this.matchCost(o) != Integer.MAX_VALUE;
    }

    @Override
    public final int compare(T o1, T o2) {
        int c2;
        int c1 = this.matchCost(o1);
        return c1 != (c2 = this.matchCost(o2)) ? Integer.compare(c1, c2) : o1.compareTo(o2);
    }

    protected final int minimumMatchCost(String value) {
        return this.minimumMatchCost(value, 0.5f);
    }

    protected final int minimumMatchCost(String value, float insertFraction) {
        int mxLength;
        if (this.pattern.isEmpty()) {
            return 0;
        }
        int cost = this.weightedEditDistance(value);
        if (cost >= (mxLength = Math.max(value.length(), this.pattern.length())) * 4) {
            return Integer.MAX_VALUE;
        }
        int rel = cost - (mxLength - this.pattern.length()) * 1;
        if ((float)rel > (float)(this.pattern.length() * 3) * insertFraction) {
            return Integer.MAX_VALUE;
        }
        return rel;
    }

    protected final int weightedEditDistance(String value) {
        int n = value.length();
        int m = this.pattern.length();
        if (n == 0 || m == 0) {
            return n * 1 + m * 3;
        }
        this.dists[0][0] = 0;
        for (int j = 1; j <= m; ++j) {
            this.dists[0][j] = j * 3;
        }
        for (int i = 1; i <= n; ++i) {
            char si = Character.toLowerCase(value.charAt(i - 1));
            int q = i & 3;
            int qm1 = i - 1 & 3;
            this.dists[q][0] = i * 1;
            for (int j = 1; j <= m; ++j) {
                char pj = this.pattern.charAt(j - 1);
                int mnDist = pj == si ? this.dists[qm1][j - 1] : this.dists[qm1][j - 1] + 4;
                mnDist = j > 1 && j < m ? Math.min(mnDist, this.dists[qm1][j] + 10) : Math.min(mnDist, this.dists[qm1][j] + 1);
                mnDist = Math.min(mnDist, this.dists[q][j - 1] + 3);
                if (i > 1 && j > 1) {
                    char sim1 = Character.toLowerCase(value.charAt(i - 2));
                    char pjm1 = this.pattern.charAt(j - 2);
                    if (sim1 == pj && pjm1 == si) {
                        int qm2 = i - 2 & 3;
                        mnDist = Math.min(mnDist, this.dists[qm2][j - 2] + 1);
                    }
                }
                this.dists[q][j] = mnDist;
            }
        }
        return this.dists[n & 3][m];
    }
}

