/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.gui;

import com.g4mesoft.ui.panel.scroll.GSAbstractScrollBarModel;
import com.g4mesoft.ui.util.GSMathUtil;

public class GSUnlimitedScrollBarModel
extends GSAbstractScrollBarModel {
    private static final float DEFAULT_BLOCK_SCROLL = 20.0f;
    private static final float DEFAULT_MIN_SCROLL = 0.0f;
    private static final float DEFAULT_MAX_SCROLL = 100.0f;
    private float scroll;
    private float minScroll;
    private float maxScroll;
    private float blockScroll;

    public GSUnlimitedScrollBarModel() {
        this(0.0f, 100.0f);
    }

    public GSUnlimitedScrollBarModel(float minScroll, float maxScroll) {
        this(minScroll, minScroll, maxScroll);
    }

    public GSUnlimitedScrollBarModel(float scroll, float minScroll, float maxScroll) {
        this.minScroll = Float.isNaN(minScroll) ? 0.0f : minScroll;
        this.maxScroll = Float.isNaN(maxScroll) ? 100.0f : maxScroll;
        this.blockScroll = 20.0f;
        this.setScroll(scroll);
    }

    public float getScroll() {
        return this.scroll;
    }

    public boolean setScroll(float scroll) {
        if (!GSMathUtil.equalsApproximate((float)(scroll = Float.isNaN(scroll) ? this.minScroll : Math.max(scroll, this.minScroll)), (float)this.scroll)) {
            this.scroll = scroll;
            this.dispatchScrollChanged(this.scroll);
            this.dispatchValueChanged();
            return true;
        }
        return false;
    }

    public float getMinScroll() {
        return this.minScroll;
    }

    public void setMinScroll(float minScroll) {
        this.setScrollInterval(minScroll, this.maxScroll);
    }

    public float getMaxScroll() {
        return Math.max(this.maxScroll, this.scroll);
    }

    public void setMaxScroll(float maxScroll) {
        this.setScrollInterval(this.minScroll, maxScroll);
    }

    public void setScrollInterval(float minScroll, float maxScroll) {
        this.minScroll = Float.isNaN(minScroll) ? 0.0f : minScroll;
        float f = this.maxScroll = Float.isNaN(maxScroll) ? 100.0f : maxScroll;
        if (this.minScroll > this.scroll) {
            this.setScroll(this.minScroll);
        } else {
            this.dispatchValueChanged();
        }
    }

    public float getBlockScroll() {
        return this.blockScroll;
    }

    public void setBlockScroll(float blockScroll) {
        this.blockScroll = Math.max(0.0f, blockScroll);
    }
}

