/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.module.server;

import com.g4mesoft.captureplayback.GSCapturePlaybackExtension;
import com.g4mesoft.captureplayback.access.GSIServerWorldAccess;
import com.g4mesoft.captureplayback.common.asset.GSAssetHandle;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSAssetManager;
import com.g4mesoft.captureplayback.common.asset.GSAssetRef;
import com.g4mesoft.captureplayback.common.asset.GSEAssetType;
import com.g4mesoft.captureplayback.module.server.GSAssetCommand;
import com.g4mesoft.captureplayback.module.server.GSAssetHandleArgumentType;
import com.g4mesoft.captureplayback.module.server.GSCapturePlaybackServerModule;
import com.g4mesoft.captureplayback.module.server.GSStreamableAssetSuggestionProvider;
import com.g4mesoft.captureplayback.stream.GSICaptureStream;
import com.g4mesoft.captureplayback.stream.GSIStream;
import com.g4mesoft.ui.util.GSTextUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public final class GSCaptureCommand {
    private GSCaptureCommand() {
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder command = class_2170.method_9247((String)"capture");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.then(class_2170.method_9247((String)"start").then(class_2170.method_9244((String)"handle", (ArgumentType)GSAssetHandleArgumentType.handle()).suggests((SuggestionProvider)new GSStreamableAssetSuggestionProvider()).executes(context -> GSCaptureCommand.startCapture((class_2168)context.getSource(), GSAssetHandleArgumentType.getHandle((CommandContext<class_2168>)context, "handle")))))).then(class_2170.method_9247((String)"stop").then(class_2170.method_9244((String)"handle", (ArgumentType)GSAssetHandleArgumentType.handle()).suggests((SuggestionProvider)new GSStreamableAssetSuggestionProvider()).executes(context -> GSCaptureCommand.stopCapture((class_2168)context.getSource(), GSAssetHandleArgumentType.getHandle((CommandContext<class_2168>)context, "handle")))))).then(class_2170.method_9247((String)"stopAll").executes(context -> GSCaptureCommand.stopAllCaptures((class_2168)context.getSource())));
        dispatcher.register(command);
    }

    private static int startCapture(class_2168 source, GSAssetHandle handle) throws CommandSyntaxException {
        GSAssetCommand.checkPermission(source, handle);
        GSCapturePlaybackServerModule module = GSCapturePlaybackExtension.getInstance().getServerModule();
        GSAssetManager assetManager = module.getAssetManager();
        GSAssetInfo info = assetManager.getInfoFromHandle(handle);
        if (info == null) {
            source.method_9213((class_2561)GSTextUtil.literal((String)"Asset does not exist."));
            return 0;
        }
        GSEAssetType type = info.getType();
        if (type == null) {
            source.method_9213((class_2561)GSTextUtil.literal((String)"Unknown asset type."));
            return 0;
        }
        if (!type.isStreamable()) {
            source.method_9213((class_2561)GSTextUtil.literal((String)"Asset is not streamable."));
            return 0;
        }
        class_3218 world = source.method_9225();
        if (((GSIServerWorldAccess)world).gcp_hasCaptureStream(info.getAssetUUID())) {
            source.method_9213((class_2561)GSTextUtil.literal((String)("Already capturing '" + String.valueOf(handle) + "'.")));
            return 0;
        }
        GSAssetRef ref = assetManager.requestAsset(info.getAssetUUID());
        if (ref == null) {
            source.method_9213((class_2561)GSTextUtil.literal((String)"Failed to load asset."));
            return 0;
        }
        GSICaptureStream stream = ref.get().getCaptureStream();
        stream.addCloseListener(ref::release);
        ((GSIServerWorldAccess)world).gcp_addCaptureStream(info.getAssetUUID(), stream);
        source.method_9226(() -> GSTextUtil.literal((String)("Capture of " + GSAssetCommand.toNameString(info) + " started.")), true);
        return 1;
    }

    private static int stopCapture(class_2168 source, GSAssetHandle handle) throws CommandSyntaxException {
        GSAssetCommand.checkPermission(source, handle);
        GSCapturePlaybackServerModule module = GSCapturePlaybackExtension.getInstance().getServerModule();
        GSAssetInfo info = module.getAssetManager().getInfoFromHandle(handle);
        if (info == null) {
            source.method_9213((class_2561)GSTextUtil.literal((String)("Asset with handle '" + String.valueOf(handle) + "' does not exist.")));
            return 0;
        }
        class_3218 world = source.method_9225();
        GSICaptureStream stream = ((GSIServerWorldAccess)world).gcp_getCaptureStream(info.getAssetUUID());
        if (stream == null) {
            source.method_9213((class_2561)GSTextUtil.literal((String)"No active capture found."));
            return 0;
        }
        stream.close();
        source.method_9226(() -> GSTextUtil.literal((String)("Capture of " + GSAssetCommand.toNameString(info) + " stopped.")), true);
        return 1;
    }

    private static int stopAllCaptures(class_2168 source) throws CommandSyntaxException {
        GSAssetCommand.checkPermission(source, null);
        class_3218 world = source.method_9225();
        ((GSIServerWorldAccess)world).gcp_getCaptureStreams().forEach(GSIStream::close);
        source.method_9226(() -> GSTextUtil.literal((String)"All captures stopped."), true);
        return 1;
    }
}

