/*
 * Decompiled with CFR 0.152.
 */
package com.g4mesoft.captureplayback.module.server;

import com.g4mesoft.captureplayback.GSCapturePlaybackExtension;
import com.g4mesoft.captureplayback.access.GSIServerWorldAccess;
import com.g4mesoft.captureplayback.common.asset.GSAbstractAsset;
import com.g4mesoft.captureplayback.common.asset.GSAssetHandle;
import com.g4mesoft.captureplayback.common.asset.GSAssetInfo;
import com.g4mesoft.captureplayback.common.asset.GSAssetManager;
import com.g4mesoft.captureplayback.common.asset.GSAssetRef;
import com.g4mesoft.captureplayback.common.asset.GSEAssetType;
import com.g4mesoft.captureplayback.module.server.GSAssetCommand;
import com.g4mesoft.captureplayback.module.server.GSAssetHandleArgumentType;
import com.g4mesoft.captureplayback.module.server.GSCapturePlaybackServerModule;
import com.g4mesoft.captureplayback.module.server.GSStreamableAssetSuggestionProvider;
import com.g4mesoft.captureplayback.stream.GSDelayedPlaybackStream;
import com.g4mesoft.captureplayback.stream.GSIPlaybackStream;
import com.g4mesoft.captureplayback.stream.GSIStream;
import com.g4mesoft.ui.util.GSTextUtil;
import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.suggestion.SuggestionProvider;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_3218;

public final class GSPlaybackCommand {
    private static final int REPEAT_FOREVER = -1;

    private GSPlaybackCommand() {
    }

    public static void registerCommand(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder command = class_2170.method_9247((String)"playback");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.then(class_2170.method_9247((String)"start").then(class_2170.method_9244((String)"handle", (ArgumentType)GSAssetHandleArgumentType.handle()).suggests((SuggestionProvider)new GSStreamableAssetSuggestionProvider()).executes(context -> GSPlaybackCommand.startPlayback((class_2168)context.getSource(), GSAssetHandleArgumentType.getHandle((CommandContext<class_2168>)context, "handle"), 0, 1))))).then(class_2170.method_9247((String)"repeat").then(class_2170.method_9244((String)"handle", (ArgumentType)GSAssetHandleArgumentType.handle()).suggests((SuggestionProvider)new GSStreamableAssetSuggestionProvider()).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"delay", (ArgumentType)IntegerArgumentType.integer((int)0)).executes(context -> GSPlaybackCommand.startPlayback((class_2168)context.getSource(), GSAssetHandleArgumentType.getHandle((CommandContext<class_2168>)context, "handle"), IntegerArgumentType.getInteger((CommandContext)context, (String)"delay"), -1))).then(class_2170.method_9244((String)"count", (ArgumentType)IntegerArgumentType.integer((int)1)).executes(context -> GSPlaybackCommand.startPlayback((class_2168)context.getSource(), GSAssetHandleArgumentType.getHandle((CommandContext<class_2168>)context, "handle"), IntegerArgumentType.getInteger((CommandContext)context, (String)"delay"), IntegerArgumentType.getInteger((CommandContext)context, (String)"count")))))))).then(class_2170.method_9247((String)"stop").then(class_2170.method_9244((String)"handle", (ArgumentType)GSAssetHandleArgumentType.handle()).suggests((SuggestionProvider)new GSStreamableAssetSuggestionProvider()).executes(context -> GSPlaybackCommand.stopPlayback((class_2168)context.getSource(), GSAssetHandleArgumentType.getHandle((CommandContext<class_2168>)context, "handle")))))).then(class_2170.method_9247((String)"stopAll").executes(context -> GSPlaybackCommand.stopAllPlaybacks((class_2168)context.getSource())));
        dispatcher.register(command);
    }

    private static int startPlayback(class_2168 source, GSAssetHandle handle, int delay, int repeatCount) throws CommandSyntaxException {
        GSAssetCommand.checkPermission(source, handle);
        GSCapturePlaybackServerModule module = GSCapturePlaybackExtension.getInstance().getServerModule();
        GSAssetManager assetManager = module.getAssetManager();
        GSAssetInfo info = assetManager.getInfoFromHandle(handle);
        if (info == null) {
            source.method_9213((class_2561)GSTextUtil.literal((String)"Asset does not exist."));
            return 0;
        }
        GSEAssetType type = info.getType();
        if (type == null) {
            source.method_9213((class_2561)GSTextUtil.literal((String)"Unknown asset type."));
            return 0;
        }
        if (!type.isStreamable()) {
            source.method_9213((class_2561)GSTextUtil.literal((String)"Asset is not streamable."));
            return 0;
        }
        class_3218 world = source.method_9225();
        if (((GSIServerWorldAccess)world).gcp_hasPlaybackStream(info.getAssetUUID())) {
            source.method_9213((class_2561)GSTextUtil.literal((String)("Already playing back '" + String.valueOf(handle) + "'.")));
            return 0;
        }
        GSAssetRef ref = assetManager.requestAsset(info.getAssetUUID());
        if (ref == null) {
            source.method_9213((class_2561)GSTextUtil.literal((String)"Failed to load asset."));
            return 0;
        }
        GSPlaybackCommand.startPlaybackImpl(world, ref, delay, repeatCount, true);
        source.method_9226(() -> GSTextUtil.literal((String)("Playback of " + GSAssetCommand.toNameString(info) + " started.")), true);
        return 1;
    }

    private static void startPlaybackImpl(class_3218 world, GSAssetRef ref, int delay, int repeatCount, boolean first) {
        if (repeatCount <= 0 && repeatCount != -1) {
            ref.release();
            return;
        }
        GSAbstractAsset asset = ref.get();
        GSIPlaybackStream stream = first ? asset.getPlaybackStream() : new GSDelayedPlaybackStream(asset.getPlaybackStream(), delay);
        stream.addCloseListener(() -> {
            if (stream.isForceClosed()) {
                ref.release();
            } else if (repeatCount == -1) {
                GSPlaybackCommand.startPlaybackImpl(world, ref, delay, -1, false);
            } else {
                GSPlaybackCommand.startPlaybackImpl(world, ref, delay, repeatCount - 1, false);
            }
        });
        ((GSIServerWorldAccess)world).gcp_addPlaybackStream(asset.getUUID(), stream);
    }

    private static int stopPlayback(class_2168 source, GSAssetHandle handle) throws CommandSyntaxException {
        GSAssetCommand.checkPermission(source, handle);
        GSCapturePlaybackServerModule module = GSCapturePlaybackExtension.getInstance().getServerModule();
        GSAssetInfo info = module.getAssetManager().getInfoFromHandle(handle);
        if (info == null) {
            source.method_9213((class_2561)GSTextUtil.literal((String)("Asset with handle '" + String.valueOf(handle) + "' does not exist.")));
            return 0;
        }
        class_3218 world = source.method_9225();
        GSIPlaybackStream stream = ((GSIServerWorldAccess)world).gcp_getPlaybackStream(info.getAssetUUID());
        if (stream == null) {
            source.method_9213((class_2561)GSTextUtil.literal((String)"No active playback found."));
            return 0;
        }
        stream.close();
        source.method_9226(() -> GSTextUtil.literal((String)("Playback of " + GSAssetCommand.toNameString(info) + " stopped.")), true);
        return 1;
    }

    private static int stopAllPlaybacks(class_2168 source) throws CommandSyntaxException {
        GSAssetCommand.checkPermission(source, null);
        class_3218 world = source.method_9225();
        ((GSIServerWorldAccess)world).gcp_getPlaybackStreams().forEach(GSIStream::close);
        source.method_9226(() -> GSTextUtil.literal((String)"All playbacks stopped."), true);
        return 1;
    }
}

